/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.multileader;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.consensus.ConsensusFactory;
import org.apache.iotdb.consensus.common.ConsensusGroup;
import org.apache.iotdb.consensus.common.Peer;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.config.ConsensusConfig;
import org.apache.iotdb.consensus.multileader.MultiLeaderConsensus;
import org.apache.iotdb.consensus.multileader.util.TestEntry;
import org.apache.iotdb.consensus.multileader.util.TestStateMachine;
import org.apache.ratis.util.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiLeaderConsensusTest {
    private static final long CHECK_POINT_GAP = 500L;
    private final Logger logger = LoggerFactory.getLogger(MultiLeaderConsensusTest.class);
    private final ConsensusGroupId gid = new DataRegionId(1);
    private final List<Peer> peers = Arrays.asList(new Peer(this.gid, 1, new TEndPoint("127.0.0.1", 6000)), new Peer(this.gid, 2, new TEndPoint("127.0.0.1", 6001)), new Peer(this.gid, 3, new TEndPoint("127.0.0.1", 6002)));
    private final List<File> peersStorage = Arrays.asList(new File("target" + File.separator + "1"), new File("target" + File.separator + "2"), new File("target" + File.separator + "3"));
    private final ConsensusGroup group = new ConsensusGroup(this.gid, this.peers);
    private final List<MultiLeaderConsensus> servers = new ArrayList<MultiLeaderConsensus>();
    private final List<TestStateMachine> stateMachines = new ArrayList<TestStateMachine>();

    @Before
    public void setUp() throws Exception {
        for (int i = 0; i < 3; ++i) {
            this.peersStorage.get(i).mkdirs();
            this.stateMachines.add(new TestStateMachine());
        }
        this.initServer();
    }

    @After
    public void tearDown() throws Exception {
        this.stopServer();
        for (File file : this.peersStorage) {
            FileUtils.deleteFully((File)file);
        }
    }

    private void initServer() throws IOException {
        for (int i = 0; i < 3; ++i) {
            int finalI = i;
            this.servers.add((MultiLeaderConsensus)ConsensusFactory.getConsensusImpl((String)"org.apache.iotdb.consensus.multileader.MultiLeaderConsensus", (ConsensusConfig)ConsensusConfig.newBuilder().setThisNodeId(this.peers.get(i).getNodeId()).setThisNode(this.peers.get(i).getEndpoint()).setStorageDir(this.peersStorage.get(i).getAbsolutePath()).build(), groupId -> this.stateMachines.get(finalI)).orElseThrow(() -> new IllegalArgumentException(String.format("Construct consensusImpl failed, Please check your consensus className %s", "org.apache.iotdb.consensus.multileader.MultiLeaderConsensus"))));
            this.servers.get(i).start();
        }
    }

    private void stopServer() {
        this.servers.parallelStream().forEach(MultiLeaderConsensus::stop);
        this.servers.clear();
    }

    @Test
    public void ReplicateUsingQueueTest() throws IOException, InterruptedException {
        long current;
        long start;
        this.logger.info("Start ReplicateUsingQueueTest");
        this.servers.get(0).createPeer(this.group.getGroupId(), this.group.getPeers());
        this.servers.get(1).createPeer(this.group.getGroupId(), this.group.getPeers());
        this.servers.get(2).createPeer(this.group.getGroupId(), this.group.getPeers());
        Assert.assertEquals((long)0L, (long)this.servers.get(0).getImpl(this.gid).getIndex());
        Assert.assertEquals((long)0L, (long)this.servers.get(1).getImpl(this.gid).getIndex());
        Assert.assertEquals((long)0L, (long)this.servers.get(2).getImpl(this.gid).getIndex());
        int i = 0;
        while ((long)i < 500L) {
            this.servers.get(0).write(this.gid, (IConsensusRequest)new TestEntry(i, this.peers.get(0)));
            this.servers.get(1).write(this.gid, (IConsensusRequest)new TestEntry(i, this.peers.get(1)));
            this.servers.get(2).write(this.gid, (IConsensusRequest)new TestEntry(i, this.peers.get(2)));
            Assert.assertEquals((long)(i + 1), (long)this.servers.get(0).getImpl(this.gid).getIndex());
            Assert.assertEquals((long)(i + 1), (long)this.servers.get(1).getImpl(this.gid).getIndex());
            Assert.assertEquals((long)(i + 1), (long)this.servers.get(2).getImpl(this.gid).getIndex());
            ++i;
        }
        for (i = 0; i < 3; ++i) {
            start = System.currentTimeMillis();
            while (this.servers.get(i).getImpl(this.gid).getCurrentSafelyDeletedSearchIndex() < 500L) {
                current = System.currentTimeMillis();
                if (current - start > 60000L) {
                    Assert.fail((String)"Unable to replicate entries");
                }
                Thread.sleep(100L);
            }
        }
        Assert.assertEquals((long)500L, (long)this.servers.get(0).getImpl(this.gid).getCurrentSafelyDeletedSearchIndex());
        Assert.assertEquals((long)500L, (long)this.servers.get(1).getImpl(this.gid).getCurrentSafelyDeletedSearchIndex());
        Assert.assertEquals((long)500L, (long)this.servers.get(2).getImpl(this.gid).getCurrentSafelyDeletedSearchIndex());
        Assert.assertEquals((long)1500L, (long)this.stateMachines.get(0).getRequestSet().size());
        Assert.assertEquals((long)1500L, (long)this.stateMachines.get(1).getRequestSet().size());
        Assert.assertEquals((long)1500L, (long)this.stateMachines.get(2).getRequestSet().size());
        Assert.assertEquals(this.stateMachines.get(0).getData(), this.stateMachines.get(1).getData());
        Assert.assertEquals(this.stateMachines.get(2).getData(), this.stateMachines.get(1).getData());
        this.stopServer();
        this.initServer();
        Assert.assertEquals(this.peers, (Object)this.servers.get(0).getImpl(this.gid).getConfiguration());
        Assert.assertEquals(this.peers, (Object)this.servers.get(1).getImpl(this.gid).getConfiguration());
        Assert.assertEquals(this.peers, (Object)this.servers.get(2).getImpl(this.gid).getConfiguration());
        Assert.assertEquals((long)500L, (long)this.servers.get(0).getImpl(this.gid).getIndex());
        Assert.assertEquals((long)500L, (long)this.servers.get(1).getImpl(this.gid).getIndex());
        Assert.assertEquals((long)500L, (long)this.servers.get(2).getImpl(this.gid).getIndex());
        for (i = 0; i < 3; ++i) {
            start = System.currentTimeMillis();
            while (this.servers.get(i).getImpl(this.gid).getCurrentSafelyDeletedSearchIndex() < 500L) {
                current = System.currentTimeMillis();
                if (current - start > 60000L) {
                    Assert.fail((String)"Unable to recover entries");
                }
                Thread.sleep(100L);
            }
        }
        Assert.assertEquals((long)500L, (long)this.servers.get(0).getImpl(this.gid).getCurrentSafelyDeletedSearchIndex());
        Assert.assertEquals((long)500L, (long)this.servers.get(1).getImpl(this.gid).getCurrentSafelyDeletedSearchIndex());
        Assert.assertEquals((long)500L, (long)this.servers.get(2).getImpl(this.gid).getCurrentSafelyDeletedSearchIndex());
    }

    @Test
    public void ReplicateUsingWALTest() throws IOException, InterruptedException {
        this.logger.info("Start ReplicateUsingWALTest");
        this.servers.get(0).createPeer(this.group.getGroupId(), this.group.getPeers());
        this.servers.get(1).createPeer(this.group.getGroupId(), this.group.getPeers());
        Assert.assertEquals((long)0L, (long)this.servers.get(0).getImpl(this.gid).getIndex());
        Assert.assertEquals((long)0L, (long)this.servers.get(1).getImpl(this.gid).getIndex());
        int i = 0;
        while ((long)i < 500L) {
            this.servers.get(0).write(this.gid, (IConsensusRequest)new TestEntry(i, this.peers.get(0)));
            this.servers.get(1).write(this.gid, (IConsensusRequest)new TestEntry(i, this.peers.get(1)));
            Assert.assertEquals((long)(i + 1), (long)this.servers.get(0).getImpl(this.gid).getIndex());
            Assert.assertEquals((long)(i + 1), (long)this.servers.get(1).getImpl(this.gid).getIndex());
            ++i;
        }
        Assert.assertEquals((long)0L, (long)this.servers.get(0).getImpl(this.gid).getCurrentSafelyDeletedSearchIndex());
        Assert.assertEquals((long)0L, (long)this.servers.get(1).getImpl(this.gid).getCurrentSafelyDeletedSearchIndex());
        this.stopServer();
        this.initServer();
        this.servers.get(2).createPeer(this.group.getGroupId(), this.group.getPeers());
        Assert.assertEquals(this.peers, (Object)this.servers.get(0).getImpl(this.gid).getConfiguration());
        Assert.assertEquals(this.peers, (Object)this.servers.get(1).getImpl(this.gid).getConfiguration());
        Assert.assertEquals(this.peers, (Object)this.servers.get(2).getImpl(this.gid).getConfiguration());
        Assert.assertEquals((long)500L, (long)this.servers.get(0).getImpl(this.gid).getIndex());
        Assert.assertEquals((long)500L, (long)this.servers.get(1).getImpl(this.gid).getIndex());
        Assert.assertEquals((long)0L, (long)this.servers.get(2).getImpl(this.gid).getIndex());
        for (i = 0; i < 2; ++i) {
            long start = System.currentTimeMillis();
            while (this.servers.get(i).getImpl(this.gid).getCurrentSafelyDeletedSearchIndex() < 500L) {
                long current = System.currentTimeMillis();
                if (current - start > 60000L) {
                    this.logger.error("{}", (Object)this.servers.get(i).getImpl(this.gid).getCurrentSafelyDeletedSearchIndex());
                    Assert.fail((String)"Unable to replicate entries");
                }
                Thread.sleep(100L);
            }
        }
        Assert.assertEquals((long)1000L, (long)this.stateMachines.get(0).getRequestSet().size());
        Assert.assertEquals((long)1000L, (long)this.stateMachines.get(1).getRequestSet().size());
        Assert.assertEquals((long)1000L, (long)this.stateMachines.get(2).getRequestSet().size());
        Assert.assertEquals(this.stateMachines.get(0).getData(), this.stateMachines.get(1).getData());
        Assert.assertEquals(this.stateMachines.get(2).getData(), this.stateMachines.get(1).getData());
    }
}

