/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.service.thrift;

import java.net.InetAddress;
import java.net.Socket;
import java.util.Collections;
import junit.framework.TestCase;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.consensus.response.datanode.DataNodeRegisterResp;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterResp;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRestartReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRestartResp;
import org.apache.iotdb.confignode.rpc.thrift.TRuntimeConfiguration;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.apache.iotdb.confignode.service.thrift.ConfigNodeRPCServiceProcessor;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.rpc.TimeoutChangeableTFastFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.junit.Assert;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ConfigNodeRPCServiceProcessorTest
extends TestCase {
    public void testRegisterDataNode() throws Exception {
        CommonConfig commonConfig = (CommonConfig)Mockito.mock(CommonConfig.class);
        ConfigNodeConfig configNodeConfig = (ConfigNodeConfig)Mockito.mock(ConfigNodeConfig.class);
        ConfigNode configNode = (ConfigNode)Mockito.mock(ConfigNode.class);
        ConfigManager configManager = (ConfigManager)Mockito.mock(ConfigManager.class);
        DataNodeRegisterResp registerDataNodeResponse = new DataNodeRegisterResp();
        registerDataNodeResponse.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        registerDataNodeResponse.setConfigNodeList(Collections.singletonList(new TConfigNodeLocation()));
        registerDataNodeResponse.setDataNodeId(Integer.valueOf(42));
        registerDataNodeResponse.setRuntimeConfiguration(new TRuntimeConfiguration());
        Mockito.when((Object)configManager.registerDataNode((TDataNodeRegisterReq)Mockito.any(TDataNodeRegisterReq.class))).thenReturn((Object)registerDataNodeResponse);
        Socket socket = (Socket)Mockito.mock(Socket.class);
        Mockito.when((Object)socket.getInetAddress()).thenReturn((Object)InetAddress.getByAddress(new byte[]{1, 2, 3, 4}));
        TSocket tSocket = (TSocket)Mockito.mock(TSocket.class);
        Mockito.when((Object)tSocket.getSocket()).thenReturn((Object)socket);
        TimeoutChangeableTFastFramedTransport transport = (TimeoutChangeableTFastFramedTransport)Mockito.mock(TimeoutChangeableTFastFramedTransport.class);
        Mockito.when((Object)transport.getSocket()).thenReturn((Object)tSocket);
        ConfigNodeRPCServiceProcessor sut = new ConfigNodeRPCServiceProcessor(commonConfig, configNodeConfig, configNode, configManager);
        TDataNodeLocation newDataNodeLocation = new TDataNodeLocation();
        newDataNodeLocation.setDataNodeId(42);
        newDataNodeLocation.setClientRpcEndPoint(new TEndPoint("1.2.3.4", 6667));
        TDataNodeConfiguration newDataNodeConfiguration = new TDataNodeConfiguration();
        newDataNodeConfiguration.setLocation(newDataNodeLocation);
        TDataNodeRegisterReq req = new TDataNodeRegisterReq();
        req.setClusterName("test-cluster");
        req.setDataNodeConfiguration(newDataNodeConfiguration);
        TDataNodeRegisterResp res = sut.registerDataNode(req);
        Assert.assertEquals((Object)registerDataNodeResponse.convertToRpcDataNodeRegisterResp(), (Object)res);
        ArgumentCaptor acRequest = ArgumentCaptor.forClass(TDataNodeRegisterReq.class);
        ((ConfigManager)Mockito.verify((Object)configManager, (VerificationMode)Mockito.times((int)1))).registerDataNode((TDataNodeRegisterReq)acRequest.capture());
        TDataNodeRegisterReq sentRequest = (TDataNodeRegisterReq)acRequest.getValue();
        Assert.assertEquals((Object)"1.2.3.4", (Object)sentRequest.getDataNodeConfiguration().getLocation().getClientRpcEndPoint().getIp());
    }

    public void testRestartDataNode() throws Exception {
        CommonConfig commonConfig = (CommonConfig)Mockito.mock(CommonConfig.class);
        ConfigNodeConfig configNodeConfig = (ConfigNodeConfig)Mockito.mock(ConfigNodeConfig.class);
        ConfigNode configNode = (ConfigNode)Mockito.mock(ConfigNode.class);
        ConfigManager configManager = (ConfigManager)Mockito.mock(ConfigManager.class);
        TDataNodeRestartResp restartDataNodeResponse = new TDataNodeRestartResp();
        restartDataNodeResponse.setStatus(new TSStatus(TSStatusCode.SUCCESS_STATUS.getStatusCode()));
        restartDataNodeResponse.setConfigNodeList(Collections.singletonList(new TConfigNodeLocation()));
        restartDataNodeResponse.setRuntimeConfiguration(new TRuntimeConfiguration());
        Mockito.when((Object)configManager.restartDataNode((TDataNodeRestartReq)Mockito.any(TDataNodeRestartReq.class))).thenReturn((Object)restartDataNodeResponse);
        Socket socket = (Socket)Mockito.mock(Socket.class);
        Mockito.when((Object)socket.getInetAddress()).thenReturn((Object)InetAddress.getByAddress(new byte[]{1, 2, 3, 4}));
        TSocket tSocket = (TSocket)Mockito.mock(TSocket.class);
        Mockito.when((Object)tSocket.getSocket()).thenReturn((Object)socket);
        TimeoutChangeableTFastFramedTransport transport = (TimeoutChangeableTFastFramedTransport)Mockito.mock(TimeoutChangeableTFastFramedTransport.class);
        Mockito.when((Object)transport.getSocket()).thenReturn((Object)tSocket);
        ConfigNodeRPCServiceProcessor sut = new ConfigNodeRPCServiceProcessor(commonConfig, configNodeConfig, configNode, configManager);
        TDataNodeLocation newDataNodeLocation = new TDataNodeLocation();
        newDataNodeLocation.setDataNodeId(42);
        newDataNodeLocation.setClientRpcEndPoint(new TEndPoint("1.2.3.4", 6667));
        TDataNodeConfiguration newDataNodeConfiguration = new TDataNodeConfiguration();
        newDataNodeConfiguration.setLocation(newDataNodeLocation);
        TDataNodeRestartReq req = new TDataNodeRestartReq();
        req.setClusterName("test-cluster");
        req.setDataNodeConfiguration(newDataNodeConfiguration);
        TDataNodeRestartResp res = sut.restartDataNode(req);
        Assert.assertEquals((Object)restartDataNodeResponse, (Object)res);
        ArgumentCaptor acRequest = ArgumentCaptor.forClass(TDataNodeRestartReq.class);
        ((ConfigManager)Mockito.verify((Object)configManager, (VerificationMode)Mockito.times((int)1))).restartDataNode((TDataNodeRestartReq)acRequest.capture());
        TDataNodeRestartReq sentRequest = (TDataNodeRestartReq)acRequest.getValue();
        Assert.assertEquals((Object)"1.2.3.4", (Object)sentRequest.getDataNodeConfiguration().getLocation().getClientRpcEndPoint().getIp());
    }
}

