/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.util;

import java.util.concurrent.TimeUnit;
import org.apache.iotdb.confignode.procedure.ProcedureExecutor;

public class ProcedureTestUtil {
    public static void waitForProcedure(ProcedureExecutor executor, long ... procIds) {
        for (long procId : procIds) {
            long startTimeForProcId = System.currentTimeMillis();
            while (executor.isRunning() && !executor.isFinished(procId) && TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - startTimeForProcId) < 35L) {
                ProcedureTestUtil.sleepWithoutInterrupt(250L);
            }
        }
    }

    public static void sleepWithoutInterrupt(long timeToSleep) {
        long currentTime = System.currentTimeMillis();
        long endTime = timeToSleep + currentTime;
        boolean interrupted = false;
        while (currentTime < endTime) {
            try {
                Thread.sleep(endTime - currentTime);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            currentTime = System.currentTimeMillis();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

