/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.sync;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TNodeResource;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorPlan;
import org.apache.iotdb.confignode.procedure.impl.sync.AuthOperationProcedure;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.tsfile.utils.PublicBAOS;
import org.junit.Assert;
import org.junit.Test;

public class AuthOperationProcedureTest {
    @Test
    public void serializeDeserializeTest() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        TDataNodeLocation dataNodeLocation = new TDataNodeLocation();
        dataNodeLocation.setDataNodeId(1);
        dataNodeLocation.setClientRpcEndPoint(new TEndPoint("0.0.0.0", 6667));
        dataNodeLocation.setInternalEndPoint(new TEndPoint("0.0.0.0", 10730));
        dataNodeLocation.setMPPDataExchangeEndPoint(new TEndPoint("0.0.0.0", 10740));
        dataNodeLocation.setDataRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10760));
        dataNodeLocation.setSchemaRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10750));
        TDataNodeConfiguration dataNodeConfiguration = new TDataNodeConfiguration();
        dataNodeConfiguration.setLocation(dataNodeLocation);
        dataNodeConfiguration.setResource(new TNodeResource(16, 0x800000000L));
        ArrayList<TDataNodeConfiguration> datanodes = new ArrayList<TDataNodeConfiguration>();
        datanodes.add(dataNodeConfiguration);
        try {
            int begin = ConfigPhysicalPlanType.CreateUser.ordinal();
            int end = ConfigPhysicalPlanType.UpdateUser.ordinal();
            for (int i = begin; i <= end; ++i) {
                AuthOperationProcedure proc = new AuthOperationProcedure(new AuthorPlan(ConfigPhysicalPlanType.values()[i], "user1", "role1", "123456", "123456", Collections.singleton(1), false, Collections.singletonList(new PartialPath("root.t1"))), datanodes, false);
                proc.serialize(outputStream);
                ByteBuffer buffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
                AuthOperationProcedure proc2 = (AuthOperationProcedure)ProcedureFactory.getInstance().create(buffer);
                Assert.assertEquals((Object)proc, (Object)proc2);
                buffer.clear();
                byteArrayOutputStream.reset();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

