/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.subscription.subscription;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerGroupMeta;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerMeta;
import org.apache.iotdb.confignode.procedure.impl.pipe.task.DropPipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.subscription.consumer.AlterConsumerGroupProcedure;
import org.apache.iotdb.confignode.procedure.impl.subscription.subscription.DropSubscriptionProcedure;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.iotdb.confignode.rpc.thrift.TUnsubscribeReq;
import org.apache.tsfile.utils.PublicBAOS;
import org.junit.Assert;
import org.junit.Test;

public class DropSubscriptionProcedureTest {
    @Test
    public void serializeDeserializeTest() {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        HashMap<String, String> topicAttributes = new HashMap<String, String>();
        topicAttributes.put("k1", "v1");
        topicAttributes.put("k2", "v2");
        HashMap<String, String> consumerAttributes = new HashMap<String, String>();
        consumerAttributes.put("k3", "v3");
        consumerAttributes.put("k4", "v4");
        HashSet<String> unsubscribeTopics = new HashSet<String>();
        unsubscribeTopics.add("test_topic1");
        unsubscribeTopics.add("test_topic2");
        DropSubscriptionProcedure proc = new DropSubscriptionProcedure(new TUnsubscribeReq("old_consumer", "test_consumer_group", unsubscribeTopics));
        ConsumerGroupMeta newConsumerGroupMeta = new ConsumerGroupMeta("test_consumer_group", 1L, new ConsumerMeta("old_consumer", 1L, consumerAttributes));
        newConsumerGroupMeta.addSubscription("old_consumer", unsubscribeTopics);
        AlterConsumerGroupProcedure alterConsumerGroupProcedure = new AlterConsumerGroupProcedure(newConsumerGroupMeta);
        ArrayList<DropPipeProcedureV2> pipeProcedures = new ArrayList<DropPipeProcedureV2>();
        pipeProcedures.add(new DropPipeProcedureV2("pipe_topic1"));
        pipeProcedures.add(new DropPipeProcedureV2("pipe_topic2"));
        proc.setAlterConsumerGroupProcedure(alterConsumerGroupProcedure);
        proc.setDropPipeProcedures(pipeProcedures);
        try {
            proc.serialize(outputStream);
            ByteBuffer buffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            DropSubscriptionProcedure proc2 = (DropSubscriptionProcedure)ProcedureFactory.getInstance().create(buffer);
            Assert.assertEquals((Object)proc, (Object)proc2);
            Assert.assertEquals((Object)alterConsumerGroupProcedure, (Object)proc2.getAlterConsumerGroupProcedure());
            Assert.assertEquals(pipeProcedures, (Object)proc2.getDropPipeProcedures());
        }
        catch (Exception e) {
            Assert.fail();
        }
    }
}

