/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.subscription.subscription;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerGroupMeta;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerMeta;
import org.apache.iotdb.confignode.procedure.impl.pipe.task.CreatePipeProcedureV2;
import org.apache.iotdb.confignode.procedure.impl.subscription.consumer.AlterConsumerGroupProcedure;
import org.apache.iotdb.confignode.procedure.impl.subscription.subscription.CreateSubscriptionProcedure;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.iotdb.confignode.rpc.thrift.TSubscribeReq;
import org.apache.tsfile.utils.PublicBAOS;
import org.junit.Assert;
import org.junit.Test;

public class CreateSubscriptionProcedureTest {
    @Test
    public void serializeDeserializeTest() {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        HashMap<String, String> topicAttributes = new HashMap<String, String>();
        topicAttributes.put("k1", "v1");
        topicAttributes.put("k2", "v2");
        HashMap<String, String> consumerAttributes = new HashMap<String, String>();
        consumerAttributes.put("k3", "v3");
        consumerAttributes.put("k4", "v4");
        HashSet<String> subscribeTopics = new HashSet<String>();
        subscribeTopics.add("test_topic1");
        subscribeTopics.add("test_topic2");
        CreateSubscriptionProcedure proc = new CreateSubscriptionProcedure(new TSubscribeReq("old_consumer", "test_consumer_group", subscribeTopics));
        ConsumerGroupMeta newConsumerGroupMeta = new ConsumerGroupMeta("test_consumer_group", 1L, new ConsumerMeta("old_consumer", 1L, consumerAttributes));
        newConsumerGroupMeta.addSubscription("old_consumer", subscribeTopics);
        AlterConsumerGroupProcedure alterConsumerGroupProcedure = new AlterConsumerGroupProcedure(newConsumerGroupMeta);
        ArrayList<CreatePipeProcedureV2> pipeProcedures = new ArrayList<CreatePipeProcedureV2>();
        pipeProcedures.add(new CreatePipeProcedureV2(new TCreatePipeReq("pipe_topic1", Collections.singletonMap("connector", "conn")).setExtractorAttributes(Collections.singletonMap("extractor", "ex")).setProcessorAttributes(Collections.singletonMap("processor", "pro"))));
        pipeProcedures.add(new CreatePipeProcedureV2(new TCreatePipeReq("pipe_topic2", Collections.singletonMap("connector", "conn")).setExtractorAttributes(Collections.singletonMap("extractor", "ex")).setProcessorAttributes(Collections.singletonMap("processor", "pro"))));
        proc.setAlterConsumerGroupProcedure(alterConsumerGroupProcedure);
        proc.setCreatePipeProcedures(pipeProcedures);
        try {
            proc.serialize(outputStream);
            ByteBuffer buffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            CreateSubscriptionProcedure proc2 = (CreateSubscriptionProcedure)ProcedureFactory.getInstance().create(buffer);
            Assert.assertEquals((Object)proc, (Object)proc2);
            Assert.assertEquals((Object)alterConsumerGroupProcedure, (Object)proc2.getAlterConsumerGroupProcedure());
            Assert.assertEquals(pipeProcedures, (Object)proc2.getCreatePipeProcedures());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

