/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.subscription.consumer;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerGroupMeta;
import org.apache.iotdb.commons.subscription.meta.consumer.ConsumerMeta;
import org.apache.iotdb.confignode.procedure.impl.subscription.consumer.CreateConsumerProcedure;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.iotdb.confignode.rpc.thrift.TCreateConsumerReq;
import org.apache.tsfile.utils.PublicBAOS;
import org.junit.Assert;
import org.junit.Test;

public class CreateConsumerProcedureTest {
    @Test
    public void serializeDeserializeTest() {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        HashMap<String, String> consumerAttributes = new HashMap<String, String>();
        consumerAttributes.put("k1", "v1");
        consumerAttributes.put("k2", "v2");
        CreateConsumerProcedure proc = new CreateConsumerProcedure(new TCreateConsumerReq("new_consumer", "test_consumer_group").setConsumerAttributes(consumerAttributes));
        ConsumerGroupMeta oldMeta = new ConsumerGroupMeta("test_consumer_group", 1L, new ConsumerMeta("old_consumer", 1L, consumerAttributes));
        ConsumerGroupMeta newMeta = new ConsumerGroupMeta("test_consumer_group", 1L, new ConsumerMeta("old_consumer", 1L, consumerAttributes));
        newMeta.addConsumer(new ConsumerMeta("new_consumer", 1L, consumerAttributes));
        proc.setExistingConsumerGroupMeta(oldMeta);
        proc.setUpdatedConsumerGroupMeta(newMeta);
        try {
            proc.serialize(outputStream);
            ByteBuffer buffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            CreateConsumerProcedure proc2 = (CreateConsumerProcedure)ProcedureFactory.getInstance().create(buffer);
            Assert.assertEquals((Object)proc, (Object)proc2);
            Assert.assertEquals((Object)oldMeta, (Object)proc2.getExistingConsumerGroupMeta());
            Assert.assertEquals((Object)newMeta, (Object)proc2.getUpdatedConsumerGroupMeta());
        }
        catch (Exception e) {
            Assert.fail();
        }
    }
}

