/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.confignode.procedure.impl.schema.UnsetTemplateProcedure;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.junit.Assert;
import org.junit.Test;

public class UnsetTemplateProcedureTest {
    @Test
    public void serializeDeserializeTest() throws IllegalPathException, IOException {
        String queryId = "1";
        Template template = new Template();
        template.setId(0);
        template.setName("t1");
        template.addMeasurements(new String[]{"s1", "s2"}, new TSDataType[]{TSDataType.INT32, TSDataType.FLOAT}, new TSEncoding[]{TSEncoding.PLAIN, TSEncoding.BITMAP}, new CompressionType[]{CompressionType.UNCOMPRESSED, CompressionType.GZIP});
        PartialPath path = new PartialPath("root.sg");
        UnsetTemplateProcedure unsetTemplateProcedure = new UnsetTemplateProcedure(queryId, template, path, false);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        unsetTemplateProcedure.serialize(dataOutputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        Assert.assertEquals((long)ProcedureType.UNSET_TEMPLATE_PROCEDURE.getTypeCode(), (long)byteBuffer.getShort());
        UnsetTemplateProcedure deserializedProcedure = new UnsetTemplateProcedure(false);
        deserializedProcedure.deserialize(byteBuffer);
        Assert.assertEquals((Object)queryId, (Object)deserializedProcedure.getQueryId());
        Assert.assertEquals((long)template.getId(), (long)deserializedProcedure.getTemplateId());
        Assert.assertEquals((Object)template.getName(), (Object)deserializedProcedure.getTemplateName());
        Assert.assertEquals((Object)template.getSchemaMap(), (Object)deserializedProcedure.getTemplate().getSchemaMap());
        Assert.assertEquals((Object)path, (Object)deserializedProcedure.getPath());
    }
}

