/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.procedure.impl.schema.SetTTLProcedure;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.tsfile.utils.PublicBAOS;
import org.junit.Assert;
import org.junit.Test;

public class SetTTLProcedureTest {
    @Test
    public void serializeDeserializeTest() throws IOException, IllegalPathException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        PartialPath path = new PartialPath("root.test.sg1.group1.group1.**");
        SetTTLPlan setTTLPlan = new SetTTLPlan(Arrays.asList(path.getNodes()), 1928300234200L);
        SetTTLProcedure proc = new SetTTLProcedure(setTTLPlan, false);
        proc.serialize(outputStream);
        ByteBuffer buffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        SetTTLProcedure proc2 = (SetTTLProcedure)ProcedureFactory.getInstance().create(buffer);
        Assert.assertTrue((boolean)proc.equals((Object)proc2));
        buffer.clear();
        byteArrayOutputStream.reset();
        path = new PartialPath("root.**");
        setTTLPlan = new SetTTLPlan(Arrays.asList(path.getNodes()), -1L);
        proc = new SetTTLProcedure(setTTLPlan, false);
        proc.serialize(outputStream);
        buffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
        proc2 = (SetTTLProcedure)ProcedureFactory.getInstance().create(buffer);
        Assert.assertTrue((boolean)proc.equals((Object)proc2));
        buffer.clear();
        byteArrayOutputStream.reset();
    }
}

