/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.confignode.procedure.impl.schema.DeleteTimeSeriesProcedure;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.junit.Assert;
import org.junit.Test;

public class DeleteTimeSeriesProcedureTest {
    @Test
    public void serializeDeserializeTest() throws IllegalPathException, IOException {
        String queryId = "1";
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.sg1.**"));
        patternTree.appendPathPattern(new PartialPath("root.sg2.*.s1"));
        patternTree.constructTree();
        DeleteTimeSeriesProcedure deleteTimeSeriesProcedure = new DeleteTimeSeriesProcedure(queryId, patternTree, false);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        deleteTimeSeriesProcedure.serialize(dataOutputStream);
        ByteBuffer byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.toByteArray());
        Assert.assertEquals((long)ProcedureType.DELETE_TIMESERIES_PROCEDURE.getTypeCode(), (long)byteBuffer.getShort());
        DeleteTimeSeriesProcedure deserializedProcedure = new DeleteTimeSeriesProcedure(false);
        deserializedProcedure.deserialize(byteBuffer);
        Assert.assertEquals((Object)queryId, (Object)deserializedProcedure.getQueryId());
        List pathList = deserializedProcedure.getPatternTree().getAllPathPatterns();
        pathList.sort(PartialPath::compareTo);
        Assert.assertEquals((Object)"root.sg1.**", (Object)((PartialPath)pathList.get(0)).getFullPath());
        Assert.assertEquals((Object)"root.sg2.*.s1", (Object)((PartialPath)pathList.get(1)).getFullPath());
    }
}

