/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.pipe.task;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import org.apache.iotdb.confignode.procedure.impl.pipe.task.CreatePipeProcedureV2;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.iotdb.confignode.rpc.thrift.TCreatePipeReq;
import org.apache.tsfile.utils.PublicBAOS;
import org.junit.Assert;
import org.junit.Test;

public class CreatePipeProcedureV2Test {
    @Test
    public void serializeDeserializeTest() {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        HashMap<String, String> extractorAttributes = new HashMap<String, String>();
        HashMap<String, String> processorAttributes = new HashMap<String, String>();
        HashMap<String, String> connectorAttributes = new HashMap<String, String>();
        extractorAttributes.put("extractor", "iotdb-extractor");
        processorAttributes.put("processor", "do-nothing-processor");
        connectorAttributes.put("connector", "iotdb-thrift-connector");
        connectorAttributes.put("host", "127.0.0.1");
        connectorAttributes.put("port", "6667");
        CreatePipeProcedureV2 proc = new CreatePipeProcedureV2(new TCreatePipeReq().setPipeName("testPipe").setExtractorAttributes(extractorAttributes).setProcessorAttributes(processorAttributes).setConnectorAttributes(connectorAttributes));
        try {
            proc.serialize(outputStream);
            ByteBuffer buffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            CreatePipeProcedureV2 proc2 = (CreatePipeProcedureV2)ProcedureFactory.getInstance().create(buffer);
            Assert.assertEquals((Object)proc, (Object)proc2);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }
}

