/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.node;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.procedure.impl.node.RemoveDataNodesProcedure;
import org.apache.iotdb.confignode.procedure.impl.region.RegionMigrationPlan;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.tsfile.utils.PublicBAOS;
import org.junit.Assert;
import org.junit.Test;

public class RemoveDataNodesProcedureTest {
    private TConsensusGroupId consensusGroupId = new TConsensusGroupId(TConsensusGroupType.DataRegion, 1);
    private TDataNodeLocation fromDataNodeLocation = new TDataNodeLocation(10, new TEndPoint("127.0.0.1", 6667), new TEndPoint("127.0.0.1", 6668), new TEndPoint("127.0.0.1", 6669), new TEndPoint("127.0.0.1", 6670), new TEndPoint("127.0.0.1", 6671));
    private TDataNodeLocation toDataNodeLocation = new TDataNodeLocation(11, new TEndPoint("127.0.0.1", 6677), new TEndPoint("127.0.0.1", 6678), new TEndPoint("127.0.0.1", 6679), new TEndPoint("127.0.0.1", 6680), new TEndPoint("127.0.0.1", 6681));

    @Test
    public void serDeTest() throws IOException {
        List<TDataNodeLocation> removedDataNodes = Collections.singletonList(this.fromDataNodeLocation);
        HashMap<Integer, NodeStatus> nodeStatusMap = new HashMap<Integer, NodeStatus>();
        nodeStatusMap.put(10, NodeStatus.Running);
        RemoveDataNodesProcedure procedure0 = new RemoveDataNodesProcedure(removedDataNodes, nodeStatusMap);
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            procedure0.serialize(outputStream);
            ByteBuffer buffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            Assert.assertEquals((Object)procedure0, (Object)ProcedureFactory.getInstance().create(buffer));
        }
        RegionMigrationPlan regionMigrationPlan = new RegionMigrationPlan(this.consensusGroupId, this.fromDataNodeLocation);
        regionMigrationPlan.setToDataNode(this.toDataNodeLocation);
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();
             DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
            regionMigrationPlan.serialize(outputStream);
            ByteBuffer buffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            Assert.assertEquals((Object)regionMigrationPlan, (Object)RegionMigrationPlan.deserialize((ByteBuffer)buffer));
        }
    }
}

