/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.trigger.TriggerInformation;
import org.apache.iotdb.confignode.procedure.impl.trigger.CreateTriggerProcedure;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.iotdb.confignode.rpc.thrift.TTriggerState;
import org.apache.iotdb.trigger.api.enums.FailureStrategy;
import org.apache.iotdb.trigger.api.enums.TriggerEvent;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.PublicBAOS;
import org.junit.Assert;
import org.junit.Test;

public class CreateTriggerProcedureTest {
    @Test
    public void serializeDeserializeTest() throws IllegalPathException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        TriggerInformation triggerInformation = new TriggerInformation(new PartialPath("root.test.**"), "test", "test.class", true, "test.jar", null, TriggerEvent.AFTER_INSERT, TTriggerState.INACTIVE, false, null, FailureStrategy.OPTIMISTIC, "testMD5test");
        CreateTriggerProcedure p1 = new CreateTriggerProcedure(triggerInformation, new Binary(new byte[]{1, 2, 3}), false);
        try {
            p1.serialize(outputStream);
            ByteBuffer buffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            CreateTriggerProcedure p2 = (CreateTriggerProcedure)ProcedureFactory.getInstance().create(buffer);
            Assert.assertEquals((Object)p1, (Object)p2);
            Assert.assertEquals((Object)p1.getJarFile(), (Object)p2.getJarFile());
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    @Test
    public void serializeDeserializeWithoutJarFileTest() throws IllegalPathException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        TriggerInformation triggerInformation = new TriggerInformation(new PartialPath("root.test.**"), "test", "test.class", true, "test.jar", null, TriggerEvent.AFTER_INSERT, TTriggerState.INACTIVE, false, null, FailureStrategy.OPTIMISTIC, "testMD5test");
        CreateTriggerProcedure p1 = new CreateTriggerProcedure(triggerInformation, null, false);
        try {
            p1.serialize(outputStream);
            ByteBuffer buffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            CreateTriggerProcedure p2 = (CreateTriggerProcedure)ProcedureFactory.getInstance().create(buffer);
            Assert.assertEquals((Object)p1, (Object)p2);
            Assert.assertEquals((Object)p1.getJarFile(), (Object)p2.getJarFile());
        }
        catch (Exception e) {
            Assert.fail();
        }
    }
}

