/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.procedure.impl.region.CreateRegionGroupsProcedure;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.tsfile.utils.PublicBAOS;
import org.junit.Assert;
import org.junit.Test;

public class CreateRegionGroupsProcedureTest {
    @Test
    public void serializeDeserializeTest() {
        TDataNodeLocation dataNodeLocation0 = new TDataNodeLocation();
        dataNodeLocation0.setDataNodeId(5);
        dataNodeLocation0.setClientRpcEndPoint(new TEndPoint("0.0.0.0", 6667));
        dataNodeLocation0.setInternalEndPoint(new TEndPoint("0.0.0.0", 10730));
        dataNodeLocation0.setMPPDataExchangeEndPoint(new TEndPoint("0.0.0.0", 10740));
        dataNodeLocation0.setDataRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10760));
        dataNodeLocation0.setSchemaRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10750));
        TDataNodeLocation dataNodeLocation1 = new TDataNodeLocation();
        dataNodeLocation1.setDataNodeId(6);
        dataNodeLocation1.setClientRpcEndPoint(new TEndPoint("0.0.0.1", 6667));
        dataNodeLocation1.setInternalEndPoint(new TEndPoint("0.0.0.1", 10730));
        dataNodeLocation1.setMPPDataExchangeEndPoint(new TEndPoint("0.0.0.1", 10740));
        dataNodeLocation1.setDataRegionConsensusEndPoint(new TEndPoint("0.0.0.1", 10760));
        dataNodeLocation1.setSchemaRegionConsensusEndPoint(new TEndPoint("0.0.0.1", 10750));
        final TConsensusGroupId schemaRegionGroupId = new TConsensusGroupId(TConsensusGroupType.SchemaRegion, 1);
        final TConsensusGroupId dataRegionGroupId = new TConsensusGroupId(TConsensusGroupType.DataRegion, 0);
        final TRegionReplicaSet schemaRegionSet = new TRegionReplicaSet(schemaRegionGroupId, Collections.singletonList(dataNodeLocation0));
        final TRegionReplicaSet dataRegionSet = new TRegionReplicaSet(dataRegionGroupId, Collections.singletonList(dataNodeLocation1));
        HashMap<TConsensusGroupId, TRegionReplicaSet> failedRegions0 = new HashMap<TConsensusGroupId, TRegionReplicaSet>(){
            {
                this.put(dataRegionGroupId, dataRegionSet);
                this.put(schemaRegionGroupId, schemaRegionSet);
            }
        };
        HashMap<TConsensusGroupId, TRegionReplicaSet> failedRegions1 = new HashMap<TConsensusGroupId, TRegionReplicaSet>(){
            {
                this.put(schemaRegionGroupId, schemaRegionSet);
                this.put(dataRegionGroupId, dataRegionSet);
            }
        };
        Assert.assertEquals((Object)failedRegions0, (Object)failedRegions1);
        CreateRegionGroupsPlan createRegionGroupsPlan = new CreateRegionGroupsPlan();
        createRegionGroupsPlan.addRegionGroup("root.sg0", dataRegionSet);
        createRegionGroupsPlan.addRegionGroup("root.sg1", schemaRegionSet);
        CreateRegionGroupsPlan persistPlan = new CreateRegionGroupsPlan();
        persistPlan.addRegionGroup("root.sg0", dataRegionSet);
        persistPlan.addRegionGroup("root.sg1", schemaRegionSet);
        CreateRegionGroupsProcedure procedure0 = new CreateRegionGroupsProcedure(TConsensusGroupType.DataRegion, createRegionGroupsPlan, persistPlan, (Map)failedRegions0);
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        try {
            procedure0.serialize(outputStream);
            CreateRegionGroupsProcedure procedure1 = new CreateRegionGroupsProcedure();
            ByteBuffer buffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            Assert.assertEquals((long)ProcedureType.CREATE_REGION_GROUPS.getTypeCode(), (long)buffer.getShort());
            procedure1.deserialize(buffer);
            Assert.assertEquals((Object)procedure0, (Object)procedure1);
            Assert.assertEquals((long)procedure0.hashCode(), (long)procedure1.hashCode());
            CreateRegionGroupsProcedure procedure2 = (CreateRegionGroupsProcedure)ProcedureFactory.getInstance().create(ByteBuffer.wrap(byteArrayOutputStream.getBuf()));
            Assert.assertEquals((Object)procedure0, (Object)procedure2);
            Assert.assertEquals((long)procedure0.hashCode(), (long)procedure2.hashCode());
        }
        catch (IOException e) {
            Assert.fail();
        }
    }
}

