/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl;

import java.io.DataOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.cq.CQManager;
import org.apache.iotdb.confignode.procedure.impl.cq.CreateCQProcedure;
import org.apache.iotdb.confignode.procedure.store.ProcedureFactory;
import org.apache.iotdb.confignode.rpc.thrift.TCreateCQReq;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.apache.tsfile.utils.PublicBAOS;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class CreateCQProcedureTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void serializeDeserializeTest() {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        String sql = "create cq testCq1 BEGIN select s1 into root.backup.d1(s1) from root.sg.d1 END";
        TCreateCQReq req = new TCreateCQReq("testCq1", 1000L, 0L, 1000L, 0L, 0, "select s1 into root.backup.d1(s1) from root.sg.d1", sql, "Asia", "root");
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(1);
        CreateCQProcedure createCQProcedure1 = new CreateCQProcedure(req, executor);
        CQManager cqManager = (CQManager)Mockito.mock(CQManager.class);
        Mockito.when((Object)cqManager.getExecutor()).thenReturn((Object)executor);
        ConfigManager configManager = (ConfigManager)Mockito.mock(ConfigManager.class);
        Mockito.when((Object)configManager.getCQManager()).thenReturn((Object)cqManager);
        ConfigNode configNode = new ConfigNode();
        configNode.setConfigManager(configManager);
        try {
            createCQProcedure1.serialize(outputStream);
            ByteBuffer buffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            CreateCQProcedure createCQProcedure2 = (CreateCQProcedure)ProcedureFactory.getInstance().create(buffer);
            Assert.assertEquals((Object)createCQProcedure1, (Object)createCQProcedure2);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        finally {
            executor.shutdown();
        }
    }
}

