/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.entity;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.entity.IncProcedure;
import org.apache.iotdb.confignode.procedure.entity.NoopProcedure;
import org.apache.iotdb.confignode.procedure.entity.SimpleLockProcedure;
import org.apache.iotdb.confignode.procedure.entity.SimpleSTMProcedure;
import org.apache.iotdb.confignode.procedure.entity.SleepProcedure;
import org.apache.iotdb.confignode.procedure.entity.StuckProcedure;
import org.apache.iotdb.confignode.procedure.entity.StuckSTMProcedure;
import org.apache.iotdb.confignode.procedure.store.IProcedureFactory;

public class TestProcedureFactory
implements IProcedureFactory {
    public Procedure create(ByteBuffer buffer) throws IOException {
        Object procedure;
        int typeNum = buffer.getInt();
        if (typeNum >= TestProcedureType.values().length) {
            throw new IOException("unrecognized log type " + typeNum);
        }
        TestProcedureType type = TestProcedureType.values()[typeNum];
        switch (type) {
            case INC_PROCEDURE: {
                procedure = new IncProcedure();
                break;
            }
            case NOOP_PROCEDURE: {
                procedure = new NoopProcedure();
                break;
            }
            case SLEEP_PROCEDURE: {
                procedure = new SleepProcedure();
                break;
            }
            case STUCK_PROCEDURE: {
                procedure = new StuckProcedure();
                break;
            }
            case STUCK_STM_PROCEDURE: {
                procedure = new StuckSTMProcedure();
                break;
            }
            case SIMPLE_STM_PROCEDURE: {
                procedure = new SimpleSTMProcedure();
                break;
            }
            case SIMPLE_LOCK_PROCEDURE: {
                procedure = new SimpleLockProcedure();
                break;
            }
            default: {
                throw new IOException("unknown Procedure type: " + typeNum);
            }
        }
        procedure.deserialize(buffer);
        return procedure;
    }

    public static enum TestProcedureType {
        INC_PROCEDURE,
        NOOP_PROCEDURE,
        SIMPLE_LOCK_PROCEDURE,
        SIMPLE_STM_PROCEDURE,
        SLEEP_PROCEDURE,
        STUCK_PROCEDURE,
        STUCK_STM_PROCEDURE;

    }
}

