/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.entity;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.confignode.procedure.entity.SleepProcedure;
import org.apache.iotdb.confignode.procedure.entity.TestProcedureFactory;
import org.apache.iotdb.confignode.procedure.env.TestProcEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;

public class StuckSTMProcedure
extends StateMachineProcedure<TestProcEnv, TestState> {
    private int childCount = 0;

    public StuckSTMProcedure() {
    }

    public StuckSTMProcedure(int childCount) {
        this.childCount = childCount;
    }

    protected StateMachineProcedure.Flow executeFromState(TestProcEnv testProcEnv, TestState testState) throws InterruptedException {
        block8: {
            AtomicInteger acc = testProcEnv.getAcc();
            try {
                switch (testState) {
                    case STEP_1: {
                        acc.getAndAdd(1);
                        this.setNextState((Object)TestState.STEP_2);
                        break;
                    }
                    case STEP_2: {
                        for (int i = 0; i < this.childCount; ++i) {
                            SleepProcedure child = new SleepProcedure();
                            this.addChildProcedure(child);
                        }
                        this.setNextState((Object)TestState.STEP_3);
                        break;
                    }
                    case STEP_3: {
                        acc.getAndAdd(-1);
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                }
            }
            catch (Exception e) {
                if (!this.isRollbackSupported(testState)) break block8;
                this.setFailure("proc failed", (Throwable)new ProcedureException((Throwable)e));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected boolean isRollbackSupported(TestState testState) {
        return true;
    }

    protected void rollbackState(TestProcEnv testProcEnv, TestState testState) throws IOException, InterruptedException {
    }

    protected TestState getState(int stateId) {
        return TestState.values()[stateId];
    }

    protected int getStateId(TestState testState) {
        return testState.ordinal();
    }

    protected TestState getInitialState() {
        return TestState.STEP_1;
    }

    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeInt(TestProcedureFactory.TestProcedureType.STUCK_STM_PROCEDURE.ordinal());
        super.serialize(stream);
        stream.writeInt(this.childCount);
    }

    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.childCount = byteBuffer.getInt();
    }

    public static enum TestState {
        STEP_1,
        STEP_2,
        STEP_3;

    }
}

