/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.entity;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.confignode.procedure.entity.IncProcedure;
import org.apache.iotdb.confignode.procedure.env.TestProcEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;

public class SimpleSTMProcedure
extends StateMachineProcedure<TestProcEnv, TestState> {
    public int throwAtIndex = -1;

    protected StateMachineProcedure.Flow executeFromState(TestProcEnv testProcEnv, TestState testState) throws InterruptedException {
        block9: {
            AtomicInteger acc = testProcEnv.getAcc();
            try {
                switch (testState) {
                    case STEP_1: {
                        acc.getAndAdd(1);
                        this.setNextState((Object)TestState.STEP_2);
                        break;
                    }
                    case STEP_2: {
                        for (int i = 0; i < 10; ++i) {
                            IncProcedure child = new IncProcedure();
                            if (i == this.throwAtIndex) {
                                child.throwEx = true;
                            }
                            this.addChildProcedure(child);
                        }
                        this.setNextState((Object)TestState.STEP_3);
                        break;
                    }
                    case STEP_3: {
                        acc.getAndAdd(-1);
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                }
            }
            catch (Exception e) {
                if (!this.isRollbackSupported(testState)) break block9;
                this.setFailure("proc failed", (Throwable)new ProcedureException((Throwable)e));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected boolean isRollbackSupported(TestState testState) {
        return true;
    }

    protected void rollbackState(TestProcEnv testProcEnv, TestState testState) throws IOException, InterruptedException {
    }

    protected TestState getState(int stateId) {
        return TestState.values()[stateId];
    }

    protected int getStateId(TestState testState) {
        return testState.ordinal();
    }

    protected TestState getInitialState() {
        return TestState.STEP_1;
    }

    public static enum TestState {
        STEP_1,
        STEP_2,
        STEP_3;

    }
}

