/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.entity;

import java.io.IOException;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.env.TestProcEnv;
import org.apache.iotdb.confignode.procedure.scheduler.SimpleProcedureScheduler;
import org.apache.iotdb.confignode.procedure.state.ProcedureLockState;

public class SimpleLockProcedure
extends Procedure<TestProcEnv> {
    private String procName;

    public SimpleLockProcedure() {
    }

    public SimpleLockProcedure(String procName) {
        this.procName = procName;
    }

    protected Procedure<TestProcEnv>[] execute(TestProcEnv testProcEnv) throws InterruptedException {
        testProcEnv.executeSeq.append(this.procName);
        return null;
    }

    protected void rollback(TestProcEnv testProcEnv) throws IOException, InterruptedException {
    }

    protected ProcedureLockState acquireLock(TestProcEnv testProcEnv) {
        if (testProcEnv.getEnvLock().tryLock()) {
            testProcEnv.lockAcquireSeq.append(this.procName);
            System.out.println(this.procName + " acquired lock.");
            return ProcedureLockState.LOCK_ACQUIRED;
        }
        SimpleProcedureScheduler scheduler = (SimpleProcedureScheduler)testProcEnv.getScheduler();
        scheduler.addWaiting((Procedure)this);
        System.out.println(this.procName + " wait for lock.");
        return ProcedureLockState.LOCK_EVENT_WAIT;
    }

    protected void releaseLock(TestProcEnv testProcEnv) {
        System.out.println(this.procName + " release lock.");
        testProcEnv.getEnvLock().unlock();
        SimpleProcedureScheduler scheduler = (SimpleProcedureScheduler)testProcEnv.getScheduler();
        scheduler.releaseWaiting();
    }

    protected boolean holdLock(TestProcEnv testProcEnv) {
        return testProcEnv.getEnvLock().isHeldByCurrentThread();
    }
}

