/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.TestOnlyPlan;
import org.apache.iotdb.confignode.consensus.request.write.procedure.UpdateProcedurePlan;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.persistence.ProcedureInfo;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.impl.node.AddConfigNodeProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.RemoveDataNodesProcedure;
import org.apache.iotdb.confignode.procedure.impl.testonly.NeverFinishProcedure;
import org.apache.iotdb.confignode.procedure.store.ConfigProcedureStore;
import org.apache.iotdb.confignode.rpc.thrift.TNodeVersionInfo;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeFromWALToConsensusLayerTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeFromWALToConsensusLayerTest.class);
    ConfigNodeConfig conf = ConfigNodeDescriptor.getInstance().getConf();
    private static final String DATA_DIR = "data_UpgradeFromWALToConsensusLayerTest";

    @Before
    public void setUp() throws Exception {
        this.conf.setConsensusDir(DATA_DIR + File.separator + this.conf.getConsensusDir());
        this.conf.setSystemDir(DATA_DIR + File.separator + this.conf.getSystemDir());
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.recursivelyDeleteFolder((String)DATA_DIR);
        this.conf.setConsensusDir(this.conf.getConsensusDir().replace(DATA_DIR + File.separator, ""));
        this.conf.setSystemDir(this.conf.getSystemDir().replace(DATA_DIR + File.separator, ""));
    }

    @Ignore
    @Test
    public void test() throws IOException, ConsensusException, InterruptedException {
        ConfigManager configManager = new ConfigManager();
        this.conf.setConfigNodeId(0);
        this.conf.setInternalAddress("127.0.0.1");
        configManager.initConsensusManager();
        configManager.getConsensusManager().write((ConfigPhysicalPlan)new TestOnlyPlan());
        configManager.getConsensusManager().write((ConfigPhysicalPlan)new TestOnlyPlan());
        configManager.getConsensusManager().write((ConfigPhysicalPlan)new TestOnlyPlan());
        ProcedureInfo procedureInfo = configManager.getProcedureManager().getStore().getProcedureInfo();
        ConfigProcedureStore.createOldProcWalDir();
        List<TDataNodeLocation> removedDataNodes = Arrays.asList(new TDataNodeLocation(10000, new TEndPoint("127.0.0.1", 6600), new TEndPoint("127.0.0.1", 7700), new TEndPoint("127.0.0.1", 8800), new TEndPoint("127.0.0.1", 9900), new TEndPoint("127.0.0.1", 11000)), new TDataNodeLocation(10001, new TEndPoint("127.0.0.1", 6601), new TEndPoint("127.0.0.1", 7701), new TEndPoint("127.0.0.1", 8801), new TEndPoint("127.0.0.1", 9901), new TEndPoint("127.0.0.1", 11001)));
        HashMap<Integer, NodeStatus> nodeStatusMap = new HashMap<Integer, NodeStatus>();
        nodeStatusMap.put(10000, NodeStatus.Running);
        nodeStatusMap.put(10001, NodeStatus.Running);
        RemoveDataNodesProcedure removeDataNodesProcedure = new RemoveDataNodesProcedure(removedDataNodes, nodeStatusMap);
        removeDataNodesProcedure.setProcId(10086L);
        AddConfigNodeProcedure addConfigNodeProcedure = new AddConfigNodeProcedure(new TConfigNodeLocation(0, new TEndPoint("0.0.0.0", 22277), new TEndPoint("0.0.0.0", 22278)), new TNodeVersionInfo());
        addConfigNodeProcedure.setProcId(888888L);
        List<Procedure> procedureList = Arrays.asList(new NeverFinishProcedure(0L), removeDataNodesProcedure, new NeverFinishProcedure(199L), addConfigNodeProcedure, new NeverFinishProcedure(29999L));
        procedureList.forEach(procedure -> procedureInfo.oldUpdateProcedure(new UpdateProcedurePlan(procedure)));
        procedureInfo.oldLoad();
        procedureInfo.upgrade();
        Assert.assertFalse((boolean)procedureInfo.isOldVersion());
        configManager.close();
        configManager = new ConfigManager();
        configManager.initConsensusManager();
        List newProcedureList = configManager.getProcedureManager().getStore().getProcedureInfo().getProcedures();
        Assert.assertEquals((long)procedureList.size(), (long)newProcedureList.size());
        Assert.assertTrue((boolean)newProcedureList.containsAll(procedureList));
    }
}

