/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure;

import org.apache.iotdb.confignode.procedure.NoopProcedureStore;
import org.apache.iotdb.confignode.procedure.ProcedureExecutor;
import org.apache.iotdb.confignode.procedure.env.TestProcEnv;
import org.apache.iotdb.confignode.procedure.store.IProcedureStore;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestProcedureBase {
    public static final Logger LOG = LoggerFactory.getLogger(TestProcedureBase.class);
    protected TestProcEnv env;
    protected IProcedureStore procStore;
    protected ProcedureExecutor<TestProcEnv> procExecutor;

    @Before
    public void setUp() {
        this.initExecutor();
        this.procStore.start();
        this.procExecutor.startWorkers();
    }

    @After
    public void tearDown() {
        this.procStore.stop();
        this.procExecutor.stop();
        this.procExecutor.join();
        this.procStore.cleanup();
    }

    protected void initExecutor() {
        this.env = new TestProcEnv();
        this.procStore = new NoopProcedureStore();
        this.procExecutor = new ProcedureExecutor((Object)this.env, this.procStore);
        this.env.setScheduler(this.procExecutor.getScheduler());
        this.procExecutor.init(4);
    }

    public TestProcEnv getEnv() {
        return this.env;
    }

    public void setEnv(TestProcEnv env) {
        this.env = env;
    }

    public IProcedureStore getProcStore() {
        return this.procStore;
    }

    public void setProcStore(IProcedureStore procStore) {
        this.procStore = procStore;
    }

    public ProcedureExecutor<TestProcEnv> getProcExecutor() {
        return this.procExecutor;
    }

    public void setProcExecutor(ProcedureExecutor<TestProcEnv> procExecutor) {
        this.procExecutor = procExecutor;
    }
}

