/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.TestProcedureBase;
import org.apache.iotdb.confignode.procedure.entity.SimpleSTMProcedure;
import org.apache.iotdb.confignode.procedure.env.TestProcEnv;
import org.apache.iotdb.confignode.procedure.util.ProcedureTestUtil;
import org.junit.Assert;
import org.junit.Test;

public class STMProcedureTest
extends TestProcedureBase {
    @Test
    public void testSubmitProcedure() {
        SimpleSTMProcedure stmProcedure = new SimpleSTMProcedure();
        long procId = this.procExecutor.submitProcedure((Procedure)stmProcedure);
        ProcedureTestUtil.waitForProcedure(this.procExecutor, procId);
        TestProcEnv env = this.getEnv();
        AtomicInteger acc = env.getAcc();
        Assert.assertEquals((long)acc.get(), (long)10L);
    }

    @Test
    public void testRolledBackProcedure() {
        SimpleSTMProcedure stmProcedure = new SimpleSTMProcedure();
        stmProcedure.throwAtIndex = 4;
        long procId = this.procExecutor.submitProcedure((Procedure)stmProcedure);
        ProcedureTestUtil.waitForProcedure(this.procExecutor, procId);
        TestProcEnv env = this.getEnv();
        AtomicInteger acc = env.getAcc();
        int success = env.successCount.get();
        int rolledback = env.rolledBackCount.get();
        System.out.println(acc.get());
        System.out.println(success);
        System.out.println(rolledback);
        Assert.assertEquals((long)(1 + success - rolledback), (long)acc.get());
    }
}

