/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.confignode.persistence.schema.TemplateTable;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TemplateTableTest {
    private static TemplateTable templateTable;
    private static final File snapshotDir;

    @BeforeClass
    public static void setup() throws IOException {
        templateTable = new TemplateTable();
        if (!snapshotDir.exists()) {
            snapshotDir.mkdirs();
        }
    }

    @AfterClass
    public static void cleanup() throws IOException {
        templateTable.clear();
        if (snapshotDir.exists()) {
            FileUtils.deleteDirectory((File)snapshotDir);
        }
    }

    @Test
    public void testSnapshot() throws IOException, MetadataException {
        Template template;
        String templateNameTmp;
        int i;
        int n = 2;
        String templateName = "template_test";
        ArrayList<Template> templates = new ArrayList<Template>();
        for (i = 0; i < n; ++i) {
            templateNameTmp = templateName + "_" + i;
            template = i == 1 ? this.newAlignedSchemaTemplate(templateNameTmp) : this.newSchemaTemplate(templateNameTmp);
            templates.add(template);
            templateTable.createTemplate(template);
        }
        templateTable.processTakeSnapshot(snapshotDir);
        templateTable.clear();
        templateTable.processLoadSnapshot(snapshotDir);
        for (i = 0; i < n; ++i) {
            templateNameTmp = templateName + "_" + i;
            template = (Template)templates.get(i);
            Assert.assertEquals((Object)template, (Object)templateTable.getTemplate(templateNameTmp));
        }
    }

    @Test
    public void testDuplicatePath() {
        List<String> measurements = Arrays.asList("s1", "s1");
        List<TSDataType> dataTypes = Arrays.asList(TSDataType.FLOAT, TSDataType.BOOLEAN);
        List<TSEncoding> encodings = Arrays.asList(TSEncoding.RLE, TSEncoding.PLAIN);
        List<CompressionType> compressors = Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY);
        try {
            new Template("template", measurements, dataTypes, encodings, compressors);
            Assert.fail((String)"expect IllegalPathException");
        }
        catch (IllegalPathException illegalPathException) {
            // empty catch block
        }
    }

    private Template newSchemaTemplate(String name) throws IllegalPathException {
        List<String> measurements = Arrays.asList(name + "_temperature", name + "_status");
        List<TSDataType> dataTypes = Arrays.asList(TSDataType.FLOAT, TSDataType.BOOLEAN);
        List<TSEncoding> encodings = Arrays.asList(TSEncoding.RLE, TSEncoding.PLAIN);
        List<CompressionType> compressors = Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY);
        return new Template(name, measurements, dataTypes, encodings, compressors);
    }

    private Template newAlignedSchemaTemplate(String name) throws IllegalPathException {
        List<String> measurements = Arrays.asList(name + "_lat", name + "_lon");
        List<TSDataType> dataTypes = Arrays.asList(TSDataType.FLOAT, TSDataType.FLOAT);
        List<TSEncoding> encodings = Arrays.asList(TSEncoding.GORILLA, TSEncoding.GORILLA);
        List<CompressionType> compressors = Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY);
        return new Template(name, measurements, dataTypes, encodings, compressors, true);
    }

    static {
        snapshotDir = new File(TestConstant.BASE_OUTPUT_PATH, "snapshot");
    }
}

