/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.confignode.persistence.schema.TemplatePreSetTable;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TemplatePreSetTableTest {
    private TemplatePreSetTable templatePreSetTable;
    private final File snapshotDir = new File(TestConstant.BASE_OUTPUT_PATH, "snapshot");

    @Before
    public void setup() throws IOException {
        this.templatePreSetTable = new TemplatePreSetTable();
        if (!this.snapshotDir.exists()) {
            this.snapshotDir.mkdirs();
        }
    }

    @After
    public void cleanup() throws IOException {
        this.templatePreSetTable = null;
        if (this.snapshotDir.exists()) {
            FileUtils.deleteDirectory((File)this.snapshotDir);
        }
    }

    @Test
    public void testPreSetTemplate() throws IllegalPathException {
        int templateId1 = 5;
        int templateId2 = 10;
        PartialPath templateSetPath1 = new PartialPath("root.db.t1");
        PartialPath templateSetPath2 = new PartialPath("root.db.t2");
        Assert.assertFalse((boolean)this.templatePreSetTable.isPreSet(templateId1, templateSetPath1));
        Assert.assertFalse((boolean)this.templatePreSetTable.removeSetTemplate(templateId1, templateSetPath1));
        Assert.assertFalse((boolean)this.templatePreSetTable.isPreSet(templateId2, templateSetPath1));
        Assert.assertFalse((boolean)this.templatePreSetTable.removeSetTemplate(templateId2, templateSetPath1));
        this.templatePreSetTable.preSetTemplate(templateId1, templateSetPath1);
        this.templatePreSetTable.preSetTemplate(templateId2, templateSetPath1);
        this.templatePreSetTable.preSetTemplate(templateId2, templateSetPath2);
        Assert.assertTrue((boolean)this.templatePreSetTable.isPreSet(templateId1, templateSetPath1));
        Assert.assertTrue((boolean)this.templatePreSetTable.isPreSet(templateId2, templateSetPath1));
        Assert.assertTrue((boolean)this.templatePreSetTable.isPreSet(templateId2, templateSetPath2));
        Assert.assertTrue((boolean)this.templatePreSetTable.removeSetTemplate(templateId1, templateSetPath1));
        Assert.assertTrue((boolean)this.templatePreSetTable.removeSetTemplate(templateId2, templateSetPath1));
        Assert.assertFalse((boolean)this.templatePreSetTable.isPreSet(templateId1, templateSetPath1));
        Assert.assertFalse((boolean)this.templatePreSetTable.isPreSet(templateId2, templateSetPath1));
        Assert.assertTrue((boolean)this.templatePreSetTable.isPreSet(templateId2, templateSetPath2));
    }

    @Test
    public void testSnapshot() throws IllegalPathException {
        int templateId1 = 5;
        int templateId2 = 10;
        PartialPath templateSetPath1 = new PartialPath("root.db.t1");
        PartialPath templateSetPath2 = new PartialPath("root.db.t2");
        try {
            this.templatePreSetTable.processTakeSnapshot(this.snapshotDir);
            TemplatePreSetTable newTemplatePreSetTable = new TemplatePreSetTable();
            Assert.assertFalse((boolean)newTemplatePreSetTable.isPreSet(templateId1, templateSetPath1));
            Assert.assertFalse((boolean)newTemplatePreSetTable.isPreSet(templateId2, templateSetPath1));
            Assert.assertFalse((boolean)newTemplatePreSetTable.isPreSet(templateId2, templateSetPath2));
            this.templatePreSetTable.preSetTemplate(templateId1, templateSetPath1);
            this.templatePreSetTable.preSetTemplate(templateId2, templateSetPath1);
            this.templatePreSetTable.preSetTemplate(templateId2, templateSetPath2);
            this.templatePreSetTable.processTakeSnapshot(this.snapshotDir);
            newTemplatePreSetTable = new TemplatePreSetTable();
            newTemplatePreSetTable.processLoadSnapshot(this.snapshotDir);
            Assert.assertTrue((boolean)this.templatePreSetTable.isPreSet(templateId1, templateSetPath1));
            Assert.assertTrue((boolean)this.templatePreSetTable.isPreSet(templateId2, templateSetPath1));
            Assert.assertTrue((boolean)this.templatePreSetTable.isPreSet(templateId2, templateSetPath2));
        }
        catch (IOException e) {
            Assert.fail();
        }
    }
}

