/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.SchemaConstant;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.confignode.persistence.schema.ConfigMTree;
import org.apache.iotdb.confignode.persistence.schema.mnode.IConfigMNode;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.tsfile.utils.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConfigMTreeTest {
    private ConfigMTree root;

    @Before
    public void setUp() throws Exception {
        this.root = new ConfigMTree();
    }

    @After
    public void tearDown() throws Exception {
        this.root.clear();
    }

    @Test
    public void testSetStorageGroupExceptionMessage() {
        try {
            this.root.setStorageGroup(new PartialPath("root.edge1.access"));
            this.root.setStorageGroup(new PartialPath("root.edge1"));
            Assert.fail((String)"Expected exception");
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"some children of root.edge1 have already been created as database", (Object)e.getMessage());
        }
        try {
            this.root.setStorageGroup(new PartialPath("root.edge2"));
            this.root.setStorageGroup(new PartialPath("root.edge2.access"));
            Assert.fail((String)"Expected exception");
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"root.edge2 has already been created as database", (Object)e.getMessage());
        }
        try {
            this.root.setStorageGroup(new PartialPath("root.edge1.access"));
            Assert.fail((String)"Expected exception");
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"root.edge1.access has already been created as database", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddAndPathExist() throws MetadataException {
        String path1 = "root";
        this.root.setStorageGroup(new PartialPath("root.laptop"));
        Assert.assertTrue((boolean)this.root.isDatabaseAlreadySet(new PartialPath(path1)));
        Assert.assertTrue((boolean)this.root.isDatabaseAlreadySet(new PartialPath("root.laptop")));
        Assert.assertTrue((boolean)this.root.isDatabaseAlreadySet(new PartialPath("root.laptop.d1")));
    }

    @Test
    public void testSetStorageGroup() throws IllegalPathException {
        try {
            this.root.setStorageGroup(new PartialPath("root.laptop.d1"));
            Assert.assertTrue((boolean)this.root.isDatabaseAlreadySet(new PartialPath("root.laptop.d1")));
            Assert.assertTrue((boolean)this.root.isDatabaseAlreadySet(new PartialPath("root.laptop.d1.s1")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            this.root.setStorageGroup(new PartialPath("root.laptop.d2"));
        }
        catch (MetadataException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            this.root.setStorageGroup(new PartialPath("root.laptop"));
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"some children of root.laptop have already been created as database", (Object)e.getMessage());
        }
        try {
            this.root.deleteDatabase(new PartialPath("root.laptop.d1"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)this.root.isDatabaseAlreadySet(new PartialPath("root.laptop.d1")));
        Assert.assertTrue((boolean)this.root.isDatabaseAlreadySet(new PartialPath("root.laptop")));
        Assert.assertTrue((boolean)this.root.isDatabaseAlreadySet(new PartialPath("root.laptop.d2")));
    }

    @Test
    public void testGetAllFileNamesByPath() {
        try {
            this.root.setStorageGroup(new PartialPath("root.laptop.d1"));
            this.root.setStorageGroup(new PartialPath("root.laptop.d2"));
            ArrayList<PartialPath> list = new ArrayList<PartialPath>();
            list.add(new PartialPath("root.laptop.d1"));
            Assert.assertEquals(list, (Object)this.root.getBelongedDatabases(new PartialPath("root.laptop.d1.s1")));
            Assert.assertEquals(list, (Object)this.root.getBelongedDatabases(new PartialPath("root.laptop.d1")));
            list.add(new PartialPath("root.laptop.d2"));
            Assert.assertEquals(list, (Object)this.root.getBelongedDatabases(new PartialPath("root.laptop.**")));
            Assert.assertEquals(list, (Object)this.root.getBelongedDatabases(new PartialPath("root.**")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCheckStorageExistOfPath() {
        try {
            Assert.assertTrue((boolean)this.root.getBelongedDatabases(new PartialPath("root")).isEmpty());
            Assert.assertTrue((boolean)this.root.getBelongedDatabases(new PartialPath("root.vehicle")).isEmpty());
            Assert.assertTrue((boolean)this.root.getBelongedDatabases(new PartialPath("root.vehicle.device0")).isEmpty());
            Assert.assertTrue((boolean)this.root.getBelongedDatabases(new PartialPath("root.vehicle.device0.sensor")).isEmpty());
            this.root.setStorageGroup(new PartialPath("root.vehicle"));
            Assert.assertFalse((boolean)this.root.getBelongedDatabases(new PartialPath("root.vehicle")).isEmpty());
            Assert.assertFalse((boolean)this.root.getBelongedDatabases(new PartialPath("root.vehicle.device0")).isEmpty());
            Assert.assertFalse((boolean)this.root.getBelongedDatabases(new PartialPath("root.vehicle.device0.sensor")).isEmpty());
            Assert.assertTrue((boolean)this.root.getBelongedDatabases(new PartialPath("root.vehicle1")).isEmpty());
            Assert.assertTrue((boolean)this.root.getBelongedDatabases(new PartialPath("root.vehicle1.device0")).isEmpty());
            this.root.setStorageGroup(new PartialPath("root.vehicle1.device0"));
            Assert.assertTrue((boolean)this.root.getBelongedDatabases(new PartialPath("root.vehicle1.device1")).isEmpty());
            Assert.assertTrue((boolean)this.root.getBelongedDatabases(new PartialPath("root.vehicle1.device2")).isEmpty());
            Assert.assertTrue((boolean)this.root.getBelongedDatabases(new PartialPath("root.vehicle1.device3")).isEmpty());
            Assert.assertFalse((boolean)this.root.getBelongedDatabases(new PartialPath("root.vehicle1.device0")).isEmpty());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIllegalStorageGroup() {
        try {
            this.root.setStorageGroup(new PartialPath("root.\"sg.ln\""));
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"root.\"sg.ln\" is not a legal path", (Object)e.getMessage());
        }
    }

    @Test
    public void testCountStorageGroup() throws MetadataException {
        this.root.setStorageGroup(new PartialPath("root.sg1"));
        this.root.setStorageGroup(new PartialPath("root.a.sg1"));
        this.root.setStorageGroup(new PartialPath("root.a.b.sg1"));
        this.root.setStorageGroup(new PartialPath("root.sg2"));
        this.root.setStorageGroup(new PartialPath("root.a.sg2"));
        this.root.setStorageGroup(new PartialPath("root.sg3"));
        this.root.setStorageGroup(new PartialPath("root.a.b.sg3"));
        Assert.assertEquals((long)7L, (long)this.root.getDatabaseNum(new PartialPath("root.**"), SchemaConstant.ALL_MATCH_SCOPE, false));
        Assert.assertEquals((long)3L, (long)this.root.getDatabaseNum(new PartialPath("root.*"), SchemaConstant.ALL_MATCH_SCOPE, false));
        Assert.assertEquals((long)2L, (long)this.root.getDatabaseNum(new PartialPath("root.*.*"), SchemaConstant.ALL_MATCH_SCOPE, false));
        Assert.assertEquals((long)2L, (long)this.root.getDatabaseNum(new PartialPath("root.*.*.*"), SchemaConstant.ALL_MATCH_SCOPE, false));
        Assert.assertEquals((long)1L, (long)this.root.getDatabaseNum(new PartialPath("root.*.sg1"), SchemaConstant.ALL_MATCH_SCOPE, false));
        Assert.assertEquals((long)2L, (long)this.root.getDatabaseNum(new PartialPath("root.**.sg1"), SchemaConstant.ALL_MATCH_SCOPE, false));
        Assert.assertEquals((long)1L, (long)this.root.getDatabaseNum(new PartialPath("root.sg3"), SchemaConstant.ALL_MATCH_SCOPE, false));
        Assert.assertEquals((long)2L, (long)this.root.getDatabaseNum(new PartialPath("root.*.b.*"), SchemaConstant.ALL_MATCH_SCOPE, false));
    }

    @Test
    public void testGetNodeListInLevel() throws MetadataException {
        this.root.setStorageGroup(new PartialPath("root.sg1"));
        this.root.setStorageGroup(new PartialPath("root.sg2"));
        Pair result = this.root.getNodesListInGivenLevel(new PartialPath("root.**"), 3, false, SchemaConstant.ALL_MATCH_SCOPE);
        Assert.assertEquals((long)0L, (long)((List)result.left).size());
        Assert.assertEquals((long)2L, (long)((Set)result.right).size());
        result = this.root.getNodesListInGivenLevel(new PartialPath("root.**"), 1, false, SchemaConstant.ALL_MATCH_SCOPE);
        Assert.assertEquals((long)2L, (long)((List)result.left).size());
        Assert.assertEquals((long)2L, (long)((Set)result.right).size());
        result = this.root.getNodesListInGivenLevel(new PartialPath("root.*.*"), 2, false, SchemaConstant.ALL_MATCH_SCOPE);
        Assert.assertEquals((long)0L, (long)((List)result.left).size());
        Assert.assertEquals((long)2L, (long)((Set)result.right).size());
        result = this.root.getNodesListInGivenLevel(new PartialPath("root.*.*"), 1, false, SchemaConstant.ALL_MATCH_SCOPE);
        Assert.assertEquals((long)0L, (long)((List)result.left).size());
        Assert.assertEquals((long)2L, (long)((Set)result.right).size());
        this.root.setStorageGroup(new PartialPath("root.test.`001.002.003`"));
        this.root.setStorageGroup(new PartialPath("root.test.g_0.s_0_b001"));
        this.root.setStorageGroup(new PartialPath("root.sg"));
        this.root.setStorageGroup(new PartialPath("root.ln"));
        result = this.root.getNodesListInGivenLevel(new PartialPath("root.*.*.s1"), 2, true, SchemaConstant.ALL_MATCH_SCOPE);
        Assert.assertEquals((long)0L, (long)((List)result.left).size());
        Assert.assertEquals((long)5L, (long)((Set)result.right).size());
        Assert.assertTrue((boolean)((Set)result.right).contains(new PartialPath("root.sg1")));
        Assert.assertTrue((boolean)((Set)result.right).contains(new PartialPath("root.sg2")));
        Assert.assertTrue((boolean)((Set)result.right).contains(new PartialPath("root.sg")));
        Assert.assertTrue((boolean)((Set)result.right).contains(new PartialPath("root.ln")));
        Assert.assertTrue((boolean)((Set)result.right).contains(new PartialPath("root.test.`001.002.003`")));
    }

    @Test
    public void testSerialization() throws Exception {
        PartialPath[] pathList = new PartialPath[]{new PartialPath("root.sg"), new PartialPath("root.a.sg"), new PartialPath("root.a.b.sg"), new PartialPath("root.a.a.b.sg")};
        for (int i = 0; i < pathList.length; ++i) {
            this.root.setStorageGroup(pathList[i]);
            IDatabaseMNode storageGroupMNode = this.root.getDatabaseNodeByDatabasePath(pathList[i]);
            ((IConfigMNode)storageGroupMNode.getAsMNode()).getDatabaseSchema().setDataReplicationFactor(i);
            ((IConfigMNode)storageGroupMNode.getAsMNode()).getDatabaseSchema().setSchemaReplicationFactor(i);
            ((IConfigMNode)storageGroupMNode.getAsMNode()).getDatabaseSchema().setTimePartitionInterval((long)i);
            this.root.getNodeWithAutoCreate(pathList[i].concatNode("a")).setSchemaTemplateId(i);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.root.serialize((OutputStream)outputStream);
        ConfigMTree newTree = new ConfigMTree();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        newTree.deserialize((InputStream)inputStream);
        for (int i = 0; i < pathList.length; ++i) {
            TDatabaseSchema storageGroupSchema = ((IConfigMNode)newTree.getDatabaseNodeByDatabasePath(pathList[i]).getAsMNode()).getDatabaseSchema();
            Assert.assertEquals((long)i, (long)storageGroupSchema.getSchemaReplicationFactor());
            Assert.assertEquals((long)i, (long)storageGroupSchema.getDataReplicationFactor());
            Assert.assertEquals((long)i, (long)storageGroupSchema.getTimePartitionInterval());
            Assert.assertEquals((long)i, (long)newTree.getNodeWithAutoCreate(pathList[i].concatNode("a")).getSchemaTemplateId());
        }
        Assert.assertEquals((long)3L, (long)newTree.getMatchedDatabases(new PartialPath("root.**.sg"), SchemaConstant.ALL_MATCH_SCOPE, false).size());
        Assert.assertEquals((long)2L, (long)newTree.getMatchedDatabases(new PartialPath("root.**.b.sg"), SchemaConstant.ALL_MATCH_SCOPE, false).size());
        Assert.assertEquals((long)1L, (long)newTree.getMatchedDatabases(new PartialPath("root.*.*.sg"), SchemaConstant.ALL_MATCH_SCOPE, false).size());
        Assert.assertEquals((long)3L, (long)newTree.getMatchedDatabases(new PartialPath("root.a"), SchemaConstant.ALL_MATCH_SCOPE, true).size());
        Assert.assertEquals((long)1L, (long)newTree.getMatchedDatabases(new PartialPath("root.a.b"), SchemaConstant.ALL_MATCH_SCOPE, true).size());
        Assert.assertEquals((long)1L, (long)newTree.getMatchedDatabases(new PartialPath("root.a.b.sg"), SchemaConstant.ALL_MATCH_SCOPE, true).size());
    }

    @Test
    public void testSetTemplate() throws MetadataException {
        this.root.setStorageGroup(new PartialPath("root.a"));
        PartialPath path = new PartialPath("root.a.template0");
        try {
            this.root.checkTemplateOnPath(path);
        }
        catch (MetadataException e) {
            Assert.fail();
        }
        IConfigMNode node = this.root.getNodeWithAutoCreate(path);
        node.setSchemaTemplateId(0);
        try {
            this.root.checkTemplateOnPath(path);
            Assert.fail();
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        path = new PartialPath("root.a.b.template0");
        node = this.root.getNodeWithAutoCreate(path);
        node.setSchemaTemplateId(0);
        try {
            this.root.checkTemplateOnPath(path);
            Assert.fail();
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        try {
            List pathList = this.root.getPathsSetOnTemplate(0, SchemaConstant.ALL_MATCH_SCOPE, false);
            Assert.assertTrue((boolean)pathList.contains("root.a.template0"));
            Assert.assertTrue((boolean)pathList.contains("root.a.b.template0"));
        }
        catch (MetadataException e) {
            Assert.fail();
        }
    }
}

