/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.udf.UDFInformation;
import org.apache.iotdb.confignode.consensus.request.write.function.CreateFunctionPlan;
import org.apache.iotdb.confignode.persistence.UDFInfo;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.thrift.TException;
import org.apache.tsfile.utils.Binary;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class UDFInfoTest {
    private static UDFInfo udfInfo;
    private static UDFInfo udfInfoSaveBefore;
    private static final File snapshotDir;

    @BeforeClass
    public static void setup() throws IOException {
        udfInfo = new UDFInfo();
        udfInfoSaveBefore = new UDFInfo();
        if (!snapshotDir.exists()) {
            snapshotDir.mkdirs();
        }
    }

    @AfterClass
    public static void cleanup() throws IOException {
        udfInfo.clear();
        if (snapshotDir.exists()) {
            FileUtils.deleteDirectory((File)snapshotDir);
        }
    }

    @Test
    public void testSnapshot() throws TException, IOException, IllegalPathException {
        UDFInformation udfInformation = new UDFInformation("test1", "test1", false, true, "test1.jar", "12345");
        CreateFunctionPlan createFunctionPlan = new CreateFunctionPlan(udfInformation, new Binary(new byte[]{1, 2, 3}));
        udfInfo.addUDFInTable(createFunctionPlan);
        udfInfoSaveBefore.addUDFInTable(createFunctionPlan);
        udfInformation = new UDFInformation("test2", "test2", false, true, "test2.jar", "123456");
        createFunctionPlan = new CreateFunctionPlan(udfInformation, new Binary(new byte[]{1, 2, 3}));
        udfInfo.addUDFInTable(createFunctionPlan);
        udfInfoSaveBefore.addUDFInTable(createFunctionPlan);
        udfInfo.processTakeSnapshot(snapshotDir);
        udfInfo.clear();
        udfInfo.processLoadSnapshot(snapshotDir);
        Assert.assertEquals((Object)udfInfoSaveBefore.getRawExistedJarToMD5(), (Object)udfInfo.getRawExistedJarToMD5());
        Assert.assertEquals((Object)udfInfoSaveBefore.getRawUDFTable(), (Object)udfInfo.getRawUDFTable());
    }

    static {
        snapshotDir = new File(TestConstant.BASE_OUTPUT_PATH, "snapshot");
    }
}

