/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.confignode.consensus.request.read.ttl.ShowTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.response.ttl.ShowTTLResp;
import org.apache.iotdb.confignode.persistence.TTLInfo;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.apache.tsfile.read.common.parser.PathNodesGenerator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TTLInfoTest {
    private TTLInfo ttlInfo;
    private final File snapshotDir = new File(TestConstant.BASE_OUTPUT_PATH, "ttlInfo-snapshot");
    private final long ttl = 123435565323L;
    private long[] originTTLArr;

    @Before
    public void setup() throws IOException {
        if (!this.snapshotDir.exists()) {
            this.snapshotDir.mkdirs();
        }
        this.originTTLArr = CommonDescriptor.getInstance().getConfig().getTierTTLInMs();
        long[] ttlArr = new long[]{10000000L, 123435565323L};
        CommonDescriptor.getInstance().getConfig().setTierTTLInMs(ttlArr);
        this.ttlInfo = new TTLInfo();
    }

    @After
    public void tearDown() throws IOException {
        if (this.snapshotDir.exists()) {
            FileUtils.deleteDirectory((File)this.snapshotDir);
        }
        CommonDescriptor.getInstance().getConfig().setTierTTLInMs(this.originTTLArr);
    }

    @Test
    public void testSetAndUnsetTTL() throws IllegalPathException {
        ShowTTLResp resp = this.ttlInfo.showTTL(new ShowTTLPlan());
        Map ttlMap = resp.getPathTTLMap();
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        resultMap.put("root.**", Long.MAX_VALUE);
        Assert.assertEquals(resultMap, (Object)ttlMap);
        Assert.assertEquals((long)1L, (long)this.ttlInfo.getTTLCount());
        PartialPath path = new PartialPath("root.test.db1.**");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 121322323L));
        resultMap.put(path.getFullPath(), 121322323L);
        Assert.assertEquals(resultMap, (Object)this.ttlInfo.showTTL(new ShowTTLPlan()).getPathTTLMap());
        Assert.assertEquals((long)2L, (long)this.ttlInfo.getTTLCount());
        path = new PartialPath("root.test.db1.group1.group1.d1");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 2222L));
        resultMap.put(path.getFullPath(), 2222L);
        Assert.assertEquals(resultMap, (Object)this.ttlInfo.showTTL(new ShowTTLPlan()).getPathTTLMap());
        Assert.assertEquals((long)3L, (long)this.ttlInfo.getTTLCount());
        path = new PartialPath("root.test.db1.group1.group2.d1");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 1L));
        resultMap.put(path.getFullPath(), 1L);
        Assert.assertEquals(resultMap, (Object)this.ttlInfo.showTTL(new ShowTTLPlan()).getPathTTLMap());
        Assert.assertEquals((long)4L, (long)this.ttlInfo.getTTLCount());
        path = new PartialPath("root.test1.db1.group1.group2.d1");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 599722L));
        resultMap.put(path.getFullPath(), 599722L);
        Assert.assertEquals(resultMap, (Object)this.ttlInfo.showTTL(new ShowTTLPlan()).getPathTTLMap());
        Assert.assertEquals((long)5L, (long)this.ttlInfo.getTTLCount());
        path = new PartialPath("root.test1.db1.group1.group2.d1.**");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 9999999L));
        resultMap.put(path.getFullPath(), 9999999L);
        Assert.assertEquals(resultMap, (Object)this.ttlInfo.showTTL(new ShowTTLPlan()).getPathTTLMap());
        Assert.assertEquals((long)6L, (long)this.ttlInfo.getTTLCount());
        path = new PartialPath("root.test1.db1.group1.group2.d1.d2.**");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 888888L));
        resultMap.put(path.getFullPath(), 888888L);
        Assert.assertEquals(resultMap, (Object)this.ttlInfo.showTTL(new ShowTTLPlan()).getPathTTLMap());
        Assert.assertEquals((long)7L, (long)this.ttlInfo.getTTLCount());
        path = new PartialPath("root.test1.db1.group1.group2.d1.d2");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 9898989898L));
        resultMap.put(path.getFullPath(), 9898989898L);
        Assert.assertEquals(resultMap, (Object)this.ttlInfo.showTTL(new ShowTTLPlan()).getPathTTLMap());
        Assert.assertEquals((long)8L, (long)this.ttlInfo.getTTLCount());
        path = new PartialPath("root.test.db1.group1.group2.d1");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 11111222L));
        resultMap.put(path.getFullPath(), 11111222L);
        Assert.assertEquals(resultMap, (Object)this.ttlInfo.showTTL(new ShowTTLPlan()).getPathTTLMap());
        Assert.assertEquals((long)8L, (long)this.ttlInfo.getTTLCount());
        path = new PartialPath("root.test.db1.group1");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), Long.MAX_VALUE));
        resultMap.put(path.getFullPath(), Long.MAX_VALUE);
        Assert.assertEquals(resultMap, (Object)this.ttlInfo.showTTL(new ShowTTLPlan()).getPathTTLMap());
        Assert.assertEquals((long)9L, (long)this.ttlInfo.getTTLCount());
        path = new PartialPath("root.**");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 222222L));
        resultMap.put(path.getFullPath(), 222222L);
        Assert.assertEquals(resultMap, (Object)this.ttlInfo.showTTL(new ShowTTLPlan()).getPathTTLMap());
        Assert.assertEquals((long)9L, (long)this.ttlInfo.getTTLCount());
        path = new PartialPath("root.test.db1.group1.group2");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), -1L));
        Assert.assertEquals(resultMap, (Object)this.ttlInfo.showTTL(new ShowTTLPlan()).getPathTTLMap());
        Assert.assertEquals((long)9L, (long)this.ttlInfo.getTTLCount());
        path = new PartialPath("root.test.db1.group1.group2");
        this.ttlInfo.unsetTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), -1L));
        resultMap.remove(path.getFullPath());
        Assert.assertEquals(resultMap, (Object)this.ttlInfo.showTTL(new ShowTTLPlan()).getPathTTLMap());
        Assert.assertEquals((long)9L, (long)this.ttlInfo.getTTLCount());
        path = new PartialPath("root.test.db1.group1");
        this.ttlInfo.unsetTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), -1L));
        resultMap.remove(path.getFullPath());
        Assert.assertEquals(resultMap, (Object)this.ttlInfo.showTTL(new ShowTTLPlan()).getPathTTLMap());
        Assert.assertEquals((long)8L, (long)this.ttlInfo.getTTLCount());
        path = new PartialPath("root.**");
        this.ttlInfo.unsetTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), -1L));
        resultMap.put(path.getFullPath(), Long.MAX_VALUE);
        Assert.assertEquals(resultMap, (Object)this.ttlInfo.showTTL(new ShowTTLPlan()).getPathTTLMap());
        Assert.assertEquals((long)8L, (long)this.ttlInfo.getTTLCount());
        path = new PartialPath("root.test1.db1.group1.group2.d1.d2");
        this.ttlInfo.unsetTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), -1L));
        resultMap.remove(path.getFullPath());
        Assert.assertEquals(resultMap, (Object)this.ttlInfo.showTTL(new ShowTTLPlan()).getPathTTLMap());
        Assert.assertEquals((long)7L, (long)this.ttlInfo.getTTLCount());
        path = new PartialPath("root.test.db1.**");
        this.ttlInfo.unsetTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), -1L));
        resultMap.remove(path.getFullPath());
        Assert.assertEquals(resultMap, (Object)this.ttlInfo.showTTL(new ShowTTLPlan()).getPathTTLMap());
        Assert.assertEquals((long)6L, (long)this.ttlInfo.getTTLCount());
        path = new PartialPath("root.test1.db1.group1.group2.d1");
        this.ttlInfo.unsetTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), -1L));
        resultMap.remove(path.getFullPath());
        Assert.assertEquals(resultMap, (Object)this.ttlInfo.showTTL(new ShowTTLPlan()).getPathTTLMap());
        Assert.assertEquals((long)5L, (long)this.ttlInfo.getTTLCount());
        path = new PartialPath("root.test1.db1.group1.group2.d1.d2.**");
        this.ttlInfo.unsetTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), -1L));
        resultMap.remove(path.getFullPath());
        Assert.assertEquals(resultMap, (Object)this.ttlInfo.showTTL(new ShowTTLPlan()).getPathTTLMap());
        Assert.assertEquals((long)4L, (long)this.ttlInfo.getTTLCount());
    }

    @Test
    public void testUnsetNonExistTTL() throws IllegalPathException {
        Assert.assertEquals((long)TSStatusCode.ILLEGAL_PATH.getStatusCode(), (long)this.ttlInfo.unsetTTL(new SetTTLPlan(-1L, new String[]{"root"})).getCode());
        Assert.assertEquals((long)TSStatusCode.PATH_NOT_EXIST.getStatusCode(), (long)this.ttlInfo.unsetTTL(new SetTTLPlan(-1L, new String[]{"root", "sg100", "f10", "d1"})).getCode());
        PartialPath path = new PartialPath("root.test.db1.group1.group2.d1");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 11111222L));
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)this.ttlInfo.unsetTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 11111222L)).getCode());
        Assert.assertEquals((long)TSStatusCode.PATH_NOT_EXIST.getStatusCode(), (long)this.ttlInfo.unsetTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 11111222L)).getCode());
    }

    @Test
    public void testTooManyTTL() {
        int tTlRuleCapacity = CommonDescriptor.getInstance().getConfig().getTTlRuleCapacity();
        for (int i = 0; i < tTlRuleCapacity - 1; ++i) {
            SetTTLPlan setTTLPlan = new SetTTLPlan(PathNodesGenerator.splitPathToNodes((String)("root.sg1.d" + i + ".**")), 1000L);
            Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)this.ttlInfo.setTTL((SetTTLPlan)setTTLPlan).code);
        }
        SetTTLPlan setTTLPlan = new SetTTLPlan(PathNodesGenerator.splitPathToNodes((String)("root.sg1.d" + tTlRuleCapacity + ".**")), 1000L);
        TSStatus status = this.ttlInfo.setTTL(setTTLPlan);
        Assert.assertEquals((long)TSStatusCode.OVERSIZE_TTL.getStatusCode(), (long)status.code);
        Assert.assertEquals((Object)"The number of TTL rules has reached the limit (1000). Please delete some existing rules first.", (Object)status.message);
    }

    @Test
    public void testSnapshot() throws TException, IOException, IllegalPathException {
        PartialPath path = new PartialPath("root.test.db1.**");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 121322323L));
        path = new PartialPath("root.test.db1.group1.group1.d1");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 2222L));
        path = new PartialPath("root.test.db1.group1.group2.d1");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 1L));
        path = new PartialPath("root.test1.db1.group1.group2.d1");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 599722L));
        path = new PartialPath("root.test1.db1.group1.group2.d1.**");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 9999999L));
        path = new PartialPath("root.test1.db1.group1.group2.d1.d2.**");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 888888L));
        path = new PartialPath("root.test1.db1.group1.group2.d1.d2");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 9898989898L));
        path = new PartialPath("root.test.db1.group1.group2.d1");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 11111222L));
        path = new PartialPath("root.test.db1.group1");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), Long.MAX_VALUE));
        path = new PartialPath("root.**");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), 222222L));
        path = new PartialPath("root.test.db1.group1.group2");
        this.ttlInfo.setTTL(new SetTTLPlan(Arrays.asList(path.getNodes()), -1L));
        this.ttlInfo.processTakeSnapshot(this.snapshotDir);
        TTLInfo actualTTLInfo = new TTLInfo();
        actualTTLInfo.processLoadSnapshot(this.snapshotDir);
        Assert.assertTrue((boolean)this.ttlInfo.equals((Object)actualTTLInfo));
    }
}

