/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TSpaceQuota;
import org.apache.iotdb.common.rpc.thrift.TThrottleQuota;
import org.apache.iotdb.common.rpc.thrift.TTimedQuota;
import org.apache.iotdb.common.rpc.thrift.ThrottleType;
import org.apache.iotdb.confignode.consensus.request.write.quota.SetSpaceQuotaPlan;
import org.apache.iotdb.confignode.consensus.request.write.quota.SetThrottleQuotaPlan;
import org.apache.iotdb.confignode.persistence.quota.QuotaInfo;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QuotaInfoTest {
    private QuotaInfo quotaInfo;
    private static final File snapshotDir = new File(TestConstant.BASE_OUTPUT_PATH, "snapshot");

    @Before
    public void setup() throws IOException {
        this.quotaInfo = new QuotaInfo();
        if (!snapshotDir.exists()) {
            snapshotDir.mkdirs();
        }
    }

    @After
    public void cleanup() throws IOException {
        if (snapshotDir.exists()) {
            FileUtils.deleteDirectory((File)snapshotDir);
        }
    }

    private void prepareSpaceQuotaInfo() {
        ArrayList<String> prefixPathList = new ArrayList<String>();
        prefixPathList.add("root.sg");
        prefixPathList.add("root.ln");
        TSpaceQuota spaceQuota = new TSpaceQuota();
        spaceQuota.setTimeserieNum(10000L);
        spaceQuota.setDeviceNum(100L);
        spaceQuota.setDiskSize(512L);
        SetSpaceQuotaPlan setSpaceQuotaPlan = new SetSpaceQuotaPlan(prefixPathList, spaceQuota);
        this.quotaInfo.setSpaceQuota(setSpaceQuotaPlan);
    }

    private void prepareThrottleQuotaInfo() {
        String userName = "tempUser";
        HashMap<ThrottleType, TTimedQuota> quotaLimit = new HashMap<ThrottleType, TTimedQuota>();
        quotaLimit.put(ThrottleType.READ_NUMBER, new TTimedQuota(1000L, 1000L));
        quotaLimit.put(ThrottleType.READ_SIZE, new TTimedQuota(2000L, 2000L));
        TThrottleQuota throttleQuota = new TThrottleQuota();
        throttleQuota.setThrottleLimit(quotaLimit);
        throttleQuota.setMemLimit(1000L);
        throttleQuota.setCpuLimit(3);
        SetThrottleQuotaPlan setThrottleQuotaPlan = new SetThrottleQuotaPlan(userName, throttleQuota);
        this.quotaInfo.setThrottleQuota(setThrottleQuotaPlan);
    }

    @Test
    public void testSnapshot() throws TException, IOException {
        this.prepareSpaceQuotaInfo();
        this.prepareThrottleQuotaInfo();
        this.quotaInfo.processTakeSnapshot(snapshotDir);
        QuotaInfo quotaInfo2 = new QuotaInfo();
        quotaInfo2.processLoadSnapshot(snapshotDir);
        Assert.assertEquals((Object)this.quotaInfo.getSpaceQuotaLimit(), (Object)quotaInfo2.getSpaceQuotaLimit());
        Assert.assertEquals((Object)this.quotaInfo.getThrottleQuotaLimit(), (Object)quotaInfo2.getThrottleQuotaLimit());
    }
}

