/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.util.stream.LongStream;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.confignode.consensus.request.write.procedure.UpdateProcedurePlan;
import org.apache.iotdb.confignode.persistence.ProcedureInfo;
import org.apache.iotdb.confignode.procedure.Procedure;
import org.apache.iotdb.confignode.procedure.impl.testonly.NeverFinishProcedure;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ProcedureInfoTest {
    private static final ProcedureInfo procedureInfo = new ProcedureInfo(null);
    private static final File snapshotDir = new File(TestConstant.BASE_OUTPUT_PATH, "snapshot");

    @BeforeClass
    public static void setup() {
        if (!snapshotDir.exists()) {
            snapshotDir.mkdirs();
        }
    }

    @AfterClass
    public static void cleanup() {
        if (snapshotDir.exists()) {
            FileUtils.deleteFileOrDirectory((File)snapshotDir);
        }
    }

    @Test
    public void testProcedureId() {
        long lastProcedureId = 100L;
        LongStream.range(0L, 100L).forEach(id -> procedureInfo.updateProcedure(new UpdateProcedurePlan((Procedure)new NeverFinishProcedure(id))));
        Assert.assertEquals((long)procedureInfo.getNextProcId(), (long)100L);
    }

    @Test
    public void testSnapshot() throws Exception {
        procedureInfo.updateProcedure(new UpdateProcedurePlan((Procedure)new NeverFinishProcedure(1L)));
        procedureInfo.updateProcedure(new UpdateProcedurePlan((Procedure)new NeverFinishProcedure(100L)));
        procedureInfo.updateProcedure(new UpdateProcedurePlan((Procedure)new NeverFinishProcedure(99999L)));
        Assert.assertTrue((boolean)procedureInfo.processTakeSnapshot(snapshotDir));
        ProcedureInfo procedureInfo1 = new ProcedureInfo(null);
        procedureInfo1.processLoadSnapshot(snapshotDir);
        Assert.assertEquals((Object)procedureInfo, (Object)procedureInfo1);
    }
}

