/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.PipePluginMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStatus;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.confignode.consensus.request.write.pipe.plugin.CreatePipePluginPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.plugin.DropPipePluginPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.CreatePipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.DropPipePlanV2;
import org.apache.iotdb.confignode.consensus.request.write.pipe.task.SetPipeStatusPlanV2;
import org.apache.iotdb.confignode.persistence.pipe.PipeInfo;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.thrift.TException;
import org.apache.tsfile.common.conf.TSFileConfig;
import org.apache.tsfile.utils.Binary;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PipeInfoTest {
    private static PipeInfo pipeInfo;
    private static final File snapshotDir;
    private final String pipeName = "testPipe";
    private final String pluginName = "testPlugin";

    @Before
    public void setup() throws IOException {
        pipeInfo = new PipeInfo();
        if (!snapshotDir.exists()) {
            snapshotDir.mkdirs();
        }
    }

    @After
    public void cleanup() throws IOException {
        if (snapshotDir.exists()) {
            FileUtils.deleteDirectory((File)snapshotDir);
        }
    }

    @Test
    public void testSnapshot() throws TException, IOException {
        HashMap<String, String> extractorAttributes = new HashMap<String, String>();
        HashMap<String, String> processorAttributes = new HashMap<String, String>();
        HashMap<String, String> connectorAttributes = new HashMap<String, String>();
        extractorAttributes.put("extractor", "iotdb-extractor");
        processorAttributes.put("processor", "do-nothing-processor");
        connectorAttributes.put("connector", "iotdb-thrift-connector");
        connectorAttributes.put("host", "127.0.0.1");
        connectorAttributes.put("port", "6667");
        PipeTaskMeta pipeTaskMeta = new PipeTaskMeta((ProgressIndex)MinimumProgressIndex.INSTANCE, 1);
        ConcurrentHashMap<Integer, PipeTaskMeta> pipeTasks = new ConcurrentHashMap<Integer, PipeTaskMeta>();
        pipeTasks.put(1, pipeTaskMeta);
        PipeStaticMeta pipeStaticMeta = new PipeStaticMeta("testPipe", 121L, extractorAttributes, processorAttributes, connectorAttributes);
        PipeRuntimeMeta pipeRuntimeMeta = new PipeRuntimeMeta(pipeTasks);
        CreatePipePlanV2 createPipePlanV2 = new CreatePipePlanV2(pipeStaticMeta, pipeRuntimeMeta);
        pipeInfo.getPipeTaskInfo().createPipe(createPipePlanV2);
        CreatePipePluginPlan createPipePluginPlan = new CreatePipePluginPlan(new PipePluginMeta("testPlugin", "org.apache.iotdb.TestJar", false, "test.jar", "???"), new Binary("123", TSFileConfig.STRING_CHARSET));
        pipeInfo.getPipePluginInfo().createPipePlugin(createPipePluginPlan);
        pipeInfo.processTakeSnapshot(snapshotDir);
        PipeInfo pipeInfo1 = new PipeInfo();
        pipeInfo1.processLoadSnapshot(snapshotDir);
        Assert.assertEquals((Object)pipeInfo.toString(), (Object)pipeInfo1.toString());
        Assert.assertEquals((Object)pipeInfo, (Object)pipeInfo1);
    }

    @Test
    public void testManagement() {
        HashMap<String, String> extractorAttributes = new HashMap<String, String>();
        HashMap<String, String> processorAttributes = new HashMap<String, String>();
        HashMap<String, String> connectorAttributes = new HashMap<String, String>();
        extractorAttributes.put("extractor", "org.apache.iotdb.pipe.extractor.DefaultExtractor");
        processorAttributes.put("processor", "org.apache.iotdb.pipe.processor.SDTFilterProcessor");
        connectorAttributes.put("connector", "org.apache.iotdb.pipe.protocol.ThriftTransporter");
        PipeTaskMeta pipeTaskMeta = new PipeTaskMeta((ProgressIndex)MinimumProgressIndex.INSTANCE, 1);
        ConcurrentHashMap<Integer, PipeTaskMeta> pipeTasks = new ConcurrentHashMap<Integer, PipeTaskMeta>();
        pipeTasks.put(1, pipeTaskMeta);
        PipeStaticMeta pipeStaticMeta = new PipeStaticMeta("testPipe", 121L, extractorAttributes, processorAttributes, connectorAttributes);
        PipeRuntimeMeta pipeRuntimeMeta = new PipeRuntimeMeta(pipeTasks);
        CreatePipePlanV2 createPipePlanV2 = new CreatePipePlanV2(pipeStaticMeta, pipeRuntimeMeta);
        pipeInfo.getPipeTaskInfo().createPipe(createPipePlanV2);
        Assert.assertTrue((boolean)pipeInfo.getPipeTaskInfo().isPipeExisted("testPipe"));
        SetPipeStatusPlanV2 setPipeStatusPlanV2 = new SetPipeStatusPlanV2("testPipe", PipeStatus.RUNNING);
        pipeInfo.getPipeTaskInfo().setPipeStatus(setPipeStatusPlanV2);
        DropPipePlanV2 dropPipePlanV2 = new DropPipePlanV2("testPipe");
        pipeInfo.getPipeTaskInfo().dropPipe(dropPipePlanV2);
        Assert.assertFalse((boolean)pipeInfo.getPipeTaskInfo().isPipeExisted("testPipe"));
        Assert.assertTrue((boolean)pipeInfo.getPipeTaskInfo().isEmpty());
        CreatePipePluginPlan createPipePluginPlan = new CreatePipePluginPlan(new PipePluginMeta("testPlugin", "org.apache.iotdb.TestJar", false, "test.jar", "???"), new Binary("123", TSFileConfig.STRING_CHARSET));
        pipeInfo.getPipePluginInfo().createPipePlugin(createPipePluginPlan);
        pipeInfo.getPipePluginInfo().validateBeforeDroppingPipePlugin("testPlugin", false);
        DropPipePluginPlan dropPipePluginPlan = new DropPipePluginPlan("testPlugin");
        pipeInfo.getPipePluginInfo().dropPipePlugin(dropPipePluginPlan);
    }

    static {
        snapshotDir = new File(TestConstant.BASE_OUTPUT_PATH, "snapshot");
    }
}

