/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.commons.partition.SeriesPartitionTable;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.read.region.GetRegionInfoListPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.CreateDataPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.partition.CreateSchemaPartitionPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.consensus.request.write.region.OfferRegionMaintainTasksPlan;
import org.apache.iotdb.confignode.consensus.response.partition.RegionInfoListResp;
import org.apache.iotdb.confignode.persistence.partition.PartitionInfo;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionCreateTask;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionDeleteTask;
import org.apache.iotdb.confignode.persistence.partition.maintainer.RegionMaintainTask;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.confignode.rpc.thrift.TShowRegionReq;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.thrift.TException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PartitionInfoTest {
    private static PartitionInfo partitionInfo;
    private static final File snapshotDir;

    @Before
    public void setup() {
        partitionInfo = new PartitionInfo();
        if (!snapshotDir.exists()) {
            snapshotDir.mkdirs();
        }
    }

    @After
    public void cleanup() throws IOException {
        partitionInfo.clear();
        if (snapshotDir.exists()) {
            FileUtils.deleteDirectory((File)snapshotDir);
        }
    }

    @Test
    public void testSnapshot() throws TException, IOException {
        partitionInfo.generateNextRegionGroupId();
        partitionInfo.createDatabase(new DatabaseSchemaPlan(ConfigPhysicalPlanType.CreateDatabase, new TDatabaseSchema("root.test")));
        CreateRegionGroupsPlan createRegionGroupsReq = new CreateRegionGroupsPlan();
        TRegionReplicaSet schemaRegionReplicaSet = this.generateTRegionReplicaSet(testFlag.SchemaPartition.getFlag(), this.generateTConsensusGroupId(testFlag.SchemaPartition.getFlag(), TConsensusGroupType.SchemaRegion));
        createRegionGroupsReq.addRegionGroup("root.test", schemaRegionReplicaSet);
        partitionInfo.createRegionGroups(createRegionGroupsReq);
        createRegionGroupsReq = new CreateRegionGroupsPlan();
        TRegionReplicaSet dataRegionReplicaSet = this.generateTRegionReplicaSet(testFlag.DataPartition.getFlag(), this.generateTConsensusGroupId(testFlag.DataPartition.getFlag(), TConsensusGroupType.DataRegion));
        createRegionGroupsReq.addRegionGroup("root.test", dataRegionReplicaSet);
        partitionInfo.createRegionGroups(createRegionGroupsReq);
        CreateSchemaPartitionPlan createSchemaPartitionPlan = this.generateCreateSchemaPartitionReq(testFlag.SchemaPartition.getFlag(), this.generateTConsensusGroupId(testFlag.SchemaPartition.getFlag(), TConsensusGroupType.SchemaRegion));
        partitionInfo.createSchemaPartition(createSchemaPartitionPlan);
        CreateDataPartitionPlan createDataPartitionPlan = this.generateCreateDataPartitionReq(testFlag.DataPartition.getFlag(), this.generateTConsensusGroupId(testFlag.DataPartition.getFlag(), TConsensusGroupType.DataRegion));
        partitionInfo.createDataPartition(createDataPartitionPlan);
        partitionInfo.offerRegionMaintainTasks(this.generateOfferRegionMaintainTasksPlan());
        Assert.assertTrue((boolean)partitionInfo.processTakeSnapshot(snapshotDir));
        PartitionInfo partitionInfo1 = new PartitionInfo();
        partitionInfo1.processLoadSnapshot(snapshotDir);
        Assert.assertEquals((Object)partitionInfo, (Object)partitionInfo1);
    }

    @Test
    public void testGetRegionType() {
        partitionInfo.generateNextRegionGroupId();
        partitionInfo.createDatabase(new DatabaseSchemaPlan(ConfigPhysicalPlanType.CreateDatabase, new TDatabaseSchema("root.test")));
        CreateRegionGroupsPlan createRegionGroupsPlan = new CreateRegionGroupsPlan();
        TConsensusGroupId schemaRegionId = this.generateTConsensusGroupId(testFlag.SchemaPartition.getFlag(), TConsensusGroupType.SchemaRegion);
        TRegionReplicaSet schemaRegionReplicaSet = this.generateTRegionReplicaSet(testFlag.SchemaPartition.getFlag(), schemaRegionId);
        createRegionGroupsPlan.addRegionGroup("root.test", schemaRegionReplicaSet);
        partitionInfo.createRegionGroups(createRegionGroupsPlan);
        createRegionGroupsPlan = new CreateRegionGroupsPlan();
        TConsensusGroupId dataRegionId = this.generateTConsensusGroupId(testFlag.DataPartition.getFlag(), TConsensusGroupType.DataRegion);
        TRegionReplicaSet dataRegionReplicaSet = this.generateTRegionReplicaSet(testFlag.DataPartition.getFlag(), dataRegionId);
        createRegionGroupsPlan.addRegionGroup("root.test", dataRegionReplicaSet);
        partitionInfo.createRegionGroups(createRegionGroupsPlan);
        Assert.assertEquals(Optional.of(TConsensusGroupType.SchemaRegion), (Object)partitionInfo.getRegionType(schemaRegionId.getId()));
        Assert.assertEquals(Optional.of(TConsensusGroupType.DataRegion), (Object)partitionInfo.getRegionType(dataRegionId.getId()));
        Assert.assertEquals(Optional.empty(), (Object)partitionInfo.getRegionType(-1));
    }

    @Test
    public void testShowRegion() {
        for (int i = 0; i < 2; ++i) {
            partitionInfo.generateNextRegionGroupId();
            partitionInfo.createDatabase(new DatabaseSchemaPlan(ConfigPhysicalPlanType.CreateDatabase, new TDatabaseSchema("root.test" + i)));
            CreateRegionGroupsPlan createRegionGroupsPlan = new CreateRegionGroupsPlan();
            TRegionReplicaSet schemaRegionReplicaSet = this.generateTRegionReplicaSet(testFlag.SchemaPartition.getFlag(), this.generateTConsensusGroupId(testFlag.SchemaPartition.getFlag(), TConsensusGroupType.SchemaRegion));
            createRegionGroupsPlan.addRegionGroup("root.test" + i, schemaRegionReplicaSet);
            partitionInfo.createRegionGroups(createRegionGroupsPlan);
            createRegionGroupsPlan = new CreateRegionGroupsPlan();
            TRegionReplicaSet dataRegionReplicaSet = this.generateTRegionReplicaSet(testFlag.DataPartition.getFlag(), this.generateTConsensusGroupId(testFlag.DataPartition.getFlag(), TConsensusGroupType.DataRegion));
            createRegionGroupsPlan.addRegionGroup("root.test" + i, dataRegionReplicaSet);
            partitionInfo.createRegionGroups(createRegionGroupsPlan);
        }
        GetRegionInfoListPlan regionReq = new GetRegionInfoListPlan();
        TShowRegionReq showRegionReq = new TShowRegionReq();
        showRegionReq.setConsensusGroupType(null);
        regionReq.setShowRegionReq(showRegionReq);
        RegionInfoListResp regionInfoList1 = (RegionInfoListResp)partitionInfo.getRegionInfoList(regionReq);
        Assert.assertEquals((long)20L, (long)regionInfoList1.getRegionInfoList().size());
        regionInfoList1.getRegionInfoList().forEach(regionInfo -> Assert.assertEquals((Object)"127.0.0.1", (Object)regionInfo.getClientRpcIp()));
        showRegionReq.setConsensusGroupType(TConsensusGroupType.SchemaRegion);
        RegionInfoListResp regionInfoList2 = (RegionInfoListResp)partitionInfo.getRegionInfoList(regionReq);
        Assert.assertEquals((long)10L, (long)regionInfoList2.getRegionInfoList().size());
        regionInfoList2.getRegionInfoList().forEach(regionInfo -> Assert.assertEquals((Object)TConsensusGroupType.SchemaRegion, (Object)regionInfo.getConsensusGroupId().getType()));
        showRegionReq.setConsensusGroupType(TConsensusGroupType.DataRegion);
        RegionInfoListResp regionInfoList3 = (RegionInfoListResp)partitionInfo.getRegionInfoList(regionReq);
        Assert.assertEquals((long)10L, (long)regionInfoList3.getRegionInfoList().size());
        regionInfoList3.getRegionInfoList().forEach(regionInfo -> Assert.assertEquals((Object)TConsensusGroupType.DataRegion, (Object)regionInfo.getConsensusGroupId().getType()));
        showRegionReq.setConsensusGroupType(null);
        showRegionReq.setDatabases(Collections.singletonList("root.test1"));
        RegionInfoListResp regionInfoList4 = (RegionInfoListResp)partitionInfo.getRegionInfoList(regionReq);
        Assert.assertEquals((long)10L, (long)regionInfoList4.getRegionInfoList().size());
        regionInfoList4.getRegionInfoList().forEach(regionInfo -> {
            Assert.assertEquals((Object)"127.0.0.1", (Object)regionInfo.getClientRpcIp());
            Assert.assertEquals((Object)"root.test1", (Object)regionInfo.getDatabase());
        });
    }

    private TRegionReplicaSet generateTRegionReplicaSet(int startFlag, TConsensusGroupId tConsensusGroupId) {
        TRegionReplicaSet tRegionReplicaSet = new TRegionReplicaSet();
        tRegionReplicaSet.setRegionId(tConsensusGroupId);
        ArrayList<TDataNodeLocation> dataNodeLocations = new ArrayList<TDataNodeLocation>();
        int locationNum = 5;
        for (int i = startFlag; i < locationNum + startFlag; ++i) {
            TDataNodeLocation tDataNodeLocation = new TDataNodeLocation();
            tDataNodeLocation.setDataNodeId(i);
            tDataNodeLocation.setClientRpcEndPoint(new TEndPoint("127.0.0.1", 6000 + i));
            tDataNodeLocation.setInternalEndPoint(new TEndPoint("127.0.0.1", 7000 + i));
            tDataNodeLocation.setMPPDataExchangeEndPoint(new TEndPoint("127.0.0.1", 8000 + i));
            tDataNodeLocation.setDataRegionConsensusEndPoint(new TEndPoint("127.0.0.1", 9000 + i));
            tDataNodeLocation.setSchemaRegionConsensusEndPoint(new TEndPoint("127.0.0.1", 10000 + i));
            dataNodeLocations.add(tDataNodeLocation);
        }
        tRegionReplicaSet.setDataNodeLocations(dataNodeLocations);
        return tRegionReplicaSet;
    }

    private OfferRegionMaintainTasksPlan generateOfferRegionMaintainTasksPlan() {
        TDataNodeLocation dataNodeLocation = new TDataNodeLocation();
        dataNodeLocation.setDataNodeId(0);
        dataNodeLocation.setClientRpcEndPoint(new TEndPoint("0.0.0.0", 6667));
        dataNodeLocation.setInternalEndPoint(new TEndPoint("0.0.0.0", 10730));
        dataNodeLocation.setMPPDataExchangeEndPoint(new TEndPoint("0.0.0.0", 10740));
        dataNodeLocation.setDataRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10760));
        dataNodeLocation.setSchemaRegionConsensusEndPoint(new TEndPoint("0.0.0.0", 10750));
        TRegionReplicaSet regionReplicaSet = new TRegionReplicaSet();
        regionReplicaSet.setRegionId(new TConsensusGroupId(TConsensusGroupType.DataRegion, 0));
        regionReplicaSet.setDataNodeLocations(Collections.singletonList(dataNodeLocation));
        OfferRegionMaintainTasksPlan offerPlan = new OfferRegionMaintainTasksPlan();
        offerPlan.appendRegionMaintainTask((RegionMaintainTask)new RegionCreateTask(dataNodeLocation, "root.sg", regionReplicaSet));
        offerPlan.appendRegionMaintainTask((RegionMaintainTask)new RegionCreateTask(dataNodeLocation, "root.sg", regionReplicaSet));
        offerPlan.appendRegionMaintainTask((RegionMaintainTask)new RegionDeleteTask(dataNodeLocation, new TConsensusGroupId(TConsensusGroupType.SchemaRegion, 2)));
        return offerPlan;
    }

    private CreateSchemaPartitionPlan generateCreateSchemaPartitionReq(int startFlag, TConsensusGroupId tConsensusGroupId) {
        CreateSchemaPartitionPlan createSchemaPartitionPlan = new CreateSchemaPartitionPlan();
        HashMap<String, SchemaPartitionTable> assignedSchemaPartition = new HashMap<String, SchemaPartitionTable>();
        HashMap<TSeriesPartitionSlot, TConsensusGroupId> relationInfo = new HashMap<TSeriesPartitionSlot, TConsensusGroupId>();
        relationInfo.put(new TSeriesPartitionSlot(startFlag), tConsensusGroupId);
        assignedSchemaPartition.put("root.test", new SchemaPartitionTable(relationInfo));
        createSchemaPartitionPlan.setAssignedSchemaPartition(assignedSchemaPartition);
        return createSchemaPartitionPlan;
    }

    private CreateDataPartitionPlan generateCreateDataPartitionReq(int startFlag, TConsensusGroupId tConsensusGroupId) {
        startFlag /= 10;
        CreateDataPartitionPlan createSchemaPartitionReq = new CreateDataPartitionPlan();
        HashMap<String, DataPartitionTable> dataPartitionMap = new HashMap<String, DataPartitionTable>();
        HashMap<TTimePartitionSlot, List<TConsensusGroupId>> relationInfo = new HashMap<TTimePartitionSlot, List<TConsensusGroupId>>();
        for (int i = 0; i <= startFlag; ++i) {
            relationInfo.put(new TTimePartitionSlot(System.currentTimeMillis() / 1000L + (long)i), Collections.singletonList(tConsensusGroupId));
        }
        HashMap<TSeriesPartitionSlot, SeriesPartitionTable> slotInfo = new HashMap<TSeriesPartitionSlot, SeriesPartitionTable>();
        for (int i = 0; i <= startFlag; ++i) {
            slotInfo.put(new TSeriesPartitionSlot(startFlag + i), new SeriesPartitionTable(relationInfo));
        }
        dataPartitionMap.put("root.test", new DataPartitionTable(slotInfo));
        createSchemaPartitionReq.setAssignedDataPartition(dataPartitionMap);
        return createSchemaPartitionReq;
    }

    private TConsensusGroupId generateTConsensusGroupId(int startFlag, TConsensusGroupType consensusGroupType) {
        return new TConsensusGroupId(consensusGroupType, 111000 + startFlag);
    }

    static {
        snapshotDir = new File(TestConstant.BASE_OUTPUT_PATH, "snapshot");
    }

    public static enum testFlag {
        DataPartition(20),
        SchemaPartition(30);

        private final int flag;

        private testFlag(int flag) {
            this.flag = flag;
        }

        public int getFlag() {
            return this.flag;
        }
    }
}

