/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TNodeResource;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.confignode.consensus.request.write.confignode.ApplyConfigNodePlan;
import org.apache.iotdb.confignode.consensus.request.write.datanode.RegisterDataNodePlan;
import org.apache.iotdb.confignode.persistence.node.NodeInfo;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.thrift.TException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class NodeInfoTest {
    private static NodeInfo nodeInfo;
    private static final File snapshotDir;

    @BeforeClass
    public static void setup() throws StartupException {
        nodeInfo = new NodeInfo();
        if (!snapshotDir.exists()) {
            snapshotDir.mkdirs();
        }
    }

    @AfterClass
    public static void cleanup() throws IOException {
        nodeInfo.clear();
        if (snapshotDir.exists()) {
            FileUtils.deleteDirectory((File)snapshotDir);
        }
    }

    @Test
    public void testSnapshot() throws TException, IOException {
        this.registerConfigNodes();
        this.registerDataNodes();
        Assert.assertTrue((boolean)nodeInfo.processTakeSnapshot(snapshotDir));
        NodeInfo nodeInfo1 = new NodeInfo();
        nodeInfo1.processLoadSnapshot(snapshotDir);
        Assert.assertEquals((Object)nodeInfo, (Object)nodeInfo1);
    }

    private void registerConfigNodes() {
        for (int i = 0; i < 3; ++i) {
            ApplyConfigNodePlan applyConfigNodePlan = new ApplyConfigNodePlan(new TConfigNodeLocation(10000 + i, new TEndPoint("127.0.0.1", 22200 + i), new TEndPoint("127.0.0.1", 22300 + i)));
            nodeInfo.applyConfigNode(applyConfigNodePlan);
        }
    }

    private void registerDataNodes() {
        for (int i = 3; i < 6; ++i) {
            RegisterDataNodePlan registerDataNodePlan = new RegisterDataNodePlan(this.generateTDataNodeConfiguration(i));
            nodeInfo.registerDataNode(registerDataNodePlan);
        }
    }

    private TDataNodeConfiguration generateTDataNodeConfiguration(int flag) {
        TDataNodeLocation location = this.generateTDataNodeLocation(flag);
        TNodeResource resource = new TNodeResource(16, 0x800000000L);
        return new TDataNodeConfiguration(location, resource);
    }

    private TDataNodeLocation generateTDataNodeLocation(int flag) {
        return new TDataNodeLocation(10000 + flag, new TEndPoint("127.0.0.1", 6600 + flag), new TEndPoint("127.0.0.1", 7700 + flag), new TEndPoint("127.0.0.1", 8800 + flag), new TEndPoint("127.0.0.1", 9900 + flag), new TEndPoint("127.0.0.1", 11000 + flag));
    }

    static {
        snapshotDir = new File(TestConstant.BASE_OUTPUT_PATH, "snapshot");
    }
}

