/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.pipe.datastructure.queue.ConcurrentIterableLinkedQueue;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeEnrichedPlan;
import org.apache.iotdb.confignode.manager.pipe.agent.PipeConfigNodeAgent;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigRegionWritePlanEvent;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.thrift.TException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ConfigRegionListeningQueueTest {
    private static final File snapshotDir = new File(TestConstant.BASE_OUTPUT_PATH, "snapshot");

    @BeforeClass
    public static void setup() {
        if (!snapshotDir.exists()) {
            snapshotDir.mkdirs();
        }
        PipeConfigNodeAgent.runtime().listener().open();
        PipeConfigNodeAgent.runtime().notifyLeaderReady();
    }

    @AfterClass
    public static void cleanup() throws IOException {
        PipeConfigNodeAgent.runtime().listener().close();
        if (snapshotDir.exists()) {
            FileUtils.deleteDirectory((File)snapshotDir);
        }
    }

    @Test
    public void testSnapshot() throws TException, IOException, AuthException {
        DatabaseSchemaPlan plan1 = new DatabaseSchemaPlan(ConfigPhysicalPlanType.CreateDatabase, new TDatabaseSchema("root.test1"));
        PipeEnrichedPlan plan2 = new PipeEnrichedPlan((ConfigPhysicalPlan)new AuthorPlan(ConfigPhysicalPlanType.CreateUser, "user0", "", "passwd", "", new HashSet(), false, new ArrayList()));
        PipeConfigNodeAgent.runtime().listener().tryListenToPlan((ConfigPhysicalPlan)plan1, false);
        PipeConfigNodeAgent.runtime().listener().tryListenToPlan((ConfigPhysicalPlan)plan2, false);
        PipeConfigNodeAgent.runtime().listener().processTakeSnapshot(snapshotDir);
        PipeConfigNodeAgent.runtime().listener().close();
        PipeConfigNodeAgent.runtime().listener().processLoadSnapshot(snapshotDir);
        Assert.assertTrue((boolean)PipeConfigNodeAgent.runtime().listener().isOpened());
        ConcurrentIterableLinkedQueue.DynamicIterator itr = PipeConfigNodeAgent.runtime().listener().newIterator(0L);
        Event event1 = (Event)itr.next(0L);
        Assert.assertEquals((Object)plan1, (Object)((PipeConfigRegionWritePlanEvent)event1).getConfigPhysicalPlan());
        Event event2 = (Event)itr.next(0L);
        Assert.assertEquals((Object)plan2.getInnerPlan(), (Object)((PipeConfigRegionWritePlanEvent)event2).getConfigPhysicalPlan());
        Assert.assertTrue((boolean)((PipeConfigRegionWritePlanEvent)event2).isGeneratedByPipe());
        Assert.assertNull((Object)itr.next(0L));
    }
}

