/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.confignode.consensus.request.write.confignode.UpdateClusterIdPlan;
import org.apache.iotdb.confignode.persistence.ClusterInfo;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.thrift.TException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ClusterInfoTest {
    private static ClusterInfo clusterInfo;
    private static final File snapshotDir;

    @BeforeClass
    public static void setup() throws IOException {
        clusterInfo = new ClusterInfo();
        if (!snapshotDir.exists()) {
            snapshotDir.mkdirs();
        }
    }

    @AfterClass
    public static void cleanup() throws IOException {
        if (snapshotDir.exists()) {
            FileUtils.deleteFileOrDirectory((File)snapshotDir);
        }
    }

    @Test
    public void testSnapshot() throws TException, IOException {
        String clusterId = String.valueOf(UUID.randomUUID());
        UpdateClusterIdPlan updateClusterIdPlan = new UpdateClusterIdPlan(clusterId);
        clusterInfo.updateClusterId(updateClusterIdPlan);
        Assert.assertTrue((boolean)clusterInfo.processTakeSnapshot(snapshotDir));
        ClusterInfo clusterInfo1 = new ClusterInfo();
        clusterInfo1.processLoadSnapshot(snapshotDir);
        Assert.assertEquals((Object)clusterInfo, (Object)clusterInfo1);
    }

    static {
        snapshotDir = new File(TestConstant.BASE_OUTPUT_PATH, "snapshot");
    }
}

