/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.confignode.consensus.request.write.cq.AddCQPlan;
import org.apache.iotdb.confignode.persistence.cq.CQInfo;
import org.apache.iotdb.confignode.rpc.thrift.TCreateCQReq;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.thrift.TException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class CQInfoTest {
    private static CQInfo cqInfo;
    private static final File snapshotDir;

    @BeforeClass
    public static void setup() throws IOException {
        cqInfo = new CQInfo();
        if (!snapshotDir.exists()) {
            snapshotDir.mkdirs();
        }
    }

    @AfterClass
    public static void tearDown() throws IOException {
        if (snapshotDir.exists()) {
            FileUtils.deleteDirectory((File)snapshotDir);
        }
    }

    @Test
    public void testSnapshot() throws TException, IOException {
        long executionTime = System.currentTimeMillis();
        AddCQPlan addCQPlan = new AddCQPlan(new TCreateCQReq("testCq1", 1000L, 0L, 1000L, 0L, 0, "select s1 into root.backup.d1.s1 from root.sg.d1", "create cq testCq1 BEGIN select s1 into root.backup.d1.s1 from root.sg.d1 END", "Asia", "root"), "testCq1_md5", executionTime);
        cqInfo.addCQ(addCQPlan);
        executionTime = System.currentTimeMillis();
        addCQPlan = new AddCQPlan(new TCreateCQReq("testCq2", 1000L, 0L, 1000L, 0L, 1, "select s1 into root.backup.d2.s1 from root.sg.d2", "create cq testCq2 BEGIN select s1 into root.backup.d2.s1 from root.sg.d2 END", "Asia", "root"), "testCq2_md5", executionTime);
        cqInfo.addCQ(addCQPlan);
        cqInfo.processTakeSnapshot(snapshotDir);
        CQInfo actualCQInfo = new CQInfo();
        actualCQInfo.processLoadSnapshot(snapshotDir);
        Assert.assertEquals((Object)cqInfo, (Object)actualCQInfo);
    }

    static {
        snapshotDir = new File(TestConstant.BASE_OUTPUT_PATH, "snapshot");
    }
}

