/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeSet;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CommitSetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.PreSetSchemaTemplatePlan;
import org.apache.iotdb.confignode.persistence.AuthorInfo;
import org.apache.iotdb.confignode.persistence.TTLInfo;
import org.apache.iotdb.confignode.persistence.schema.CNPhysicalPlanGenerator;
import org.apache.iotdb.confignode.persistence.schema.CNSnapshotFileType;
import org.apache.iotdb.confignode.persistence.schema.ClusterSchemaInfo;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class CNPhysicalPlanGeneratorTest {
    private static AuthorInfo authorInfo;
    private static ClusterSchemaInfo clusterSchemaInfo;
    private static TTLInfo ttlInfo;
    private static final File snapshotDir;
    private static final String USER_SNAPSHOT_FILE_NAME;
    private static final String ROLE_SNAPSHOT_FILE_NAME;
    private static final String SCHEMA_INFO_FILE_NAME = "cluster_schema.bin";
    private static final String TEMPLATE_INFO_FILE_NAME = "template_info.bin";

    private static void setupAuthorInfo() {
        authorInfo = new AuthorInfo();
        if (!snapshotDir.exists()) {
            snapshotDir.mkdir();
        }
    }

    private static void setupClusterSchemaInfo() throws IOException {
        clusterSchemaInfo = new ClusterSchemaInfo();
        if (!snapshotDir.exists()) {
            snapshotDir.mkdir();
        }
    }

    private static void setupTTLInfo() throws IOException {
        ttlInfo = new TTLInfo();
        if (!snapshotDir.exists()) {
            snapshotDir.mkdir();
        }
    }

    @After
    public void cleanUpInfo() throws AuthException {
        if (authorInfo != null) {
            authorInfo.clear();
        }
        if (clusterSchemaInfo != null) {
            clusterSchemaInfo.clear();
        }
        if (ttlInfo != null) {
            ttlInfo.clear();
        }
        FileUtils.deleteFileOrDirectory((File)snapshotDir);
    }

    @Test
    public void roleGeneratorTest() throws Exception {
        HashSet<Integer> answerSet = new HashSet<Integer>();
        String roleName = "test1";
        CNPhysicalPlanGeneratorTest.setupAuthorInfo();
        AuthorPlan plan = new AuthorPlan(ConfigPhysicalPlanType.CreateRole);
        plan.setRoleName(roleName);
        plan.setPermissions(new HashSet());
        plan.setNodeNameList(new ArrayList());
        answerSet.add(plan.hashCode());
        authorInfo.authorNonQuery(plan);
        plan = new AuthorPlan(ConfigPhysicalPlanType.GrantRole);
        plan.setRoleName(roleName);
        plan.setUserName("");
        plan.setNodeNameList(Collections.singletonList(new PartialPath("root.db.t1")));
        HashSet<Integer> pathPris = new HashSet<Integer>();
        pathPris.add(PrivilegeType.WRITE_DATA.ordinal());
        pathPris.add(PrivilegeType.WRITE_SCHEMA.ordinal());
        plan.setPermissions(pathPris);
        authorInfo.authorNonQuery(plan);
        plan.getPermissions().clear();
        plan.getPermissions().add(PrivilegeType.WRITE_DATA.ordinal());
        answerSet.add(plan.hashCode());
        plan.getPermissions().clear();
        plan.getPermissions().add(PrivilegeType.WRITE_SCHEMA.ordinal());
        answerSet.add(plan.hashCode());
        plan = new AuthorPlan(ConfigPhysicalPlanType.GrantRole);
        plan.setRoleName(roleName);
        plan.setUserName("");
        plan.setNodeNameList(Collections.emptyList());
        HashSet<Integer> sysPris = new HashSet<Integer>();
        sysPris.add(PrivilegeType.MANAGE_DATABASE.ordinal());
        sysPris.add(PrivilegeType.MANAGE_ROLE.ordinal());
        plan.setPermissions(sysPris);
        plan.setGrantOpt(true);
        authorInfo.authorNonQuery(plan);
        plan.getPermissions().clear();
        plan.getPermissions().add(PrivilegeType.MANAGE_ROLE.ordinal());
        answerSet.add(plan.hashCode());
        plan.getPermissions().clear();
        plan.getPermissions().add(PrivilegeType.MANAGE_DATABASE.ordinal());
        answerSet.add(plan.hashCode());
        Assert.assertTrue((boolean)authorInfo.processTakeSnapshot(snapshotDir));
        File roleProfile = SystemFileFactory.INSTANCE.getFile(snapshotDir + File.separator + ROLE_SNAPSHOT_FILE_NAME + File.separator + roleName + ".profile");
        CNPhysicalPlanGenerator planGenerator = new CNPhysicalPlanGenerator(roleProfile.toPath(), CNSnapshotFileType.ROLE);
        int count = 0;
        for (ConfigPhysicalPlan authPlan : planGenerator) {
            Assert.assertTrue((boolean)answerSet.contains(authPlan.hashCode()));
            ++count;
        }
        Assert.assertEquals((long)5L, (long)count);
    }

    @Test
    public void userGeneratorTest() throws Exception {
        String userName = "test1";
        HashSet<Integer> answerSet = new HashSet<Integer>();
        CNPhysicalPlanGeneratorTest.setupAuthorInfo();
        AuthorPlan plan = new AuthorPlan(ConfigPhysicalPlanType.CreateUser);
        plan.setPassword("password");
        plan.setUserName("test1");
        plan.setPermissions(new HashSet());
        plan.setNodeNameList(new ArrayList());
        authorInfo.authorNonQuery(plan);
        plan.setAuthorType(ConfigPhysicalPlanType.CreateUserWithRawPassword);
        plan.setPassword(AuthUtils.encryptPassword((String)"password"));
        answerSet.add(plan.hashCode());
        plan = new AuthorPlan(ConfigPhysicalPlanType.CreateRole);
        plan.setRoleName("role1");
        plan.setPermissions(new HashSet());
        plan.setNodeNameList(new ArrayList());
        authorInfo.authorNonQuery(plan);
        plan = new AuthorPlan(ConfigPhysicalPlanType.GrantUser);
        plan.setUserName("test1");
        plan.setRoleName("");
        plan.setNodeNameList(Collections.singletonList(new PartialPath("root.db1.t2")));
        HashSet<Integer> priSet = new HashSet<Integer>();
        priSet.add(PrivilegeType.WRITE_SCHEMA.ordinal());
        priSet.add(PrivilegeType.READ_DATA.ordinal());
        plan.setPermissions(priSet);
        plan.setGrantOpt(true);
        authorInfo.authorNonQuery(plan);
        plan.getPermissions().clear();
        plan.getPermissions().add(PrivilegeType.WRITE_SCHEMA.ordinal());
        answerSet.add(plan.hashCode());
        plan.getPermissions().clear();
        plan.getPermissions().add(PrivilegeType.READ_DATA.ordinal());
        answerSet.add(plan.hashCode());
        plan = new AuthorPlan(ConfigPhysicalPlanType.GrantUser);
        plan.setUserName("test1");
        plan.setRoleName("");
        plan.setNodeNameList(Collections.emptyList());
        plan.setPermissions(Collections.singleton(PrivilegeType.MANAGE_DATABASE.ordinal()));
        plan.setGrantOpt(false);
        authorInfo.authorNonQuery(plan);
        answerSet.add(plan.hashCode());
        plan = new AuthorPlan(ConfigPhysicalPlanType.GrantRoleToUser);
        plan.setRoleName("role1");
        plan.setUserName("");
        plan.setUserName("test1");
        plan.setPermissions(new HashSet());
        plan.setNodeNameList(new ArrayList());
        authorInfo.authorNonQuery(plan);
        answerSet.add(plan.hashCode());
        Assert.assertTrue((boolean)authorInfo.processTakeSnapshot(snapshotDir));
        File userProfile = SystemFileFactory.INSTANCE.getFile(snapshotDir + File.separator + USER_SNAPSHOT_FILE_NAME + File.separator + "test1" + ".profile");
        CNPhysicalPlanGenerator planGenerator = new CNPhysicalPlanGenerator(userProfile.toPath(), CNSnapshotFileType.USER);
        int count = 0;
        for (ConfigPhysicalPlan authPlan : planGenerator) {
            Assert.assertTrue((boolean)answerSet.contains(authPlan.hashCode()));
            ++count;
        }
        Assert.assertEquals((long)4L, (long)count);
        File roleListProfile = SystemFileFactory.INSTANCE.getFile(snapshotDir + File.separator + USER_SNAPSHOT_FILE_NAME + File.separator + "test1" + "_role.profile");
        planGenerator = new CNPhysicalPlanGenerator(roleListProfile.toPath(), CNSnapshotFileType.USER_ROLE);
        count = 0;
        for (ConfigPhysicalPlan authPlan : planGenerator) {
            Assert.assertTrue((boolean)answerSet.contains(authPlan.hashCode()));
            ++count;
        }
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void databaseWithoutTemplateGeneratorTest() throws Exception {
        CNPhysicalPlanGeneratorTest.setupClusterSchemaInfo();
        CNPhysicalPlanGeneratorTest.setupTTLInfo();
        HashSet<Integer> answerSet = new HashSet<Integer>();
        TreeSet<String> storageGroupPathList = new TreeSet<String>();
        storageGroupPathList.add("root.sg");
        storageGroupPathList.add("root.ln");
        storageGroupPathList.add("root.a.sg");
        storageGroupPathList.add("root.a.b.sg");
        storageGroupPathList.add("root.a.a.a.b.sg");
        int i = 0;
        for (String path : storageGroupPathList) {
            TDatabaseSchema tDatabaseSchema = new TDatabaseSchema();
            tDatabaseSchema.setName(path);
            tDatabaseSchema.setTTL((long)(i + 1));
            tDatabaseSchema.setDataReplicationFactor(i);
            tDatabaseSchema.setSchemaReplicationFactor(i);
            tDatabaseSchema.setTimePartitionInterval((long)i);
            DatabaseSchemaPlan databaseSchemaPlan = new DatabaseSchemaPlan(ConfigPhysicalPlanType.CreateDatabase, tDatabaseSchema);
            clusterSchemaInfo.createDatabase(databaseSchemaPlan);
            answerSet.add(databaseSchemaPlan.hashCode());
            SetTTLPlan setTTLPlan = new SetTTLPlan(path.split("\\."), tDatabaseSchema.getTTL());
            ttlInfo.setTTL(setTTLPlan);
            answerSet.add(setTTLPlan.hashCode());
            ++i;
        }
        boolean success = clusterSchemaInfo.processTakeSnapshot(snapshotDir) && ttlInfo.processTakeSnapshot(snapshotDir);
        Assert.assertTrue((boolean)success);
        File schemaInfo = SystemFileFactory.INSTANCE.getFile(snapshotDir + File.separator + SCHEMA_INFO_FILE_NAME);
        File templateInfo = SystemFileFactory.INSTANCE.getFile(snapshotDir + File.separator + TEMPLATE_INFO_FILE_NAME);
        File ttlInfo = SystemFileFactory.INSTANCE.getFile(snapshotDir + File.separator + "ttl_info.bin");
        CNPhysicalPlanGenerator planGenerator = new CNPhysicalPlanGenerator(schemaInfo.toPath(), templateInfo.toPath());
        int count = 0;
        for (ConfigPhysicalPlan plan : planGenerator) {
            if (plan.getType() != ConfigPhysicalPlanType.CreateDatabase) continue;
            Assert.assertTrue((boolean)answerSet.contains(plan.hashCode()));
            ++count;
        }
        planGenerator.checkException();
        Assert.assertEquals((long)5L, (long)count);
        planGenerator = new CNPhysicalPlanGenerator(ttlInfo.toPath(), CNSnapshotFileType.TTL);
        for (ConfigPhysicalPlan plan : planGenerator) {
            if (plan.getType() != ConfigPhysicalPlanType.SetTTL) continue;
            if (!new PartialPath(((SetTTLPlan)plan).getPathPattern()).getFullPath().equals("root.**")) {
                Assert.assertTrue((boolean)answerSet.contains(plan.hashCode()));
            }
            Assert.assertEquals((long)CNPhysicalPlanGeneratorTest.ttlInfo.setTTL((SetTTLPlan)((SetTTLPlan)plan)).code, (long)TSStatusCode.SUCCESS_STATUS.getStatusCode());
            ++count;
        }
        planGenerator.checkException();
        Assert.assertEquals((long)11L, (long)count);
    }

    @Test
    public void templateGeneratorTest() throws Exception {
        CNPhysicalPlanGeneratorTest.setupClusterSchemaInfo();
        Template t1 = new Template("t1", Arrays.asList("s1", "s2"), Arrays.asList(TSDataType.INT32, TSDataType.BOOLEAN), Arrays.asList(TSEncoding.GORILLA, TSEncoding.PLAIN), Arrays.asList(CompressionType.GZIP, CompressionType.SNAPPY));
        Template t2 = new Template("t2", Arrays.asList("s1", "s2", "s3"), Arrays.asList(TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT), Arrays.asList(TSEncoding.GORILLA, TSEncoding.PLAIN, TSEncoding.DIFF), Arrays.asList(CompressionType.GZIP, CompressionType.SNAPPY, CompressionType.LZ4));
        HashMap<String, CreateSchemaTemplatePlan> answerPlan = new HashMap<String, CreateSchemaTemplatePlan>();
        CreateSchemaTemplatePlan plan1 = new CreateSchemaTemplatePlan(t1.serialize().array());
        clusterSchemaInfo.createSchemaTemplate(plan1);
        answerPlan.put(t1.getName(), plan1);
        CreateSchemaTemplatePlan plan2 = new CreateSchemaTemplatePlan(t2.serialize().array());
        clusterSchemaInfo.createSchemaTemplate(plan2);
        answerPlan.put(t2.getName(), plan2);
        boolean success = clusterSchemaInfo.processTakeSnapshot(snapshotDir);
        Assert.assertTrue((boolean)success);
        File schemaInfo = SystemFileFactory.INSTANCE.getFile(snapshotDir + File.separator + SCHEMA_INFO_FILE_NAME);
        File templateInfo = SystemFileFactory.INSTANCE.getFile(snapshotDir + File.separator + TEMPLATE_INFO_FILE_NAME);
        CNPhysicalPlanGenerator planGenerator = new CNPhysicalPlanGenerator(schemaInfo.toPath(), templateInfo.toPath());
        int count = 0;
        for (ConfigPhysicalPlan plan : planGenerator) {
            CreateSchemaTemplatePlan templatePlan = (CreateSchemaTemplatePlan)plan;
            Assert.assertEquals(answerPlan.get(templatePlan.getTemplate().getName()), (Object)templatePlan);
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
    }

    @Test
    public void templateAndDatabaseCompletedTest() throws Exception {
        CNPhysicalPlanGeneratorTest.setupClusterSchemaInfo();
        CNPhysicalPlanGeneratorTest.setupTTLInfo();
        HashSet<Integer> answerSet = new HashSet<Integer>();
        TreeSet<String> storageGroupPathList = new TreeSet<String>();
        storageGroupPathList.add("root.sg");
        storageGroupPathList.add("root.a.sg");
        storageGroupPathList.add("root.a.b.sg");
        storageGroupPathList.add("root.a.a.a.b.sg");
        int i = 0;
        for (String path : storageGroupPathList) {
            TDatabaseSchema tDatabaseSchema = new TDatabaseSchema();
            tDatabaseSchema.setName(path);
            tDatabaseSchema.setTTL((long)(i + 1));
            tDatabaseSchema.setDataReplicationFactor(i);
            tDatabaseSchema.setSchemaReplicationFactor(i);
            tDatabaseSchema.setTimePartitionInterval((long)i);
            DatabaseSchemaPlan databaseSchemaPlan = new DatabaseSchemaPlan(ConfigPhysicalPlanType.CreateDatabase, tDatabaseSchema);
            clusterSchemaInfo.createDatabase(databaseSchemaPlan);
            answerSet.add(databaseSchemaPlan.hashCode());
            SetTTLPlan plan = new SetTTLPlan(Arrays.asList(path.split("\\.")), tDatabaseSchema.getTTL());
            ttlInfo.setTTL(plan);
            answerSet.add(plan.hashCode());
            ++i;
        }
        Template t1 = new Template("t1", Arrays.asList("s1", "s2"), Arrays.asList(TSDataType.INT32, TSDataType.BOOLEAN), Arrays.asList(TSEncoding.GORILLA, TSEncoding.PLAIN), Arrays.asList(CompressionType.GZIP, CompressionType.SNAPPY));
        Template t2 = new Template("t2", Arrays.asList("s1", "s2", "s3"), Arrays.asList(TSDataType.INT32, TSDataType.BOOLEAN, TSDataType.TEXT), Arrays.asList(TSEncoding.GORILLA, TSEncoding.PLAIN, TSEncoding.DIFF), Arrays.asList(CompressionType.GZIP, CompressionType.SNAPPY, CompressionType.LZ4));
        CreateSchemaTemplatePlan plan1 = new CreateSchemaTemplatePlan(t1.serialize().array());
        clusterSchemaInfo.createSchemaTemplate(plan1);
        answerSet.add(plan1.hashCode());
        CreateSchemaTemplatePlan plan2 = new CreateSchemaTemplatePlan(t2.serialize().array());
        clusterSchemaInfo.createSchemaTemplate(plan2);
        answerSet.add(plan2.hashCode());
        PreSetSchemaTemplatePlan preSetSchemaTemplatePlan1 = new PreSetSchemaTemplatePlan("t1", "root.sg");
        PreSetSchemaTemplatePlan preSetSchemaTemplatePlan2 = new PreSetSchemaTemplatePlan("t2", "root.a.sg.t1");
        CommitSetSchemaTemplatePlan setSchemaTemplatePlan1 = new CommitSetSchemaTemplatePlan("t1", "root.sg");
        CommitSetSchemaTemplatePlan setSchemaTemplatePlan2 = new CommitSetSchemaTemplatePlan("t2", "root.a.sg.t1");
        clusterSchemaInfo.preSetSchemaTemplate(preSetSchemaTemplatePlan1);
        clusterSchemaInfo.preSetSchemaTemplate(preSetSchemaTemplatePlan2);
        clusterSchemaInfo.commitSetSchemaTemplate(setSchemaTemplatePlan1);
        clusterSchemaInfo.commitSetSchemaTemplate(setSchemaTemplatePlan2);
        answerSet.add(setSchemaTemplatePlan1.hashCode());
        answerSet.add(setSchemaTemplatePlan1.hashCode());
        boolean success = clusterSchemaInfo.processTakeSnapshot(snapshotDir) && ttlInfo.processTakeSnapshot(snapshotDir);
        Assert.assertTrue((boolean)success);
        File schemaInfo = SystemFileFactory.INSTANCE.getFile(snapshotDir + File.separator + SCHEMA_INFO_FILE_NAME);
        File templateInfo = SystemFileFactory.INSTANCE.getFile(snapshotDir + File.separator + TEMPLATE_INFO_FILE_NAME);
        File ttlInfo = SystemFileFactory.INSTANCE.getFile(snapshotDir + File.separator + "ttl_info.bin");
        CNPhysicalPlanGenerator planGenerator = new CNPhysicalPlanGenerator(schemaInfo.toPath(), templateInfo.toPath());
        int count = 0;
        for (ConfigPhysicalPlan plan : planGenerator) {
            if (plan.getType() == ConfigPhysicalPlanType.CreateDatabase) {
                Assert.assertTrue((boolean)answerSet.contains(plan.hashCode()));
            } else if (plan.getType() == ConfigPhysicalPlanType.CreateSchemaTemplate) {
                Assert.assertTrue((boolean)answerSet.contains(plan.hashCode()));
            } else if (plan.getType() == ConfigPhysicalPlanType.PreSetSchemaTemplate) {
                Assert.assertTrue((boolean)answerSet.contains(plan.hashCode()));
            } else if (plan.getType() == ConfigPhysicalPlanType.CommitSetSchemaTemplate) {
                CommitSetSchemaTemplatePlan commitSetSchemaTemplatePlan = (CommitSetSchemaTemplatePlan)plan;
                if (commitSetSchemaTemplatePlan.getName().equals("t1")) {
                    Assert.assertEquals((Object)commitSetSchemaTemplatePlan, (Object)setSchemaTemplatePlan1);
                } else {
                    Assert.assertEquals((Object)commitSetSchemaTemplatePlan, (Object)setSchemaTemplatePlan1);
                }
            }
            ++count;
        }
        Assert.assertEquals((long)8L, (long)count);
        planGenerator = new CNPhysicalPlanGenerator(ttlInfo.toPath(), CNSnapshotFileType.TTL);
        for (ConfigPhysicalPlan plan : planGenerator) {
            if (plan.getType() != ConfigPhysicalPlanType.SetTTL) continue;
            if (!new PartialPath(((SetTTLPlan)plan).getPathPattern()).getFullPath().equals("root.**")) {
                Assert.assertTrue((boolean)answerSet.contains(plan.hashCode()));
            }
            Assert.assertEquals((long)CNPhysicalPlanGeneratorTest.ttlInfo.setTTL((SetTTLPlan)((SetTTLPlan)plan)).code, (long)TSStatusCode.SUCCESS_STATUS.getStatusCode());
            ++count;
        }
        planGenerator.checkException();
        Assert.assertEquals((long)13L, (long)count);
    }

    static {
        snapshotDir = new File(TestConstant.BASE_OUTPUT_PATH, "authorInfo-snapshot");
        USER_SNAPSHOT_FILE_NAME = "system" + File.separator + "users";
        ROLE_SNAPSHOT_FILE_NAME = "system" + File.separator + "roles";
    }
}

