/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.authorizer.BasicAuthorizer;
import org.apache.iotdb.commons.auth.entity.PriPrivilegeType;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.AuthUtils;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.read.auth.AuthorReadPlan;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.response.auth.PermissionInfoResp;
import org.apache.iotdb.confignode.persistence.AuthorInfo;
import org.apache.iotdb.confignode.rpc.thrift.TPermissionInfoResp;
import org.apache.iotdb.db.utils.constant.TestConstant;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AuthorInfoTest {
    private static AuthorInfo authorInfo;
    private static final File snapshotDir;
    private static final File userFolder;
    private static final File roleFolder;

    @BeforeClass
    public static void setup() {
        authorInfo = new AuthorInfo();
        if (!snapshotDir.exists()) {
            snapshotDir.mkdirs();
        }
        if (!userFolder.exists()) {
            userFolder.mkdirs();
        }
        if (!roleFolder.exists()) {
            roleFolder.mkdirs();
        }
    }

    @AfterClass
    public static void cleanup() throws IOException, AuthException {
        authorInfo.clear();
        if (snapshotDir.exists()) {
            FileUtils.deleteDirectory((File)snapshotDir);
        }
        if (userFolder.exists()) {
            FileUtils.deleteDirectory((File)userFolder);
        }
        if (roleFolder.exists()) {
            FileUtils.deleteDirectory((File)roleFolder);
        }
    }

    @Test
    public void permissionTest() throws TException, AuthException, IllegalPathException {
        ArrayList<String> userList = new ArrayList<String>();
        userList.add("root");
        userList.add("user0");
        userList.add("user1");
        ArrayList<String> roleList = new ArrayList<String>();
        roleList.add("role0");
        roleList.add("role1");
        HashSet<Integer> privilegeList = new HashSet<Integer>();
        privilegeList.add(PrivilegeType.READ_DATA.ordinal());
        HashSet<Integer> sysPriList = new HashSet<Integer>();
        sysPriList.add(PrivilegeType.MANAGE_ROLE.ordinal());
        HashSet<Integer> revokePrivilege = new HashSet<Integer>();
        revokePrivilege.add(PrivilegeType.READ_DATA.ordinal());
        ArrayList<String> privilege = new ArrayList<String>();
        privilege.add("root.** : MANAGE_USER");
        ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
        paths.add(new PartialPath("root.ln"));
        this.cleanUserAndRole();
        AuthorPlan authorPlan = new AuthorPlan(ConfigPhysicalPlanType.CreateUser, "user0", "", "passwd", "", new HashSet(), false, new ArrayList());
        TSStatus status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertNull((Object)status.getMessage());
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        authorPlan.setUserName("user1");
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        status = authorInfo.checkUserPrivileges("user0", paths, PrivilegeType.MANAGE_USER.ordinal()).getStatus();
        Assert.assertEquals((long)TSStatusCode.NO_PERMISSION.getStatusCode(), (long)status.getCode());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.DropUser, "user1", "", "", "", new HashSet(), false, new ArrayList());
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        AuthorReadPlan authorReadPlan = new AuthorReadPlan(ConfigPhysicalPlanType.ListUser, "", "", "", "", new HashSet(), false, new ArrayList());
        PermissionInfoResp permissionInfoResp = authorInfo.executeListUsers(authorReadPlan);
        status = permissionInfoResp.getStatus();
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        userList.remove("user1");
        Assert.assertEquals(userList, (Object)permissionInfoResp.getMemberList());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.CreateRole, "", "role0", "", "", new HashSet(), false, new ArrayList());
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        authorPlan.setRoleName("role1");
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.DropRole, "", "role1", "", "", new HashSet(), false, new ArrayList());
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        authorReadPlan = new AuthorReadPlan(ConfigPhysicalPlanType.ListRole, "", "", "", "", new HashSet(), false, new ArrayList());
        permissionInfoResp = authorInfo.executeListRoles(authorReadPlan);
        status = permissionInfoResp.getStatus();
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        roleList.remove("role1");
        Assert.assertEquals(roleList, (Object)permissionInfoResp.getMemberList());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.UpdateUser, "user0", "", "", "newpwd", new HashSet(), false, new ArrayList());
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        ArrayList<PartialPath> nodeNameList = new ArrayList<PartialPath>();
        nodeNameList.add(new PartialPath("root.ln.**"));
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.GrantUser, "user0", "", "", "", privilegeList, false, nodeNameList);
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        Assert.assertEquals((long)authorInfo.checkUserPrivileges("user0", nodeNameList, PrivilegeType.READ_DATA.ordinal()).getStatus().getCode(), (long)TSStatusCode.SUCCESS_STATUS.getStatusCode());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.GrantUser, "user0", "", "", "", sysPriList, false, null);
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        Assert.assertEquals((long)authorInfo.checkUserPrivileges("user0", new ArrayList(), PrivilegeType.MANAGE_ROLE.ordinal()).getStatus().getCode(), (long)TSStatusCode.SUCCESS_STATUS.getStatusCode());
        status = authorInfo.checkUserPrivileges("user0", new ArrayList(), PrivilegeType.MANAGE_ROLE.ordinal()).getStatus();
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.GrantRole, "", "role0", "", "", privilegeList, false, nodeNameList);
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.GrantRoleToUser, "user0", "role0", "", "", new HashSet(), false, new ArrayList());
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.RevokeUser, "user0", "", "", "", revokePrivilege, false, nodeNameList);
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.RevokeRole, "", "role0", "", "", revokePrivilege, false, nodeNameList);
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        authorReadPlan = new AuthorReadPlan(ConfigPhysicalPlanType.ListUserPrivilege, "user0", "", "", "", new HashSet(), false, new ArrayList());
        permissionInfoResp = authorInfo.executeListUserPrivileges(authorReadPlan);
        status = permissionInfoResp.getStatus();
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        Assert.assertEquals((Object)authorInfo.getUserPermissionInfo("user0"), (Object)permissionInfoResp.getPermissionInfoResp());
        authorReadPlan = new AuthorReadPlan(ConfigPhysicalPlanType.ListRolePrivilege, "", "role0", "", "", new HashSet(), false, new ArrayList());
        permissionInfoResp = authorInfo.executeListRolePrivileges(authorReadPlan);
        status = permissionInfoResp.getStatus();
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        authorReadPlan = new AuthorReadPlan(ConfigPhysicalPlanType.ListRole, "user0", "", "", "", new HashSet(), false, new ArrayList());
        permissionInfoResp = authorInfo.executeListRoles(authorReadPlan);
        status = permissionInfoResp.getStatus();
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        roleList.remove("role1");
        Assert.assertEquals(roleList, (Object)permissionInfoResp.getMemberList());
        authorReadPlan = new AuthorReadPlan(ConfigPhysicalPlanType.ListUser, "", "role0", "", "", new HashSet(), false, new ArrayList());
        permissionInfoResp = authorInfo.executeListUsers(authorReadPlan);
        status = permissionInfoResp.getStatus();
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        userList.remove("user1");
        userList.remove("root");
        Assert.assertEquals(userList, (Object)permissionInfoResp.getMemberList());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.RevokeRoleFromUser, "user0", "role0", "", "", new HashSet(), false, new ArrayList());
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
    }

    private void cleanUserAndRole() throws TException, AuthException {
        AuthorPlan authorPlan;
        AuthorReadPlan authorReadPlan = new AuthorReadPlan(ConfigPhysicalPlanType.ListUser, "", "", "", "", new HashSet(), false, new ArrayList());
        PermissionInfoResp permissionInfoResp = authorInfo.executeListUsers(authorReadPlan);
        TSStatus status = permissionInfoResp.getStatus();
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        List allUsers = permissionInfoResp.getMemberList();
        for (String user : allUsers) {
            if (user.equals("root")) continue;
            authorPlan = new AuthorPlan(ConfigPhysicalPlanType.DropUser, user, "", "", "", new HashSet(), false, new ArrayList());
            status = authorInfo.authorNonQuery(authorPlan);
            Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        }
        authorReadPlan = new AuthorReadPlan(ConfigPhysicalPlanType.ListRole, "", "", "", "", new HashSet(), false, new ArrayList());
        permissionInfoResp = authorInfo.executeListRoles(authorReadPlan);
        status = permissionInfoResp.getStatus();
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        List roleList = permissionInfoResp.getMemberList();
        for (String roleN : roleList) {
            authorPlan = new AuthorPlan(ConfigPhysicalPlanType.DropRole, "", roleN, "", "", new HashSet(), false, new ArrayList());
            status = authorInfo.authorNonQuery(authorPlan);
            Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        }
    }

    @Test
    public void takeSnapshot() throws TException, IOException, AuthException {
        this.cleanUserAndRole();
        AuthorPlan createRoleReq = new AuthorPlan(ConfigPhysicalPlanType.CreateRole);
        createRoleReq.setRoleName("testRole");
        TSStatus status = authorInfo.authorNonQuery(createRoleReq);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        AuthorPlan createUserReq = new AuthorPlan(ConfigPhysicalPlanType.CreateUser);
        createUserReq.setUserName("testUser");
        createUserReq.setPassword("testPassword");
        status = authorInfo.authorNonQuery(createUserReq);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        AuthorReadPlan listUserPlan = new AuthorReadPlan(ConfigPhysicalPlanType.ListUser, "", "", "", "", new HashSet(), false, new ArrayList());
        AuthorReadPlan listRolePlan = new AuthorReadPlan(ConfigPhysicalPlanType.ListRole, "", "", "", "", new HashSet(), false, new ArrayList());
        Assert.assertEquals((long)1L, (long)authorInfo.executeListRoles(listRolePlan).getMemberList().size());
        Assert.assertEquals((long)2L, (long)authorInfo.executeListUsers(listUserPlan).getMemberList().size());
        Assert.assertTrue((boolean)authorInfo.processTakeSnapshot(snapshotDir));
        authorInfo.clear();
        authorInfo.processLoadSnapshot(snapshotDir);
        Assert.assertEquals((long)1L, (long)authorInfo.executeListRoles(listRolePlan).getMemberList().size());
        Assert.assertEquals((long)2L, (long)authorInfo.executeListUsers(listUserPlan).getMemberList().size());
    }

    @Test
    public void testMultPathsPermission() throws TException, AuthException, IllegalPathException {
        HashSet<Integer> privilegeList = new HashSet<Integer>();
        privilegeList.add(PrivilegeType.WRITE_DATA.ordinal());
        privilegeList.add(PrivilegeType.READ_DATA.ordinal());
        ArrayList<String> userPrivilege = new ArrayList<String>();
        userPrivilege.add("root.sg.** : READ_DATA WRITE_DATA");
        userPrivilege.add("root.ln.** : READ_DATA WRITE_DATA");
        Collections.sort(userPrivilege);
        ArrayList<String> rolePrivilege = new ArrayList<String>();
        rolePrivilege.add("root.abc.** : READ_DATA WRITE_DATA");
        rolePrivilege.add("root.role_1.** : READ_DATA WRITE_DATA");
        Collections.sort(rolePrivilege);
        ArrayList<String> allPrivilege = new ArrayList<String>();
        allPrivilege.addAll(userPrivilege);
        allPrivilege.addAll(rolePrivilege);
        Collections.sort(allPrivilege);
        ArrayList<PartialPath> userPaths = new ArrayList<PartialPath>();
        userPaths.add(new PartialPath("root.ln.**"));
        userPaths.add(new PartialPath("root.sg.**"));
        ArrayList<PartialPath> rolePaths = new ArrayList<PartialPath>();
        rolePaths.add(new PartialPath("root.role_1.**"));
        rolePaths.add(new PartialPath("root.abc.**"));
        this.cleanUserAndRole();
        AuthorPlan authorPlan = new AuthorPlan(ConfigPhysicalPlanType.CreateUser, "user0", "", "passwd", "", new HashSet(), false, new ArrayList());
        TSStatus status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertNull((Object)status.getMessage());
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.CreateRole, "", "role0", "", "", new HashSet(), false, new ArrayList());
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.GrantUser, "user0", "", "", "", privilegeList, false, userPaths);
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        status = authorInfo.checkUserPrivileges("user0", userPaths, PrivilegeType.WRITE_DATA.ordinal()).getStatus();
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.GrantRole, "", "role0", "", "", privilegeList, false, rolePaths);
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.GrantRoleToUser, "user0", "role0", "", "", new HashSet(), false, new ArrayList());
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        AuthorReadPlan authorReadPlan = new AuthorReadPlan(ConfigPhysicalPlanType.ListUserPrivilege, "user0", "", "", "", new HashSet(), false, new ArrayList());
        PermissionInfoResp permissionInfoResp = authorInfo.executeListUserPrivileges(authorReadPlan);
        status = permissionInfoResp.getStatus();
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        authorReadPlan = new AuthorReadPlan(ConfigPhysicalPlanType.ListRolePrivilege, "", "role0", "", "", new HashSet(), false, new ArrayList());
        permissionInfoResp = authorInfo.executeListRolePrivileges(authorReadPlan);
        status = permissionInfoResp.getStatus();
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
    }

    @Test
    public void testDepAuthorPlan() throws TException, AuthException, IllegalPathException {
        this.cleanUserAndRole();
        AuthorPlan authorPlan = new AuthorPlan(ConfigPhysicalPlanType.CreateUserDep, "user1", "", "password1", "", new HashSet(), false, new ArrayList());
        TSStatus status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.CreateUserDep, "user1234567user1234567user1234567user1234567", "", "password1", "", new HashSet(), false, new ArrayList());
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.CreateUserDep, "user1234567user1234567user1234567user1234567user1234567user1234567user1234567user1234567", "", "password1", "", new HashSet(), false, new ArrayList());
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.ILLEGAL_PARAMETER.getStatusCode(), (long)status.getCode());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.CreateUserDep, "user1*&%", "", "password1", "", new HashSet(), false, new ArrayList());
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.ILLEGAL_PARAMETER.getStatusCode(), (long)status.getCode());
        Assert.assertEquals((long)3L, (long)authorInfo.executeListUsers(new AuthorReadPlan(ConfigPhysicalPlanType.ListUser, "", "", "", "", new HashSet(), false, new ArrayList())).getMemberList().size());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.DropUserDep, "user1234567user1234567user1234567user1234567", "", "", "", new HashSet(), false, new ArrayList());
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        Assert.assertEquals((long)2L, (long)authorInfo.executeListUsers(new AuthorReadPlan(ConfigPhysicalPlanType.ListUserDep, "", "", "", "", new HashSet(), false, new ArrayList())).getMemberList().size());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.UpdateUserDep, "user1", "", "password*&S", "", new HashSet(), false, new ArrayList());
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.ILLEGAL_PARAMETER.getStatusCode(), (long)status.getCode());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.CreateRoleDep, "", "role1", "", "", new HashSet(), false, new ArrayList());
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.CreateRoleDep, "", "role1234567role1234567role1234567role1234567", "", "", new HashSet(), false, new ArrayList());
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.CreateRoleDep, "", "role1234567role1%%234567role1234567role1234567", "", "", new HashSet(), false, new ArrayList());
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.ILLEGAL_PARAMETER.getStatusCode(), (long)status.getCode());
        authorPlan = new AuthorPlan(ConfigPhysicalPlanType.DropRoleDep, "", "role1234567role1234567role1234567role1234567", "", "", new HashSet(), false, new ArrayList());
        status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        Assert.assertEquals((long)1L, (long)authorInfo.executeListRoles(new AuthorReadPlan(ConfigPhysicalPlanType.ListRoleDep, "", "", "", "", new HashSet(), false, new ArrayList())).getMemberList().size());
        for (PriPrivilegeType item : PriPrivilegeType.values()) {
            if (!item.isAccept()) {
                authorPlan = new AuthorPlan(ConfigPhysicalPlanType.GrantUserDep, "user1", "", "", "", Collections.singleton(item.ordinal()), false, Collections.singletonList(new PartialPath("root.**")));
                status = authorInfo.authorNonQuery(authorPlan);
                Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
                Assert.assertEquals((long)0L, (long)BasicAuthorizer.getInstance().getUser("user1").getPathPrivilegeList().size());
                Assert.assertEquals((long)0L, (long)BasicAuthorizer.getInstance().getUser("user1").getSysPrivilege().size());
                authorPlan = new AuthorPlan(ConfigPhysicalPlanType.GrantRoleDep, "", "role1", "", "", Collections.singleton(item.ordinal()), false, Collections.singletonList(new PartialPath("root.**")));
                status = authorInfo.authorNonQuery(authorPlan);
                Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
                Assert.assertEquals((long)0L, (long)BasicAuthorizer.getInstance().getRole("role1").getPathPrivilegeList().size());
                Assert.assertEquals((long)0L, (long)BasicAuthorizer.getInstance().getRole("role1").getSysPrivilege().size());
                authorPlan = new AuthorPlan(ConfigPhysicalPlanType.RevokeUserDep, "user1", "", "", "", Collections.singleton(item.ordinal()), false, Collections.singletonList(new PartialPath("root.**")));
                status = authorInfo.authorNonQuery(authorPlan);
                Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
                Assert.assertEquals((long)0L, (long)BasicAuthorizer.getInstance().getUser("user1").getPathPrivilegeList().size());
                Assert.assertEquals((long)0L, (long)BasicAuthorizer.getInstance().getUser("user1").getSysPrivilege().size());
                authorPlan = new AuthorPlan(ConfigPhysicalPlanType.RevokeRoleDep, "", "role1", "", "", Collections.singleton(item.ordinal()), false, Collections.singletonList(new PartialPath("root.**")));
                status = authorInfo.authorNonQuery(authorPlan);
                Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
                Assert.assertEquals((long)0L, (long)BasicAuthorizer.getInstance().getRole("role1").getPathPrivilegeList().size());
                Assert.assertEquals((long)0L, (long)BasicAuthorizer.getInstance().getRole("role1").getSysPrivilege().size());
                continue;
            }
            if (item == PriPrivilegeType.ALL) continue;
            if (item.isPrePathRelevant()) {
                authorPlan = new AuthorPlan(ConfigPhysicalPlanType.GrantUserDep, "user1", "", "", "", Collections.singleton(item.ordinal()), false, Collections.singletonList(new PartialPath("root.t1.*.t2")));
                status = authorInfo.authorNonQuery(authorPlan);
                Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
                Assert.assertEquals((long)1L, (long)BasicAuthorizer.getInstance().getUser("user1").getPathPrivileges(new PartialPath("root.t1.*.t2")).size());
                authorInfo.checkUserPathPrivilege();
                PartialPath path1 = AuthUtils.convertPatternPath((PartialPath)new PartialPath("root.t1.*.t2"));
                for (PrivilegeType pri : item.getSubPri()) {
                    if (pri.isPathRelevant()) {
                        Assert.assertTrue((boolean)BasicAuthorizer.getInstance().getUser("user1").checkPathPrivilege(path1, pri.ordinal()));
                        BasicAuthorizer.getInstance().getUser("user1").removePathPrivilege(path1, pri.ordinal());
                        continue;
                    }
                    Assert.assertTrue((boolean)BasicAuthorizer.getInstance().getUser("user1").checkSysPrivilege(pri.ordinal()));
                    BasicAuthorizer.getInstance().getUser("user1").removeSysPrivilege(pri.ordinal());
                }
                continue;
            }
            authorPlan = new AuthorPlan(ConfigPhysicalPlanType.GrantUserDep, "user1", "", "", "", Collections.singleton(item.ordinal()), false, Collections.singletonList(new PartialPath("root.**")));
            status = authorInfo.authorNonQuery(authorPlan);
            Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
            authorInfo.checkUserPathPrivilege();
            Assert.assertTrue((boolean)BasicAuthorizer.getInstance().getUser("user1").getSysPrivilege().containsAll(item.getSubSysPriOrd()));
            for (PrivilegeType pri : item.getSubPri()) {
                authorPlan = new AuthorPlan(ConfigPhysicalPlanType.RevokeUser, "user1", "", "", "", Collections.singleton(pri.ordinal()), false, Collections.emptyList());
                status = authorInfo.authorNonQuery(authorPlan);
                Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
                Assert.assertEquals((long)0L, (long)BasicAuthorizer.getInstance().getUser("user1").getSysPrivilege().size());
            }
        }
    }

    @Test
    public void createUserWithRawPassword() throws AuthException {
        AuthorPlan authorPlan = new AuthorPlan(ConfigPhysicalPlanType.CreateUserWithRawPassword, "testuser", "", AuthUtils.encryptPassword((String)"password"), "", new HashSet(), false, new ArrayList());
        TSStatus status = authorInfo.authorNonQuery(authorPlan);
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)status.getCode());
        TPermissionInfoResp result = authorInfo.login("testuser", "password");
        Assert.assertEquals((long)TSStatusCode.SUCCESS_STATUS.getStatusCode(), (long)result.getStatus().getCode());
    }

    static {
        snapshotDir = new File(TestConstant.BASE_OUTPUT_PATH, "authorInfo-snapshot");
        userFolder = new File(CommonDescriptor.getInstance().getConfig().getUserFolder());
        roleFolder = new File(CommonDescriptor.getInstance().getConfig().getRoleFolder());
    }
}

