/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.extractor;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.pipe.datastructure.pattern.IoTDBPipePattern;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.confignode.consensus.request.write.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeactivateTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteLogicalViewPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteTimeSeriesPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CommitSetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.ExtendSchemaTemplatePlan;
import org.apache.iotdb.confignode.manager.pipe.extractor.IoTDBConfigRegionExtractor;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.db.schemaengine.template.alter.TemplateExtendInfo;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.enums.CompressionType;
import org.apache.tsfile.file.metadata.enums.TSEncoding;
import org.junit.Assert;
import org.junit.Test;

public class PipeConfigPhysicalPlanPatternParseVisitorTest {
    private final IoTDBPipePattern prefixPathPattern = new IoTDBPipePattern("root.db.device.**");
    private final IoTDBPipePattern fullPathPattern = new IoTDBPipePattern("root.db.device.s1");

    @Test
    public void testCreateDatabase() {
        DatabaseSchemaPlan createDatabasePlan = new DatabaseSchemaPlan(ConfigPhysicalPlanType.CreateDatabase, new TDatabaseSchema("root.db"));
        DatabaseSchemaPlan createDatabasePlanToFilter = new DatabaseSchemaPlan(ConfigPhysicalPlanType.CreateDatabase, new TDatabaseSchema("root.db1"));
        Assert.assertEquals((Object)createDatabasePlan, IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitCreateDatabase(createDatabasePlan, this.prefixPathPattern).orElseThrow(AssertionError::new));
        Assert.assertFalse((boolean)IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitCreateDatabase(createDatabasePlanToFilter, this.prefixPathPattern).isPresent());
    }

    @Test
    public void testAlterDatabase() {
        DatabaseSchemaPlan alterDatabasePlan = new DatabaseSchemaPlan(ConfigPhysicalPlanType.AlterDatabase, new TDatabaseSchema("root.db"));
        DatabaseSchemaPlan alterDatabasePlanToFilter = new DatabaseSchemaPlan(ConfigPhysicalPlanType.AlterDatabase, new TDatabaseSchema("root.db1"));
        Assert.assertEquals((Object)alterDatabasePlan, IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitAlterDatabase(alterDatabasePlan, this.prefixPathPattern).orElseThrow(AssertionError::new));
        Assert.assertFalse((boolean)IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitAlterDatabase(alterDatabasePlanToFilter, this.prefixPathPattern).isPresent());
    }

    @Test
    public void testDeleteDatabase() {
        DeleteDatabasePlan deleteDatabasePlan = new DeleteDatabasePlan("root.db");
        DeleteDatabasePlan deleteDatabasePlanToFilter = new DeleteDatabasePlan("root.db1");
        Assert.assertEquals((Object)deleteDatabasePlan, IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitDeleteDatabase(deleteDatabasePlan, this.prefixPathPattern).orElseThrow(AssertionError::new));
        Assert.assertFalse((boolean)IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitDeleteDatabase(deleteDatabasePlanToFilter, this.prefixPathPattern).isPresent());
    }

    @Test
    public void testCreateSchemaTemplate() throws IllegalPathException {
        CreateSchemaTemplatePlan createSchemaTemplatePlan = new CreateSchemaTemplatePlan(new Template("template_name", Arrays.asList("s1", "s2"), Arrays.asList(TSDataType.FLOAT, TSDataType.BOOLEAN), Arrays.asList(TSEncoding.RLE, TSEncoding.PLAIN), Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY)).serialize().array());
        Assert.assertEquals((Object)createSchemaTemplatePlan, IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitCreateSchemaTemplate(createSchemaTemplatePlan, this.prefixPathPattern).orElseThrow(AssertionError::new));
        CreateSchemaTemplatePlan parsedTemplatePlan = (CreateSchemaTemplatePlan)IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitCreateSchemaTemplate(createSchemaTemplatePlan, this.fullPathPattern).orElseThrow(AssertionError::new);
        Assert.assertEquals(Collections.singleton("s1"), parsedTemplatePlan.getTemplate().getSchemaMap().keySet());
        Assert.assertEquals(createSchemaTemplatePlan.getTemplate().getSchemaMap().get("s1"), parsedTemplatePlan.getTemplate().getSchemaMap().get("s1"));
    }

    @Test
    public void testCommitSetSchemaTemplate() {
        CommitSetSchemaTemplatePlan setSchemaTemplatePlanOnPrefix = new CommitSetSchemaTemplatePlan("t1", "root.db");
        CommitSetSchemaTemplatePlan setSchemaTemplatePlanOnFullPath = new CommitSetSchemaTemplatePlan("t1", "root.db.device.s1");
        Assert.assertEquals((Object)setSchemaTemplatePlanOnPrefix, IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitCommitSetSchemaTemplate(setSchemaTemplatePlanOnPrefix, this.fullPathPattern).orElseThrow(AssertionError::new));
        Assert.assertEquals((Object)setSchemaTemplatePlanOnFullPath, IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitCommitSetSchemaTemplate(setSchemaTemplatePlanOnFullPath, this.fullPathPattern).orElseThrow(AssertionError::new));
    }

    @Test
    public void testPipeUnsetSchemaTemplate() {
        PipeUnsetSchemaTemplatePlan pipeUnsetSchemaTemplatePlanOnPrefix = new PipeUnsetSchemaTemplatePlan("t1", "root.db");
        PipeUnsetSchemaTemplatePlan pipeUnsetSchemaTemplatePlanOrFullPath = new PipeUnsetSchemaTemplatePlan("t1", "root.db.device.s1");
        Assert.assertEquals((Object)pipeUnsetSchemaTemplatePlanOnPrefix, IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitPipeUnsetSchemaTemplate(pipeUnsetSchemaTemplatePlanOnPrefix, this.fullPathPattern).orElseThrow(AssertionError::new));
        Assert.assertEquals((Object)pipeUnsetSchemaTemplatePlanOrFullPath, IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitPipeUnsetSchemaTemplate(pipeUnsetSchemaTemplatePlanOrFullPath, this.fullPathPattern).orElseThrow(AssertionError::new));
    }

    @Test
    public void testExtendSchemaTemplate() {
        ExtendSchemaTemplatePlan extendSchemaTemplatePlan = new ExtendSchemaTemplatePlan(new TemplateExtendInfo("template_name", Arrays.asList("s1", "s2"), Arrays.asList(TSDataType.FLOAT, TSDataType.BOOLEAN), Arrays.asList(TSEncoding.RLE, TSEncoding.PLAIN), Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY)));
        ExtendSchemaTemplatePlan parsedTemplatePlan = (ExtendSchemaTemplatePlan)IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitExtendSchemaTemplate(extendSchemaTemplatePlan, this.fullPathPattern).orElseThrow(AssertionError::new);
        Assert.assertEquals(Collections.singletonList("s1"), (Object)parsedTemplatePlan.getTemplateExtendInfo().getMeasurements());
        Assert.assertEquals((Object)extendSchemaTemplatePlan.getTemplateExtendInfo().getTemplateName(), (Object)parsedTemplatePlan.getTemplateExtendInfo().getTemplateName());
        Assert.assertEquals(extendSchemaTemplatePlan.getTemplateExtendInfo().getDataTypes().get(0), parsedTemplatePlan.getTemplateExtendInfo().getDataTypes().get(0));
        Assert.assertEquals(extendSchemaTemplatePlan.getTemplateExtendInfo().getEncodings().get(0), parsedTemplatePlan.getTemplateExtendInfo().getEncodings().get(0));
        Assert.assertEquals(extendSchemaTemplatePlan.getTemplateExtendInfo().getCompressors().get(0), parsedTemplatePlan.getTemplateExtendInfo().getCompressors().get(0));
    }

    @Test
    public void testGrantUser() throws IllegalPathException {
        Assert.assertEquals(Collections.singletonList(new PartialPath("root.db.device.**")), (Object)((AuthorPlan)IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitGrantUser(new AuthorPlan(ConfigPhysicalPlanType.GrantUser, "tempUser", "", "", "", new HashSet<Integer>(Arrays.asList(1, 2)), true, Arrays.asList(new PartialPath("root.db.**"), new PartialPath("root.abc.**"))), this.prefixPathPattern).orElseThrow(AssertionError::new)).getNodeNameList());
    }

    @Test
    public void testRevokeUser() throws IllegalPathException {
        Assert.assertEquals(Collections.singletonList(new PartialPath("root.db.device.**")), (Object)((AuthorPlan)IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitRevokeUser(new AuthorPlan(ConfigPhysicalPlanType.RevokeUser, "tempUser", "", "", "", new HashSet<Integer>(Arrays.asList(1, 2)), false, Arrays.asList(new PartialPath("root.db.**"), new PartialPath("root.abc.**"))), this.prefixPathPattern).orElseThrow(AssertionError::new)).getNodeNameList());
    }

    @Test
    public void testGrantRole() throws IllegalPathException {
        Assert.assertEquals(Collections.singletonList(new PartialPath("root.db.device.**")), (Object)((AuthorPlan)IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitGrantRole(new AuthorPlan(ConfigPhysicalPlanType.GrantRole, "", "tempRole", "", "", new HashSet<Integer>(Arrays.asList(1, 2)), true, Arrays.asList(new PartialPath("root.db.**"), new PartialPath("root.abc.**"))), this.prefixPathPattern).orElseThrow(AssertionError::new)).getNodeNameList());
    }

    @Test
    public void testRevokeRole() throws IllegalPathException {
        Assert.assertEquals(Collections.singletonList(new PartialPath("root.db.device.**")), (Object)((AuthorPlan)IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitRevokeRole(new AuthorPlan(ConfigPhysicalPlanType.RevokeRole, "", "tempRole", "", "", new HashSet<Integer>(Arrays.asList(1, 2)), false, Arrays.asList(new PartialPath("root.db.**"), new PartialPath("root.abc.**"))), this.prefixPathPattern).orElseThrow(AssertionError::new)).getNodeNameList());
    }

    @Test
    public void testPipeDeleteTimeSeries() throws IllegalPathException, IOException {
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.*.device.s1"));
        patternTree.constructTree();
        Assert.assertEquals(Collections.singletonList(new PartialPath("root.db.device.s1")), (Object)PathPatternTree.deserialize((ByteBuffer)((PipeDeleteTimeSeriesPlan)IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitPipeDeleteTimeSeries(new PipeDeleteTimeSeriesPlan(patternTree.serialize()), this.prefixPathPattern).orElseThrow(AssertionError::new)).getPatternTreeBytes()).getAllPathPatterns());
    }

    @Test
    public void testPipeDeleteLogicalView() throws IllegalPathException, IOException {
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(new PartialPath("root.*.device.s1"));
        patternTree.constructTree();
        Assert.assertEquals(Collections.singletonList(new PartialPath("root.db.device.s1")), (Object)PathPatternTree.deserialize((ByteBuffer)((PipeDeleteLogicalViewPlan)IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitPipeDeleteLogicalView(new PipeDeleteLogicalViewPlan(patternTree.serialize()), this.prefixPathPattern).orElseThrow(AssertionError::new)).getPatternTreeBytes()).getAllPathPatterns());
    }

    @Test
    public void testPipeDeactivateTemplate() throws IllegalPathException {
        final Template template1 = this.newSchemaTemplate("template1");
        final Template template2 = this.newSchemaTemplate("template2");
        final Template template3 = this.newSchemaTemplate("template3");
        Assert.assertEquals((Object)new HashMap<PartialPath, List<Template>>(){
            {
                this.put(new PartialPath("root.db.device.s1"), Arrays.asList(template1, template2, template3));
            }
        }, (Object)((PipeDeactivateTemplatePlan)IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitPipeDeactivateTemplate(new PipeDeactivateTemplatePlan((Map)new HashMap<PartialPath, List<Template>>(){
            {
                this.put(new PartialPath("root.*.device.s1"), Collections.singletonList(template1));
                this.put(new PartialPath("root.db.*.s1"), Arrays.asList(template2, template3));
            }
        }), this.prefixPathPattern).orElseThrow(AssertionError::new)).getTemplateSetInfo());
    }

    private Template newSchemaTemplate(String name) throws IllegalPathException {
        return new Template(name, Arrays.asList(name + "_temperature", name + "_status"), Arrays.asList(TSDataType.FLOAT, TSDataType.BOOLEAN), Arrays.asList(TSEncoding.RLE, TSEncoding.PLAIN), Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY));
    }

    @Test
    public void testSetTTL() throws IllegalPathException {
        SetTTLPlan plan = (SetTTLPlan)IoTDBConfigRegionExtractor.PATTERN_PARSE_VISITOR.visitTTL(new SetTTLPlan(Arrays.asList("root", "db", "**"), Long.MAX_VALUE), this.prefixPathPattern).orElseThrow(AssertionError::new);
        Assert.assertEquals((Object)new PartialPath("root.db.device.**"), (Object)new PartialPath(plan.getPathPattern()));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)plan.getTTL());
    }
}

