/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.connector;

import java.io.IOException;
import org.apache.iotdb.confignode.consensus.request.write.cq.ActiveCQPlan;
import org.apache.iotdb.confignode.manager.pipe.connector.payload.PipeTransferConfigNodeHandshakeV1Req;
import org.apache.iotdb.confignode.manager.pipe.connector.payload.PipeTransferConfigPlanReq;
import org.apache.iotdb.confignode.manager.pipe.connector.payload.PipeTransferConfigSnapshotPieceReq;
import org.apache.iotdb.confignode.manager.pipe.connector.payload.PipeTransferConfigSnapshotSealReq;
import org.apache.iotdb.confignode.persistence.schema.CNSnapshotFileType;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.junit.Assert;
import org.junit.Test;

public class PipeConfigNodeThriftRequestTest {
    private static final String TIME_PRECISION = "ms";

    @Test
    public void testPipeTransferConfigHandshakeReq() throws IOException {
        PipeTransferConfigNodeHandshakeV1Req req = PipeTransferConfigNodeHandshakeV1Req.toTPipeTransferReq((String)TIME_PRECISION);
        PipeTransferConfigNodeHandshakeV1Req deserializeReq = PipeTransferConfigNodeHandshakeV1Req.fromTPipeTransferReq((TPipeTransferReq)req);
        Assert.assertEquals((long)req.getVersion(), (long)deserializeReq.getVersion());
        Assert.assertEquals((long)req.getType(), (long)deserializeReq.getType());
        Assert.assertEquals((Object)req.getTimestampPrecision(), (Object)deserializeReq.getTimestampPrecision());
    }

    @Test
    public void testPipeTransferConfigPlanReq() {
        PipeTransferConfigPlanReq req = PipeTransferConfigPlanReq.toTPipeTransferReq((IConsensusRequest)new ActiveCQPlan("cqId", "md5"));
        PipeTransferConfigPlanReq deserializeReq = PipeTransferConfigPlanReq.fromTPipeTransferReq((TPipeTransferReq)req);
        Assert.assertEquals((long)req.getVersion(), (long)deserializeReq.getVersion());
        Assert.assertEquals((long)req.getType(), (long)deserializeReq.getType());
    }

    @Test
    public void testPipeTransferConfigSnapshotPieceReq() throws IOException {
        byte[] body = "testPipeTransferConfigSnapshotPieceReq".getBytes();
        String fileName = "1.temp";
        PipeTransferConfigSnapshotPieceReq req = PipeTransferConfigSnapshotPieceReq.toTPipeTransferReq((String)fileName, (long)0L, (byte[])body);
        PipeTransferConfigSnapshotPieceReq deserializeReq = PipeTransferConfigSnapshotPieceReq.fromTPipeTransferReq((TPipeTransferReq)req);
        Assert.assertEquals((long)req.getVersion(), (long)deserializeReq.getVersion());
        Assert.assertEquals((long)req.getType(), (long)deserializeReq.getType());
        Assert.assertEquals((Object)req.getFileName(), (Object)deserializeReq.getFileName());
        Assert.assertEquals((long)req.getStartWritingOffset(), (long)deserializeReq.getStartWritingOffset());
        Assert.assertArrayEquals((byte[])req.getFilePiece(), (byte[])deserializeReq.getFilePiece());
    }

    @Test
    public void testPipeTransferConfigSnapshotSealReq() throws IOException {
        String snapshotName = "cluster_schema.bin";
        String templateInfoName = "template_info.bin";
        CNSnapshotFileType fileType = CNSnapshotFileType.SCHEMA;
        String typeString = "200";
        PipeTransferConfigSnapshotSealReq req = PipeTransferConfigSnapshotSealReq.toTPipeTransferReq((String)"root.**", (String)snapshotName, (long)100L, (String)templateInfoName, (long)10L, (CNSnapshotFileType)fileType, (String)typeString);
        PipeTransferConfigSnapshotSealReq deserializeReq = PipeTransferConfigSnapshotSealReq.fromTPipeTransferReq((TPipeTransferReq)req);
        Assert.assertEquals((long)req.getVersion(), (long)deserializeReq.getVersion());
        Assert.assertEquals((long)req.getType(), (long)deserializeReq.getType());
        Assert.assertEquals((Object)req.getFileNames(), (Object)deserializeReq.getFileNames());
        Assert.assertEquals((Object)req.getFileLengths(), (Object)deserializeReq.getFileLengths());
        Assert.assertEquals((Object)req.getParameters(), (Object)deserializeReq.getParameters());
    }
}

