/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.agent;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.agent.plugin.builtin.BuiltinPipePlugin;
import org.apache.iotdb.commons.pipe.agent.task.execution.PipeSubtaskExecutor;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.agent.task.subtask.PipeSubtask;
import org.apache.iotdb.confignode.manager.pipe.agent.task.PipeConfigNodeSubtask;
import org.apache.iotdb.confignode.manager.pipe.agent.task.PipeConfigNodeSubtaskExecutor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PipeConfigNodeSubtaskExecutorTest {
    private PipeSubtaskExecutor executor;
    private PipeSubtask subtask;

    @Before
    public void setUp() throws Exception {
        this.executor = new PipeConfigNodeSubtaskExecutor(new Object());
        this.subtask = (PipeSubtask)Mockito.spy((Object)new PipeConfigNodeSubtask("PipeConfigNodeSubtaskExecutorTest", System.currentTimeMillis(), new HashMap(), new HashMap(), (Map)new HashMap<String, String>(){
            {
                this.put("connector", BuiltinPipePlugin.DO_NOTHING_CONNECTOR.getPipePluginName());
            }
        }, new PipeTaskMeta((ProgressIndex)MinimumProgressIndex.INSTANCE, Integer.MIN_VALUE)));
    }

    @After
    public void tearDown() throws Exception {
        this.executor.shutdown();
        Assert.assertTrue((boolean)this.executor.isShutdown());
    }

    @Test
    public void testRegister() {
        Assert.assertFalse((boolean)this.executor.isRegistered(this.subtask.getTaskID()));
        Assert.assertEquals((long)0L, (long)this.executor.getRegisteredSubtaskNumber());
        this.executor.register(this.subtask);
        Assert.assertTrue((boolean)this.executor.isRegistered(this.subtask.getTaskID()));
        Assert.assertEquals((long)1L, (long)this.executor.getRegisteredSubtaskNumber());
        this.executor.register(this.subtask);
        Assert.assertTrue((boolean)this.executor.isRegistered(this.subtask.getTaskID()));
        Assert.assertEquals((long)1L, (long)this.executor.getRegisteredSubtaskNumber());
        this.executor.deregister(this.subtask.getTaskID());
        Assert.assertFalse((boolean)this.executor.isRegistered(this.subtask.getTaskID()));
    }

    @Test
    public void testStart() throws Exception {
        this.executor.start(this.subtask.getTaskID());
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ((PipeSubtask)Mockito.verify((Object)this.subtask, (VerificationMode)Mockito.times((int)0))).call();
        this.executor.register(this.subtask);
        this.executor.start(this.subtask.getTaskID());
        Assert.assertTrue((boolean)this.subtask.isSubmittingSelf());
        this.executor.start(this.subtask.getTaskID());
        Assert.assertTrue((boolean)this.subtask.isSubmittingSelf());
    }

    @Test
    public void testStop() {
        this.executor.stop(this.subtask.getTaskID());
        Assert.assertFalse((boolean)this.subtask.isSubmittingSelf());
        this.executor.register(this.subtask);
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.executor.stop(this.subtask.getTaskID());
        Assert.assertFalse((boolean)this.subtask.isSubmittingSelf());
        this.executor.start(this.subtask.getTaskID());
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.executor.stop(this.subtask.getTaskID());
        Assert.assertFalse((boolean)this.subtask.isSubmittingSelf());
        this.executor.stop(this.subtask.getTaskID());
        Assert.assertFalse((boolean)this.subtask.isSubmittingSelf());
    }

    @Test
    public void testDeregister() {
        this.executor.deregister(this.subtask.getTaskID());
        Assert.assertEquals((long)0L, (long)this.executor.getRegisteredSubtaskNumber());
        this.executor.register(this.subtask);
        Assert.assertEquals((long)1L, (long)this.executor.getRegisteredSubtaskNumber());
        this.executor.start(this.subtask.getTaskID());
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.executor.deregister(this.subtask.getTaskID());
        Assert.assertEquals((long)0L, (long)this.executor.getRegisteredSubtaskNumber());
        Assert.assertFalse((boolean)this.subtask.isSubmittingSelf());
        this.executor.deregister(this.subtask.getTaskID());
        Assert.assertEquals((long)0L, (long)this.executor.getRegisteredSubtaskNumber());
        Assert.assertFalse((boolean)this.subtask.isSubmittingSelf());
    }

    @Test
    public void testShutdown() {
        this.executor.start(this.subtask.getTaskID());
        this.executor.shutdown();
        Assert.assertTrue((boolean)this.executor.isShutdown());
        Assert.assertFalse((boolean)this.subtask.isSubmittingSelf());
        this.executor.shutdown();
        Assert.assertTrue((boolean)this.executor.isShutdown());
        Assert.assertFalse((boolean)this.subtask.isSubmittingSelf());
    }
}

