/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache.detector;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.manager.load.cache.AbstractHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.IFailureDetector;
import org.apache.iotdb.confignode.manager.load.cache.detector.FixedDetector;
import org.apache.iotdb.confignode.manager.load.cache.detector.PhiAccrualDetector;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.junit.Assert;
import org.junit.Test;

public class DetectorTest {
    final long sec = 1000000000L;
    final FixedDetector fixedDetector = new FixedDetector(20000000000L);
    final PhiAccrualDetector phiAccrualDetector = new PhiAccrualDetector(30L, 10000000000L, 200000000L, 0, (IFailureDetector)this.fixedDetector);

    private double getPhi(long elapsed, double[] intervals, long minStd, long pause) {
        PhiAccrualDetector.PhiAccrual p = new PhiAccrualDetector.PhiAccrual(intervals, elapsed, minStd, pause);
        return p.phi();
    }

    private void assertInRange(double value, double start, double end) {
        Assert.assertTrue((value > start ? 1 : 0) != 0);
        Assert.assertTrue((value < end ? 1 : 0) != 0);
    }

    @Test
    public void testFixedDetector() {
        long lastHeartbeatTs = System.nanoTime() - 21000000000L;
        List<NodeHeartbeatSample> history = Collections.singletonList(new NodeHeartbeatSample(lastHeartbeatTs, NodeStatus.Running));
        Assert.assertFalse((boolean)this.fixedDetector.isAvailable(history));
        long lastAvailableHeartbeat = System.nanoTime() - 18000000000L;
        List<NodeHeartbeatSample> history2 = Collections.singletonList(new NodeHeartbeatSample(lastAvailableHeartbeat, NodeStatus.Running));
        Assert.assertTrue((boolean)this.fixedDetector.isAvailable(history2));
    }

    @Test
    public void testPhiCalculation1() {
        double[] heartbeatIntervals = new double[]{1000.0, 1000.0, 1000.0, 1000.0, 1000.0};
        long minStd = 200L;
        long pause = 0L;
        this.assertInRange(this.getPhi(1000L, heartbeatIntervals, 200L, 0L), 0.0, 1.0);
        this.assertInRange(this.getPhi(2000L, heartbeatIntervals, 200L, 0L), 5.0, 10.0);
        this.assertInRange(this.getPhi(3000L, heartbeatIntervals, 200L, 0L), 35.0, 50.0);
    }

    @Test
    public void testPhiCalculation2() {
        double[] heartbeatIntervals = new double[]{1000.0, 1000.0, 1000.0, 1000.0, 1000.0};
        long minStd = 300L;
        long pause = 0L;
        this.assertInRange(this.getPhi(1000L, heartbeatIntervals, 300L, 0L), 0.0, 1.0);
        this.assertInRange(this.getPhi(2000L, heartbeatIntervals, 300L, 0L), 1.0, 5.0);
        this.assertInRange(this.getPhi(3000L, heartbeatIntervals, 300L, 0L), 10.0, 15.0);
    }

    @Test
    public void testPhiCalculation3() {
        double[] heartbeatIntervals = new double[]{1000.0, 1000.0, 1000.0, 1000.0, 1000.0};
        long minStd = 200L;
        long pause = 3000L;
        this.assertInRange(this.getPhi(4000L, heartbeatIntervals, 200L, 3000L), 0.0, 1.0);
        this.assertInRange(this.getPhi(5000L, heartbeatIntervals, 200L, 3000L), 5.0, 10.0);
        this.assertInRange(this.getPhi(6000L, heartbeatIntervals, 200L, 3000L), 35.0, 50.0);
    }

    @Test
    public void testComparisonQuickFailureDetection() {
        long[] interval = new long[]{1000000000L, 1000000000L, 1000000000L};
        List<AbstractHeartbeatSample> history = this.fromInterval(interval, 13000000000L);
        Assert.assertTrue((boolean)this.fixedDetector.isAvailable(history));
        Assert.assertFalse((boolean)this.phiAccrualDetector.isAvailable(history));
    }

    @Test
    public void testFalsePositiveOnExceptionallyLongGCPause() {
        long[] interval = new long[]{1000000000L, 1000000000L, 1000000000L};
        long gcPause = 15000000000L;
        List<AbstractHeartbeatSample> history = this.fromInterval(interval, gcPause + 2000000000L);
        Assert.assertTrue((boolean)this.fixedDetector.isAvailable(history));
        Assert.assertFalse((boolean)this.phiAccrualDetector.isAvailable(history));
    }

    @Test
    public void testPhiAdaptionToFrequentGCPause() {
        long[] interval = new long[]{1000000000L, 1000000000L, 1000000000L, 15000000000L, 100000000L, 1000000000L, 1000000000L, 1000000000L, 15000000000L, 100000000L, 1000000000L, 1000000000L};
        List<AbstractHeartbeatSample> history = this.fromInterval(interval, 21000000000L);
        Assert.assertFalse((boolean)this.fixedDetector.isAvailable(history));
        Assert.assertTrue((boolean)this.phiAccrualDetector.isAvailable(history));
    }

    @Test
    public void testColdStart() {
        PhiAccrualDetector coldStartPhi = new PhiAccrualDetector(30L, 10000000000L, 200000000L, 60, (IFailureDetector)this.fixedDetector);
        long[] interval = new long[]{1000000000L, 1000000000L, 1000000000L};
        List<AbstractHeartbeatSample> history = this.fromInterval(interval, 21000000000L);
        Assert.assertFalse((boolean)this.fixedDetector.isAvailable(history));
        Assert.assertFalse((boolean)coldStartPhi.isAvailable(history));
    }

    private List<AbstractHeartbeatSample> fromInterval(long[] interval, long timeElapsed) {
        long now = System.nanoTime();
        long begin = now - timeElapsed;
        LinkedList<AbstractHeartbeatSample> sample = new LinkedList<AbstractHeartbeatSample>();
        sample.add((AbstractHeartbeatSample)new NodeHeartbeatSample(begin, NodeStatus.Running));
        for (int i = interval.length - 1; i >= 0; --i) {
            sample.add(0, (AbstractHeartbeatSample)new NodeHeartbeatSample(begin -= interval[i], NodeStatus.Running));
        }
        return sample;
    }
}

