/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.cache;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionGroupCache;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionHeartbeatSample;
import org.apache.iotdb.confignode.manager.partition.RegionGroupStatus;
import org.junit.Assert;
import org.junit.Test;

public class RegionGroupCacheTest {
    private static final String DATABASE = "root.db";

    @Test
    public void getRegionStatusTest() {
        long currentTime = System.nanoTime();
        RegionGroupCache regionGroupCache = new RegionGroupCache(DATABASE, Stream.of(0, 1, 2, 3, 4).collect(Collectors.toSet()), false);
        regionGroupCache.cacheHeartbeatSample(0, new RegionHeartbeatSample(currentTime, RegionStatus.Running));
        regionGroupCache.cacheHeartbeatSample(1, new RegionHeartbeatSample(currentTime, RegionStatus.Unknown));
        regionGroupCache.cacheHeartbeatSample(2, new RegionHeartbeatSample(currentTime, RegionStatus.Removing));
        regionGroupCache.cacheHeartbeatSample(3, new RegionHeartbeatSample(currentTime, RegionStatus.ReadOnly));
        regionGroupCache.cacheHeartbeatSample(4, new RegionHeartbeatSample(currentTime, RegionStatus.Adding));
        regionGroupCache.updateCurrentStatistics();
        Assert.assertEquals((Object)RegionStatus.Running, (Object)regionGroupCache.getCurrentStatistics().getRegionStatus(0));
        Assert.assertEquals((Object)RegionStatus.Unknown, (Object)regionGroupCache.getCurrentStatistics().getRegionStatus(1));
        Assert.assertEquals((Object)RegionStatus.Removing, (Object)regionGroupCache.getCurrentStatistics().getRegionStatus(2));
        Assert.assertEquals((Object)RegionStatus.ReadOnly, (Object)regionGroupCache.getCurrentStatistics().getRegionStatus(3));
        Assert.assertEquals((Object)RegionStatus.Adding, (Object)regionGroupCache.getCurrentStatistics().getRegionStatus(4));
    }

    @Test
    public void weakConsistencyRegionGroupStatusTest() {
        long currentTime = System.nanoTime();
        RegionGroupCache regionGroupCache = new RegionGroupCache(DATABASE, Stream.of(0, 1, 2).collect(Collectors.toSet()), false);
        regionGroupCache.cacheHeartbeatSample(0, new RegionHeartbeatSample(currentTime, RegionStatus.Running));
        regionGroupCache.cacheHeartbeatSample(1, new RegionHeartbeatSample(currentTime, RegionStatus.Running));
        regionGroupCache.cacheHeartbeatSample(2, new RegionHeartbeatSample(currentTime, RegionStatus.Running));
        regionGroupCache.updateCurrentStatistics();
        Assert.assertEquals((Object)RegionGroupStatus.Running, (Object)regionGroupCache.getCurrentStatistics().getRegionGroupStatus());
        regionGroupCache.cacheHeartbeatSample(0, new RegionHeartbeatSample(currentTime, RegionStatus.Unknown));
        regionGroupCache.updateCurrentStatistics();
        Assert.assertEquals((Object)RegionGroupStatus.Available, (Object)regionGroupCache.getCurrentStatistics().getRegionGroupStatus());
        regionGroupCache.cacheHeartbeatSample(1, new RegionHeartbeatSample(currentTime, RegionStatus.Unknown));
        regionGroupCache.updateCurrentStatistics();
        Assert.assertEquals((Object)RegionGroupStatus.Available, (Object)regionGroupCache.getCurrentStatistics().getRegionGroupStatus());
        regionGroupCache.cacheHeartbeatSample(2, new RegionHeartbeatSample(currentTime, RegionStatus.Unknown));
        regionGroupCache.updateCurrentStatistics();
        Assert.assertEquals((Object)RegionGroupStatus.Disabled, (Object)regionGroupCache.getCurrentStatistics().getRegionGroupStatus());
    }

    @Test
    public void strongConsistencyRegionGroupStatusTest() {
        long currentTime = System.nanoTime();
        RegionGroupCache regionGroupCache = new RegionGroupCache(DATABASE, Stream.of(0, 1, 2).collect(Collectors.toSet()), true);
        regionGroupCache.cacheHeartbeatSample(0, new RegionHeartbeatSample(currentTime, RegionStatus.Running));
        regionGroupCache.cacheHeartbeatSample(1, new RegionHeartbeatSample(currentTime, RegionStatus.Running));
        regionGroupCache.cacheHeartbeatSample(2, new RegionHeartbeatSample(currentTime, RegionStatus.Running));
        regionGroupCache.updateCurrentStatistics();
        Assert.assertEquals((Object)RegionGroupStatus.Running, (Object)regionGroupCache.getCurrentStatistics().getRegionGroupStatus());
        regionGroupCache.cacheHeartbeatSample(0, new RegionHeartbeatSample(currentTime, RegionStatus.Unknown));
        regionGroupCache.updateCurrentStatistics();
        Assert.assertEquals((Object)RegionGroupStatus.Available, (Object)regionGroupCache.getCurrentStatistics().getRegionGroupStatus());
        regionGroupCache.cacheHeartbeatSample(1, new RegionHeartbeatSample(currentTime, RegionStatus.Unknown));
        regionGroupCache.updateCurrentStatistics();
        Assert.assertEquals((Object)RegionGroupStatus.Disabled, (Object)regionGroupCache.getCurrentStatistics().getRegionGroupStatus());
        regionGroupCache.cacheHeartbeatSample(2, new RegionHeartbeatSample(currentTime, RegionStatus.Unknown));
        regionGroupCache.updateCurrentStatistics();
        Assert.assertEquals((Object)RegionGroupStatus.Disabled, (Object)regionGroupCache.getCurrentStatistics().getRegionGroupStatus());
    }

    @Test
    public void migrateRegionRegionGroupStatusTest() {
        long currentTime = System.nanoTime();
        RegionGroupCache regionGroupCache = new RegionGroupCache(DATABASE, Stream.of(Integer.valueOf(0)).collect(Collectors.toSet()), true);
        regionGroupCache.cacheHeartbeatSample(0, new RegionHeartbeatSample(currentTime, RegionStatus.Running));
        regionGroupCache.updateCurrentStatistics();
        Assert.assertEquals((Object)RegionGroupStatus.Running, (Object)regionGroupCache.getCurrentStatistics().getRegionGroupStatus());
        regionGroupCache = new RegionGroupCache(DATABASE, Stream.of(0, 1).collect(Collectors.toSet()), true);
        regionGroupCache.cacheHeartbeatSample(0, new RegionHeartbeatSample(currentTime, RegionStatus.Running));
        regionGroupCache.cacheHeartbeatSample(1, new RegionHeartbeatSample(currentTime, RegionStatus.Adding));
        regionGroupCache.updateCurrentStatistics();
        Assert.assertEquals((Object)RegionGroupStatus.Running, (Object)regionGroupCache.getCurrentStatistics().getRegionGroupStatus());
        regionGroupCache = new RegionGroupCache(DATABASE, Stream.of(0, 1).collect(Collectors.toSet()), true);
        regionGroupCache.cacheHeartbeatSample(0, new RegionHeartbeatSample(currentTime, RegionStatus.Running));
        regionGroupCache.cacheHeartbeatSample(1, new RegionHeartbeatSample(currentTime, RegionStatus.Removing));
        regionGroupCache.updateCurrentStatistics();
        Assert.assertEquals((Object)RegionGroupStatus.Running, (Object)regionGroupCache.getCurrentStatistics().getRegionGroupStatus());
    }
}

