/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.router.priority;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.manager.load.balancer.router.priority.LeaderPriorityBalancer;
import org.apache.iotdb.confignode.manager.load.cache.AbstractHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.node.BaseNodeCache;
import org.apache.iotdb.confignode.manager.load.cache.node.DataNodeHeartbeatCache;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.junit.Assert;
import org.junit.Test;

public class LeaderPriorityBalancerTest {
    @Test
    public void testGenRealTimeRoutingPolicy() {
        ArrayList<TDataNodeLocation> dataNodeLocations = new ArrayList<TDataNodeLocation>();
        for (int i = 0; i < 6; ++i) {
            dataNodeLocations.add(new TDataNodeLocation(i, new TEndPoint("0.0.0.0", 6667 + i), new TEndPoint("0.0.0.0", 10730 + i), new TEndPoint("0.0.0.0", 10740 + i), new TEndPoint("0.0.0.0", 10760 + i), new TEndPoint("0.0.0.0", 10750 + i)));
        }
        long currentTimeNs = System.nanoTime();
        HashMap<Integer, DataNodeHeartbeatCache> nodeCacheMap = new HashMap<Integer, DataNodeHeartbeatCache>();
        for (int i = 0; i < 6; ++i) {
            nodeCacheMap.put(i, new DataNodeHeartbeatCache(i));
            if (i == 2 || i == 5) continue;
            ((BaseNodeCache)nodeCacheMap.get(i)).cacheHeartbeatSample((AbstractHeartbeatSample)new NodeHeartbeatSample(currentTimeNs, NodeStatus.Running));
        }
        nodeCacheMap.values().forEach(baseNodeCache -> baseNodeCache.updateCurrentStatistics(false));
        TConsensusGroupId groupId1 = new TConsensusGroupId(TConsensusGroupType.SchemaRegion, 1);
        TRegionReplicaSet regionReplicaSet1 = new TRegionReplicaSet(groupId1, Arrays.asList((TDataNodeLocation)dataNodeLocations.get(0), (TDataNodeLocation)dataNodeLocations.get(1), (TDataNodeLocation)dataNodeLocations.get(2)));
        TConsensusGroupId groupId2 = new TConsensusGroupId(TConsensusGroupType.DataRegion, 2);
        TRegionReplicaSet regionReplicaSet2 = new TRegionReplicaSet(groupId2, Arrays.asList((TDataNodeLocation)dataNodeLocations.get(3), (TDataNodeLocation)dataNodeLocations.get(4), (TDataNodeLocation)dataNodeLocations.get(5)));
        List<TRegionReplicaSet> regionReplicaSets = Arrays.asList(regionReplicaSet1, regionReplicaSet2);
        HashMap<TConsensusGroupId, Integer> leaderMap = new HashMap<TConsensusGroupId, Integer>();
        leaderMap.put(groupId1, 1);
        leaderMap.put(groupId2, 4);
        Map result = new LeaderPriorityBalancer().generateOptimalRoutePriority(regionReplicaSets, leaderMap);
        TRegionReplicaSet result1 = (TRegionReplicaSet)result.get(groupId1);
        Assert.assertEquals(dataNodeLocations.get(1), result1.getDataNodeLocations().get(0));
        Assert.assertEquals(dataNodeLocations.get(0), result1.getDataNodeLocations().get(1));
        Assert.assertEquals(dataNodeLocations.get(2), result1.getDataNodeLocations().get(2));
        TRegionReplicaSet result2 = (TRegionReplicaSet)result.get(groupId2);
        Assert.assertEquals(dataNodeLocations.get(4), result2.getDataNodeLocations().get(0));
        Assert.assertEquals(dataNodeLocations.get(3), result2.getDataNodeLocations().get(1));
        Assert.assertEquals(dataNodeLocations.get(5), result2.getDataNodeLocations().get(2));
    }
}

