/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.router.priority;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.manager.load.balancer.router.priority.GreedyPriorityBalancer;
import org.apache.iotdb.confignode.manager.load.cache.AbstractHeartbeatSample;
import org.apache.iotdb.confignode.manager.load.cache.node.BaseNodeCache;
import org.apache.iotdb.confignode.manager.load.cache.node.DataNodeHeartbeatCache;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeHeartbeatSample;
import org.junit.Assert;
import org.junit.Test;

public class GreedyPriorityTest {
    @Test
    public void testGenLoadScoreGreedyRoutingPolicy() {
        ArrayList<TDataNodeLocation> dataNodeLocations = new ArrayList<TDataNodeLocation>();
        for (int i = 0; i < 4; ++i) {
            dataNodeLocations.add(new TDataNodeLocation(i, new TEndPoint("0.0.0.0", 6667 + i), new TEndPoint("0.0.0.0", 10730 + i), new TEndPoint("0.0.0.0", 10740 + i), new TEndPoint("0.0.0.0", 10760 + i), new TEndPoint("0.0.0.0", 10750 + i)));
        }
        long currentTimeNs = System.nanoTime();
        HashMap<Integer, DataNodeHeartbeatCache> nodeCacheMap = new HashMap<Integer, DataNodeHeartbeatCache>();
        NodeStatus[] statuses = new NodeStatus[]{NodeStatus.Running, NodeStatus.Unknown, NodeStatus.Running, NodeStatus.ReadOnly};
        for (int i = 0; i < 4; ++i) {
            nodeCacheMap.put(i, new DataNodeHeartbeatCache(i));
            ((BaseNodeCache)nodeCacheMap.get(i)).cacheHeartbeatSample((AbstractHeartbeatSample)new NodeHeartbeatSample(currentTimeNs, statuses[i]));
        }
        nodeCacheMap.values().forEach(baseNodeCache -> baseNodeCache.updateCurrentStatistics(false));
        TConsensusGroupId groupId1 = new TConsensusGroupId(TConsensusGroupType.SchemaRegion, 1);
        TRegionReplicaSet regionReplicaSet1 = new TRegionReplicaSet(groupId1, Arrays.asList((TDataNodeLocation)dataNodeLocations.get(0), (TDataNodeLocation)dataNodeLocations.get(1)));
        TConsensusGroupId groupId2 = new TConsensusGroupId(TConsensusGroupType.DataRegion, 2);
        TRegionReplicaSet regionReplicaSet2 = new TRegionReplicaSet(groupId2, Arrays.asList((TDataNodeLocation)dataNodeLocations.get(2), (TDataNodeLocation)dataNodeLocations.get(3)));
        Map result = new GreedyPriorityBalancer().generateOptimalRoutePriority(Arrays.asList(regionReplicaSet1, regionReplicaSet2), new HashMap());
        Assert.assertEquals((long)2L, (long)result.size());
        TRegionReplicaSet result1 = (TRegionReplicaSet)result.get(groupId1);
        for (int i = 0; i < 2; ++i) {
            Assert.assertEquals(dataNodeLocations.get(i), result1.getDataNodeLocations().get(i));
        }
        TRegionReplicaSet result2 = (TRegionReplicaSet)result.get(groupId2);
        for (int i = 2; i < 4; ++i) {
            Assert.assertEquals(dataNodeLocations.get(i), result2.getDataNodeLocations().get(i - 2));
        }
    }
}

