/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.router.leader;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.manager.load.balancer.router.leader.GreedyLeaderBalancer;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeStatistics;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionStatistics;
import org.junit.Assert;
import org.junit.Test;

public class GreedyLeaderBalancerTest {
    private static final GreedyLeaderBalancer BALANCER = new GreedyLeaderBalancer();

    @Test
    public void optimalLeaderDistributionTest() {
        TRegionReplicaSet regionReplicaSet;
        TreeMap<Integer, RegionStatistics> regionStatistics;
        ArrayList<TDataNodeLocation> dataNodeLocations;
        TConsensusGroupId regionGroupId2;
        int i;
        TreeMap regionReplicaSetMap = new TreeMap();
        TreeMap<TConsensusGroupId, Integer> regionLeaderMap = new TreeMap<TConsensusGroupId, Integer>();
        TreeMap<Integer, NodeStatistics> dataNodeStatisticsMap = new TreeMap<Integer, NodeStatistics>();
        TreeMap regionStatisticsMap = new TreeMap();
        Random random = new Random();
        for (i = 0; i < 6; ++i) {
            dataNodeStatisticsMap.put(i, new NodeStatistics(NodeStatus.Running));
        }
        for (i = 0; i < 9; ++i) {
            regionGroupId2 = new TConsensusGroupId(TConsensusGroupType.DataRegion, i);
            dataNodeLocations = new ArrayList<TDataNodeLocation>();
            regionStatistics = new TreeMap<Integer, RegionStatistics>();
            for (int j = 0; j < 3; ++j) {
                dataNodeLocations.add(new TDataNodeLocation().setDataNodeId(j));
                regionStatistics.put(j, new RegionStatistics(RegionStatus.Running));
            }
            regionReplicaSet = new TRegionReplicaSet(regionGroupId2, dataNodeLocations);
            regionReplicaSetMap.put(regionGroupId2, regionReplicaSet.getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toSet()));
            regionLeaderMap.put(regionGroupId2, random.nextInt(3));
            regionStatisticsMap.put(regionGroupId2, regionStatistics);
        }
        for (i = 9; i < 18; ++i) {
            regionGroupId2 = new TConsensusGroupId(TConsensusGroupType.DataRegion, i);
            dataNodeLocations = new ArrayList();
            regionStatistics = new TreeMap();
            for (int j = 3; j < 6; ++j) {
                dataNodeLocations.add(new TDataNodeLocation().setDataNodeId(j));
                regionStatistics.put(j, new RegionStatistics(RegionStatus.Running));
            }
            regionReplicaSet = new TRegionReplicaSet(regionGroupId2, dataNodeLocations);
            regionReplicaSetMap.put(regionGroupId2, regionReplicaSet.getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toSet()));
            regionLeaderMap.put(regionGroupId2, 3 + random.nextInt(3));
            regionStatisticsMap.put(regionGroupId2, regionStatistics);
        }
        Map leaderDistribution = BALANCER.generateOptimalLeaderDistribution(new TreeMap(), regionReplicaSetMap, regionLeaderMap, dataNodeStatisticsMap, regionStatisticsMap);
        ConcurrentHashMap leaderCounter = new ConcurrentHashMap();
        leaderDistribution.forEach((regionGroupId, leaderId) -> leaderCounter.computeIfAbsent(leaderId, empty -> new AtomicInteger(0)).getAndIncrement());
        for (int i2 = 0; i2 < 6; ++i2) {
            Assert.assertEquals((long)3L, (long)((AtomicInteger)leaderCounter.get(i2)).get());
        }
    }

    @Test
    public void disableTest() {
        TRegionReplicaSet regionReplicaSet;
        TreeMap<Integer, RegionStatistics> regionStatistics;
        ArrayList<TDataNodeLocation> dataNodeLocations;
        TConsensusGroupId regionGroupId2;
        int i;
        TreeMap regionReplicaSetMap = new TreeMap();
        TreeMap<TConsensusGroupId, Integer> regionLeaderMap = new TreeMap<TConsensusGroupId, Integer>();
        TreeMap<Integer, NodeStatistics> dataNodeStatisticsMap = new TreeMap<Integer, NodeStatistics>();
        TreeMap regionStatisticsMap = new TreeMap();
        dataNodeStatisticsMap.put(0, new NodeStatistics(NodeStatus.Running));
        dataNodeStatisticsMap.put(1, new NodeStatistics(NodeStatus.Unknown));
        dataNodeStatisticsMap.put(2, new NodeStatistics(NodeStatus.Running));
        dataNodeStatisticsMap.put(3, new NodeStatistics(NodeStatus.Running));
        dataNodeStatisticsMap.put(4, new NodeStatistics(NodeStatus.ReadOnly));
        dataNodeStatisticsMap.put(5, new NodeStatistics(NodeStatus.Running));
        for (i = 0; i < 10; ++i) {
            regionGroupId2 = new TConsensusGroupId(TConsensusGroupType.DataRegion, i);
            dataNodeLocations = new ArrayList<TDataNodeLocation>();
            regionStatistics = new TreeMap<Integer, RegionStatistics>();
            for (int j = 0; j < 3; ++j) {
                dataNodeLocations.add(new TDataNodeLocation().setDataNodeId(j));
                regionStatistics.put(j, new RegionStatistics(j == 1 ? RegionStatus.Unknown : RegionStatus.Running));
            }
            regionReplicaSet = new TRegionReplicaSet(regionGroupId2, dataNodeLocations);
            regionReplicaSetMap.put(regionGroupId2, regionReplicaSet.getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toSet()));
            regionLeaderMap.put(regionGroupId2, 1);
            regionStatisticsMap.put(regionGroupId2, regionStatistics);
        }
        for (i = 10; i < 20; ++i) {
            regionGroupId2 = new TConsensusGroupId(TConsensusGroupType.DataRegion, i);
            dataNodeLocations = new ArrayList();
            regionStatistics = new TreeMap();
            for (int j = 3; j < 6; ++j) {
                dataNodeLocations.add(new TDataNodeLocation().setDataNodeId(j));
                regionStatistics.put(j, new RegionStatistics(j == 4 ? RegionStatus.ReadOnly : RegionStatus.Running));
            }
            regionReplicaSet = new TRegionReplicaSet(regionGroupId2, dataNodeLocations);
            regionReplicaSetMap.put(regionGroupId2, regionReplicaSet.getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toSet()));
            regionLeaderMap.put(regionGroupId2, 4);
            regionStatisticsMap.put(regionGroupId2, regionStatistics);
        }
        Map leaderDistribution = BALANCER.generateOptimalLeaderDistribution(new TreeMap(), regionReplicaSetMap, regionLeaderMap, dataNodeStatisticsMap, regionStatisticsMap);
        ConcurrentHashMap leaderCounter = new ConcurrentHashMap();
        leaderDistribution.forEach((regionGroupId, leaderId) -> leaderCounter.computeIfAbsent(leaderId, empty -> new AtomicInteger(0)).getAndIncrement());
        for (int i2 = 0; i2 < 6; ++i2) {
            if (i2 == 1 || i2 == 4) continue;
            Assert.assertEquals((long)5L, (long)((AtomicInteger)leaderCounter.get(i2)).get());
        }
    }
}

