/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.router.leader;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.confignode.manager.load.balancer.router.leader.MinCostFlowLeaderBalancer;
import org.apache.iotdb.confignode.manager.load.cache.node.NodeStatistics;
import org.apache.iotdb.confignode.manager.load.cache.region.RegionStatistics;
import org.junit.Assert;
import org.junit.Test;

public class CFDLeaderBalancerTest {
    private static final MinCostFlowLeaderBalancer BALANCER = new MinCostFlowLeaderBalancer();
    private static final String DATABASE = "root.database";

    @Test
    public void optimalLeaderDistributionTest() {
        ArrayList<TConsensusGroupId> regionGroupIds = new ArrayList<TConsensusGroupId>();
        for (int i = 0; i < 3; ++i) {
            regionGroupIds.add(new TConsensusGroupId(TConsensusGroupType.DataRegion, i));
        }
        ArrayList<TDataNodeLocation> dataNodeLocations = new ArrayList<TDataNodeLocation>();
        for (int i = 0; i < 4; ++i) {
            dataNodeLocations.add(new TDataNodeLocation().setDataNodeId(i));
        }
        ArrayList<TRegionReplicaSet> regionReplicaSets = new ArrayList<TRegionReplicaSet>();
        TreeMap regionStatisticsMap = new TreeMap();
        regionReplicaSets.add(new TRegionReplicaSet((TConsensusGroupId)regionGroupIds.get(0), Arrays.asList((TDataNodeLocation)dataNodeLocations.get(0), (TDataNodeLocation)dataNodeLocations.get(1), (TDataNodeLocation)dataNodeLocations.get(2))));
        TreeMap<Integer, RegionStatistics> region0 = new TreeMap<Integer, RegionStatistics>();
        region0.put(0, new RegionStatistics(RegionStatus.Unknown));
        region0.put(1, new RegionStatistics(RegionStatus.Running));
        region0.put(2, new RegionStatistics(RegionStatus.Running));
        regionStatisticsMap.put((TConsensusGroupId)regionGroupIds.get(0), region0);
        regionReplicaSets.add(new TRegionReplicaSet((TConsensusGroupId)regionGroupIds.get(1), Arrays.asList((TDataNodeLocation)dataNodeLocations.get(0), (TDataNodeLocation)dataNodeLocations.get(1), (TDataNodeLocation)dataNodeLocations.get(3))));
        TreeMap<Integer, RegionStatistics> region1 = new TreeMap<Integer, RegionStatistics>();
        region1.put(0, new RegionStatistics(RegionStatus.Unknown));
        region1.put(1, new RegionStatistics(RegionStatus.Running));
        region1.put(3, new RegionStatistics(RegionStatus.Running));
        regionStatisticsMap.put((TConsensusGroupId)regionGroupIds.get(1), region1);
        regionReplicaSets.add(new TRegionReplicaSet((TConsensusGroupId)regionGroupIds.get(2), Arrays.asList((TDataNodeLocation)dataNodeLocations.get(0), (TDataNodeLocation)dataNodeLocations.get(2), (TDataNodeLocation)dataNodeLocations.get(3))));
        TreeMap<Integer, RegionStatistics> region2 = new TreeMap<Integer, RegionStatistics>();
        region2.put(0, new RegionStatistics(RegionStatus.Unknown));
        region2.put(2, new RegionStatistics(RegionStatus.Running));
        region2.put(3, new RegionStatistics(RegionStatus.Running));
        regionStatisticsMap.put((TConsensusGroupId)regionGroupIds.get(2), region2);
        TreeMap<String, ArrayList<TConsensusGroupId>> databaseRegionGroupMap = new TreeMap<String, ArrayList<TConsensusGroupId>>();
        databaseRegionGroupMap.put(DATABASE, regionGroupIds);
        TreeMap regionReplicaSetMap = new TreeMap();
        regionReplicaSets.forEach(regionReplicaSet -> regionReplicaSetMap.put(regionReplicaSet.getRegionId(), regionReplicaSet.getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toSet())));
        TreeMap regionLeaderMap = new TreeMap();
        regionReplicaSets.forEach(regionReplicaSet -> regionLeaderMap.put(regionReplicaSet.getRegionId(), 0));
        TreeMap<Integer, NodeStatistics> dataNodeStatisticsMap = new TreeMap<Integer, NodeStatistics>();
        dataNodeStatisticsMap.put(0, new NodeStatistics(NodeStatus.Unknown));
        dataNodeStatisticsMap.put(1, new NodeStatistics(NodeStatus.Running));
        dataNodeStatisticsMap.put(2, new NodeStatistics(NodeStatus.Running));
        dataNodeStatisticsMap.put(3, new NodeStatistics(NodeStatus.Running));
        Map leaderDistribution = BALANCER.generateOptimalLeaderDistribution(databaseRegionGroupMap, regionReplicaSetMap, regionLeaderMap, dataNodeStatisticsMap, regionStatisticsMap);
        Assert.assertEquals((long)3L, (long)leaderDistribution.size());
        Assert.assertEquals((long)3L, (long)new HashSet(leaderDistribution.values()).size());
        Assert.assertEquals((long)3L, (long)BALANCER.getMaximumFlow());
        Assert.assertEquals((long)9L, (long)BALANCER.getMinimumCost());
    }

    @Test
    public void disableTest() {
        TRegionReplicaSet regionReplicaSet = new TRegionReplicaSet(new TConsensusGroupId(TConsensusGroupType.DataRegion, 0), Arrays.asList(new TDataNodeLocation().setDataNodeId(0), new TDataNodeLocation().setDataNodeId(1), new TDataNodeLocation().setDataNodeId(2)));
        TreeMap<String, List<TConsensusGroupId>> databaseRegionGroupMap = new TreeMap<String, List<TConsensusGroupId>>();
        databaseRegionGroupMap.put(DATABASE, Collections.singletonList(regionReplicaSet.getRegionId()));
        TreeMap regionReplicaSetMap = new TreeMap();
        regionReplicaSetMap.put(regionReplicaSet.getRegionId(), regionReplicaSet.getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toSet()));
        TreeMap<TConsensusGroupId, Integer> regionLeaderMap = new TreeMap<TConsensusGroupId, Integer>();
        regionLeaderMap.put(regionReplicaSet.getRegionId(), 1);
        TreeMap<Integer, NodeStatistics> nodeStatisticsMap = new TreeMap<Integer, NodeStatistics>();
        nodeStatisticsMap.put(0, new NodeStatistics(NodeStatus.Unknown));
        nodeStatisticsMap.put(1, new NodeStatistics(NodeStatus.ReadOnly));
        nodeStatisticsMap.put(2, new NodeStatistics(NodeStatus.Removing));
        TreeMap regionStatisticsMap = new TreeMap();
        TreeMap<Integer, RegionStatistics> regionStatistics = new TreeMap<Integer, RegionStatistics>();
        regionStatistics.put(0, new RegionStatistics(RegionStatus.Running));
        regionStatistics.put(1, new RegionStatistics(RegionStatus.Running));
        regionStatistics.put(2, new RegionStatistics(RegionStatus.Running));
        regionStatisticsMap.put(regionReplicaSet.getRegionId(), regionStatistics);
        Map leaderDistribution = BALANCER.generateOptimalLeaderDistribution(databaseRegionGroupMap, regionReplicaSetMap, regionLeaderMap, nodeStatisticsMap, regionStatisticsMap);
        Assert.assertEquals((long)1L, (long)leaderDistribution.size());
        Assert.assertEquals((long)1L, (long)new HashSet(leaderDistribution.values()).size());
        Assert.assertEquals(regionLeaderMap.get(regionReplicaSet.getRegionId()), leaderDistribution.get(regionReplicaSet.getRegionId()));
        Assert.assertEquals((long)0L, (long)BALANCER.getMaximumFlow());
        Assert.assertEquals((long)0L, (long)BALANCER.getMinimumCost());
    }

    @Test
    public void migrateTest() {
        TreeMap<Integer, NodeStatistics> nodeStatisticsMap = new TreeMap<Integer, NodeStatistics>();
        nodeStatisticsMap.put(0, new NodeStatistics(NodeStatus.Running));
        nodeStatisticsMap.put(1, new NodeStatistics(NodeStatus.Running));
        TreeMap<String, List> databaseRegionGroupMap = new TreeMap<String, List>();
        TreeMap regionReplicaSetMap = new TreeMap();
        TreeMap<TConsensusGroupId, Integer> regionLeaderMap = new TreeMap<TConsensusGroupId, Integer>();
        TreeMap regionStatisticsMap = new TreeMap();
        for (int i = 0; i < 5; ++i) {
            TConsensusGroupId regionGroupId = new TConsensusGroupId(TConsensusGroupType.DataRegion, i);
            databaseRegionGroupMap.computeIfAbsent(DATABASE, empty -> new ArrayList()).add(regionGroupId);
            TRegionReplicaSet regionReplicaSet = new TRegionReplicaSet(regionGroupId, Arrays.asList(new TDataNodeLocation().setDataNodeId(0), new TDataNodeLocation().setDataNodeId(1)));
            regionReplicaSetMap.put(regionGroupId, regionReplicaSet.getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toSet()));
            regionLeaderMap.put(regionGroupId, 0);
            TreeMap<Integer, RegionStatistics> regionStatistics = new TreeMap<Integer, RegionStatistics>();
            regionStatistics.put(0, new RegionStatistics(RegionStatus.Removing));
            regionStatistics.put(1, new RegionStatistics(RegionStatus.Running));
            regionStatisticsMap.put(regionGroupId, regionStatistics);
        }
        Map leaderDistribution = BALANCER.generateOptimalLeaderDistribution(databaseRegionGroupMap, regionReplicaSetMap, regionLeaderMap, nodeStatisticsMap, regionStatisticsMap);
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((long)1L, (long)((Integer)leaderDistribution.get(new TConsensusGroupId(TConsensusGroupType.DataRegion, i))).intValue());
        }
    }

    @Test
    public void bigClusterTest() {
        int regionGroupNum = 1500;
        int dataNodeNum = 300;
        int replicationFactor = 3;
        TreeMap<Integer, NodeStatistics> dataNodeStatisticsMap = new TreeMap<Integer, NodeStatistics>();
        for (int i = 0; i < 300; ++i) {
            dataNodeStatisticsMap.put(i, new NodeStatistics(NodeStatus.Running));
        }
        int x = 5;
        int loadCost = x * (x + 1) * (2 * x + 1) / 3;
        int dataNodeId = 0;
        Random random = new Random();
        TreeMap databaseRegionGroupMap = new TreeMap();
        databaseRegionGroupMap.put(DATABASE, new ArrayList());
        TreeMap regionReplicaSetMap = new TreeMap();
        TreeMap<TConsensusGroupId, Integer> regionLeaderMap = new TreeMap<TConsensusGroupId, Integer>();
        TreeMap regionStatisticsMap = new TreeMap();
        for (int i = 0; i < 1500; ++i) {
            TConsensusGroupId regionGroupId2 = new TConsensusGroupId(TConsensusGroupType.DataRegion, i);
            int leaderId2 = (dataNodeId + random.nextInt(3)) % 300;
            TRegionReplicaSet regionReplicaSet = new TRegionReplicaSet();
            regionReplicaSet.setRegionId(regionGroupId2);
            TreeMap<Integer, RegionStatistics> regionStatistics = new TreeMap<Integer, RegionStatistics>();
            for (int j = 0; j < 3; ++j) {
                regionReplicaSet.addToDataNodeLocations(new TDataNodeLocation().setDataNodeId(dataNodeId));
                regionStatistics.put(dataNodeId, new RegionStatistics(RegionStatus.Running));
                dataNodeId = (dataNodeId + 1) % 300;
            }
            regionStatisticsMap.put(regionGroupId2, regionStatistics);
            ((List)databaseRegionGroupMap.get(DATABASE)).add(regionGroupId2);
            regionReplicaSetMap.put(regionGroupId2, regionReplicaSet.getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toSet()));
            regionLeaderMap.put(regionGroupId2, leaderId2);
        }
        Map leaderDistribution = BALANCER.generateOptimalLeaderDistribution(databaseRegionGroupMap, regionReplicaSetMap, regionLeaderMap, dataNodeStatisticsMap, regionStatisticsMap);
        Assert.assertEquals((long)1500L, (long)leaderDistribution.size());
        ConcurrentHashMap leaderCounter = new ConcurrentHashMap();
        leaderDistribution.values().forEach(leaderId -> leaderCounter.merge(leaderId, 1, Integer::sum));
        Assert.assertEquals((long)300L, (long)leaderCounter.size());
        for (int i = 0; i < 300; ++i) {
            Assert.assertEquals((long)5L, (long)((Integer)leaderCounter.get(i)).intValue());
        }
        Assert.assertEquals((long)1500L, (long)BALANCER.getMaximumFlow());
        int minimumCost = BALANCER.getMinimumCost();
        Assert.assertTrue((minimumCost >= loadCost * 300 ? 1 : 0) != 0);
        int switchCost = minimumCost - loadCost * 300;
        AtomicInteger switchCount = new AtomicInteger(0);
        regionLeaderMap.forEach((regionGroupId, originLeader) -> {
            if (!Objects.equals(originLeader, leaderDistribution.get(regionGroupId))) {
                switchCount.getAndIncrement();
            }
        });
        Assert.assertEquals((long)switchCost, (long)switchCount.get());
        System.out.printf("MCF algorithm switch leader for %s times to construct a balanced leader distribution of 300 DataNodes and 1500 RegionGroups cluster.%n", switchCost);
    }
}

