/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.region;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.manager.load.balancer.region.GreedyRegionGroupAllocator;
import org.junit.Assert;
import org.junit.Test;

public class GreedyRegionGroupAllocatorTest {
    private static final GreedyRegionGroupAllocator ALLOCATOR = new GreedyRegionGroupAllocator();
    private static final int TEST_REPLICATION_FACTOR = 3;

    @Test
    public void testEvenDistribution() {
        ConcurrentHashMap<Integer, TDataNodeConfiguration> availableDataNodeMap = new ConcurrentHashMap<Integer, TDataNodeConfiguration>();
        ConcurrentHashMap<Integer, Double> freeSpaceMap = new ConcurrentHashMap<Integer, Double>();
        Random random = new Random();
        for (int i = 0; i < 6; ++i) {
            availableDataNodeMap.put(i, new TDataNodeConfiguration().setLocation(new TDataNodeLocation().setDataNodeId(i)));
            freeSpaceMap.put(i, random.nextDouble());
        }
        ArrayList<TRegionReplicaSet> allocatedRegionGroups = new ArrayList<TRegionReplicaSet>();
        for (int index = 0; index < 6; ++index) {
            TRegionReplicaSet newRegionGroup = ALLOCATOR.generateOptimalRegionReplicasDistribution(availableDataNodeMap, freeSpaceMap, allocatedRegionGroups, allocatedRegionGroups, 3, new TConsensusGroupId(TConsensusGroupType.DataRegion, index));
            allocatedRegionGroups.add(newRegionGroup);
        }
        ConcurrentHashMap<Integer, AtomicInteger> regionCounter = new ConcurrentHashMap<Integer, AtomicInteger>();
        allocatedRegionGroups.forEach(regionReplicaSet -> regionReplicaSet.getDataNodeLocations().forEach(dataNodeLocation -> regionCounter.computeIfAbsent(dataNodeLocation.getDataNodeId(), empty -> new AtomicInteger(0)).getAndIncrement()));
        Assert.assertEquals((long)6L, (long)regionCounter.size());
        regionCounter.forEach((dataNodeId, regionCount) -> Assert.assertEquals((long)3L, (long)regionCount.get()));
    }

    @Test
    public void testUnevenDistribution() {
        ConcurrentHashMap<Integer, TDataNodeConfiguration> availableDataNodeMap = new ConcurrentHashMap<Integer, TDataNodeConfiguration>();
        for (int i = 0; i < 4; ++i) {
            availableDataNodeMap.put(i, new TDataNodeConfiguration().setLocation(new TDataNodeLocation().setDataNodeId(i)));
        }
        ConcurrentHashMap<Integer, Double> freeSpaceMap = new ConcurrentHashMap<Integer, Double>();
        freeSpaceMap.put(0, 2.0000331E7);
        freeSpaceMap.put(1, 2.0000522E7);
        freeSpaceMap.put(2, 666.0);
        freeSpaceMap.put(3, 999.0);
        ArrayList<TRegionReplicaSet> allocatedRegionGroups = new ArrayList<TRegionReplicaSet>();
        TRegionReplicaSet newRegionGroup = ALLOCATOR.generateOptimalRegionReplicasDistribution(availableDataNodeMap, freeSpaceMap, allocatedRegionGroups, allocatedRegionGroups, 3, new TConsensusGroupId(TConsensusGroupType.SchemaRegion, 0));
        allocatedRegionGroups.add(newRegionGroup);
        HashSet dataNodeIdSet = new HashSet();
        newRegionGroup.getDataNodeLocations().forEach(dataNodeLocation -> dataNodeIdSet.add(dataNodeLocation.getDataNodeId()));
        Assert.assertTrue((boolean)dataNodeIdSet.contains(0));
        Assert.assertTrue((boolean)dataNodeIdSet.contains(1));
        Assert.assertTrue((boolean)dataNodeIdSet.contains(3));
        dataNodeIdSet.clear();
        newRegionGroup = ALLOCATOR.generateOptimalRegionReplicasDistribution(availableDataNodeMap, freeSpaceMap, allocatedRegionGroups, allocatedRegionGroups, 3, new TConsensusGroupId(TConsensusGroupType.SchemaRegion, 1));
        newRegionGroup.getDataNodeLocations().forEach(dataNodeLocation -> dataNodeIdSet.add(dataNodeLocation.getDataNodeId()));
        Assert.assertTrue((boolean)dataNodeIdSet.contains(0));
        Assert.assertTrue((boolean)dataNodeIdSet.contains(1));
        Assert.assertTrue((boolean)dataNodeIdSet.contains(2));
    }
}

