/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.region;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.manager.load.balancer.region.GreedyCopySetRegionGroupAllocator;
import org.apache.iotdb.confignode.manager.load.balancer.region.GreedyRegionGroupAllocator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreedyCopySetRegionGroupAllocatorTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(GreedyCopySetRegionGroupAllocatorTest.class);
    private static final GreedyRegionGroupAllocator GREEDY_ALLOCATOR = new GreedyRegionGroupAllocator();
    private static final GreedyCopySetRegionGroupAllocator GREEDY_COPY_SET_ALLOCATOR = new GreedyCopySetRegionGroupAllocator();
    private static final Random RANDOM = new Random();
    private static final int TEST_DATABASE_NUM = 3;
    private static final int TEST_DATA_NODE_NUM = 21;
    private static final int DATA_REGION_PER_DATA_NODE = 5;
    private static final Map<Integer, TDataNodeConfiguration> AVAILABLE_DATA_NODE_MAP = new HashMap<Integer, TDataNodeConfiguration>();
    private static final Map<Integer, Double> FREE_SPACE_MAP = new HashMap<Integer, Double>();

    @BeforeClass
    public static void setUp() {
        Random random = new Random();
        for (int i = 1; i <= 21; ++i) {
            AVAILABLE_DATA_NODE_MAP.put(i, new TDataNodeConfiguration().setLocation(new TDataNodeLocation().setDataNodeId(i)));
            FREE_SPACE_MAP.put(i, random.nextDouble());
        }
    }

    @Test
    public void test2Factor() {
        this.testRegionDistributionAndScatterWidth(2);
    }

    @Test
    public void test3Factor() {
        this.testRegionDistributionAndScatterWidth(3);
    }

    private void testRegionDistributionAndScatterWidth(int replicationFactor) {
        int i;
        int i2;
        int dataRegionGroupAllotment = 105 / replicationFactor;
        int dataRegionGroupPerDatabase = dataRegionGroupAllotment / 3;
        ArrayList<TRegionReplicaSet> greedyResult = new ArrayList<TRegionReplicaSet>();
        ArrayList<TRegionReplicaSet> greedyCopySetResult = new ArrayList<TRegionReplicaSet>();
        TreeMap greedyCopySetDatabaseResult = new TreeMap();
        TreeMap greedyRegionCounter = new TreeMap();
        TreeMap greedyCopySetRegionCounter = new TreeMap();
        TreeMap greedyCopySetDatabaseRegionCounter = new TreeMap();
        for (int i3 = 0; i3 < 3; ++i3) {
            greedyCopySetDatabaseResult.put(i3, new ArrayList());
        }
        for (int index = 0; index < dataRegionGroupPerDatabase * 3; ++index) {
            TRegionReplicaSet greedyRegionGroup = GREEDY_ALLOCATOR.generateOptimalRegionReplicasDistribution(AVAILABLE_DATA_NODE_MAP, FREE_SPACE_MAP, greedyResult, greedyResult, replicationFactor, new TConsensusGroupId(TConsensusGroupType.DataRegion, index));
            greedyResult.add(greedyRegionGroup);
            greedyRegionGroup.getDataNodeLocations().forEach(dataNodeLocation -> greedyRegionCounter.merge(dataNodeLocation.getDataNodeId(), 1, Integer::sum));
            int databaseId = RANDOM.nextInt(3);
            TRegionReplicaSet greedyCopySetRegionGroup = GREEDY_COPY_SET_ALLOCATOR.generateOptimalRegionReplicasDistribution(AVAILABLE_DATA_NODE_MAP, FREE_SPACE_MAP, greedyCopySetResult, (List)greedyCopySetDatabaseResult.get(databaseId), replicationFactor, new TConsensusGroupId(TConsensusGroupType.DataRegion, index));
            greedyCopySetResult.add(greedyCopySetRegionGroup);
            ((List)greedyCopySetDatabaseResult.get(databaseId)).add(greedyCopySetRegionGroup);
            greedyCopySetRegionGroup.getDataNodeLocations().forEach(dataNodeLocation -> {
                greedyCopySetRegionCounter.merge(dataNodeLocation.getDataNodeId(), 1, Integer::sum);
                greedyCopySetDatabaseRegionCounter.computeIfAbsent(databaseId, empty -> new TreeMap()).merge(dataNodeLocation.getDataNodeId(), 1, Integer::sum);
            });
            LOGGER.info("After allocate RegionGroup: {}, Database: {}, plan: {}", new Object[]{index, databaseId, greedyCopySetRegionGroup.getDataNodeLocations().stream().map(TDataNodeLocation::getDataNodeId).collect(Collectors.toList())});
            for (i2 = 0; i2 < 3; ++i2) {
                LOGGER.info("Database {}: {}", (Object)i2, greedyCopySetDatabaseRegionCounter.get(i2));
            }
            LOGGER.info("Cluster   : {}", greedyCopySetRegionCounter);
            for (i2 = 1; i2 <= 21; ++i2) {
                Assert.assertTrue((greedyCopySetRegionCounter.getOrDefault(i2, 0) <= 5 ? 1 : 0) != 0);
            }
        }
        TreeMap<Integer, BitSet> greedyScatterWidth = new TreeMap<Integer, BitSet>();
        for (TRegionReplicaSet replicaSet : greedyResult) {
            for (int i4 = 0; i4 < replicationFactor; ++i4) {
                for (int j = i4 + 1; j < replicationFactor; ++j) {
                    int dataNodeId1 = ((TDataNodeLocation)replicaSet.getDataNodeLocations().get(i4)).getDataNodeId();
                    int dataNodeId2 = ((TDataNodeLocation)replicaSet.getDataNodeLocations().get(j)).getDataNodeId();
                    greedyScatterWidth.computeIfAbsent(dataNodeId1, empty -> new BitSet()).set(dataNodeId2);
                    greedyScatterWidth.computeIfAbsent(dataNodeId2, empty -> new BitSet()).set(dataNodeId1);
                }
            }
        }
        TreeMap<Integer, BitSet> greedyCopySetScatterWidth = new TreeMap<Integer, BitSet>();
        for (TRegionReplicaSet replicaSet : greedyCopySetResult) {
            for (i2 = 0; i2 < replicationFactor; ++i2) {
                for (int j = i2 + 1; j < replicationFactor; ++j) {
                    int dataNodeId1 = ((TDataNodeLocation)replicaSet.getDataNodeLocations().get(i2)).getDataNodeId();
                    int dataNodeId2 = ((TDataNodeLocation)replicaSet.getDataNodeLocations().get(j)).getDataNodeId();
                    greedyCopySetScatterWidth.computeIfAbsent(dataNodeId1, empty -> new BitSet()).set(dataNodeId2);
                    greedyCopySetScatterWidth.computeIfAbsent(dataNodeId2, empty -> new BitSet()).set(dataNodeId1);
                }
            }
        }
        int greedyScatterWidthSum = 0;
        int greedyMinScatterWidth = Integer.MAX_VALUE;
        int greedyMaxScatterWidth = Integer.MIN_VALUE;
        int greedyCopySetScatterWidthSum = 0;
        int greedyCopySetMinScatterWidth = Integer.MAX_VALUE;
        int greedyCopySetMaxScatterWidth = Integer.MIN_VALUE;
        int greedyCopySetMaxRegionCount = 0;
        int greedyCopySetMinRegionCount = Integer.MAX_VALUE;
        for (i = 1; i <= 21; ++i) {
            Assert.assertTrue(((Integer)greedyRegionCounter.get(i) <= 5 ? 1 : 0) != 0);
            Assert.assertTrue(((Integer)greedyCopySetRegionCounter.get(i) <= 5 ? 1 : 0) != 0);
            greedyCopySetMinRegionCount = Math.min(greedyCopySetMinRegionCount, (Integer)greedyCopySetRegionCounter.get(i));
            greedyCopySetMaxRegionCount = Math.max(greedyCopySetMaxRegionCount, (Integer)greedyCopySetRegionCounter.get(i));
            int scatterWidth = ((BitSet)greedyScatterWidth.get(i)).cardinality();
            greedyScatterWidthSum += scatterWidth;
            greedyMinScatterWidth = Math.min(greedyMinScatterWidth, scatterWidth);
            greedyMaxScatterWidth = Math.max(greedyMaxScatterWidth, scatterWidth);
            scatterWidth = ((BitSet)greedyCopySetScatterWidth.get(i)).cardinality();
            greedyCopySetScatterWidthSum += scatterWidth;
            greedyCopySetMinScatterWidth = Math.min(greedyCopySetMinScatterWidth, scatterWidth);
            greedyCopySetMaxScatterWidth = Math.max(greedyCopySetMaxScatterWidth, scatterWidth);
        }
        Assert.assertTrue((greedyCopySetMaxRegionCount - greedyCopySetMinRegionCount <= 1 ? 1 : 0) != 0);
        for (i = 0; i < 3; ++i) {
            greedyCopySetMaxRegionCount = 0;
            greedyCopySetMinRegionCount = Integer.MAX_VALUE;
            if (greedyCopySetDatabaseRegionCounter.containsKey(i)) continue;
            for (int j = 1; j <= 21; ++j) {
                if (!((Map)greedyCopySetDatabaseRegionCounter.get(i)).containsKey(j)) continue;
                greedyCopySetMinRegionCount = Math.min(greedyCopySetMinRegionCount, (Integer)((Map)greedyCopySetDatabaseRegionCounter.get(i)).get(j));
                greedyCopySetMaxRegionCount = Math.max(greedyCopySetMaxRegionCount, (Integer)((Map)greedyCopySetDatabaseRegionCounter.get(i)).get(j));
            }
            Assert.assertTrue((greedyCopySetMaxRegionCount - greedyCopySetMinRegionCount <= 1 ? 1 : 0) != 0);
        }
        LOGGER.info("replicationFactor: {}, Scatter width for greedy: avg={}, min={}, max={}", new Object[]{replicationFactor, (double)greedyScatterWidthSum / 21.0, greedyMinScatterWidth, greedyMaxScatterWidth});
        LOGGER.info("replicationFactor: {}, Scatter width for greedyCopySet: avg={}, min={}, max={}", new Object[]{replicationFactor, (double)greedyCopySetScatterWidthSum / 21.0, greedyCopySetMinScatterWidth, greedyCopySetMaxScatterWidth});
        Assert.assertTrue((greedyCopySetScatterWidthSum >= greedyScatterWidthSum ? 1 : 0) != 0);
        Assert.assertTrue((greedyCopySetMaxScatterWidth >= greedyMaxScatterWidth ? 1 : 0) != 0);
        Assert.assertTrue((greedyCopySetMinScatterWidth >= greedyMinScatterWidth ? 1 : 0) != 0);
    }
}

