/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.region;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.confignode.manager.load.balancer.region.GreedyRegionGroupAllocator;
import org.apache.iotdb.confignode.manager.load.balancer.region.IRegionGroupAllocator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocatorScatterWidthManualTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(AllocatorScatterWidthManualTest.class);
    private static final IRegionGroupAllocator ALLOCATOR = new GreedyRegionGroupAllocator();
    private static final int TEST_DATA_NODE_NUM = 50;
    private static final int DATA_REGION_PER_DATA_NODE = 5;
    private static final int DATA_REPLICATION_FACTOR = 3;
    private static final Map<Integer, TDataNodeConfiguration> AVAILABLE_DATA_NODE_MAP = new HashMap<Integer, TDataNodeConfiguration>();
    private static final Map<Integer, Double> FREE_SPACE_MAP = new HashMap<Integer, Double>();

    @BeforeClass
    public static void setUp() {
        Random random = new Random();
        for (int i = 1; i <= 50; ++i) {
            AVAILABLE_DATA_NODE_MAP.put(i, new TDataNodeConfiguration().setLocation(new TDataNodeLocation().setDataNodeId(i)));
            FREE_SPACE_MAP.put(i, random.nextDouble());
        }
    }

    @Test
    public void testScatterWidth() {
        int dataRegionGroupNum = 83;
        long startTime = System.currentTimeMillis();
        ArrayList<TRegionReplicaSet> allocateResult = new ArrayList<TRegionReplicaSet>();
        for (int index = 0; index < 83; ++index) {
            allocateResult.add(ALLOCATOR.generateOptimalRegionReplicasDistribution(AVAILABLE_DATA_NODE_MAP, FREE_SPACE_MAP, allocateResult, allocateResult, 3, new TConsensusGroupId(TConsensusGroupType.DataRegion, index)));
        }
        long endTime = System.currentTimeMillis();
        HashMap regionCounter = new HashMap();
        allocateResult.forEach(regionReplicaSet -> regionReplicaSet.getDataNodeLocations().forEach(dataNodeLocation -> regionCounter.merge(dataNodeLocation.getDataNodeId(), 1, Integer::sum)));
        HashMap<Integer, BitSet> scatterWidthMap = new HashMap<Integer, BitSet>();
        for (TRegionReplicaSet replicaSet : allocateResult) {
            for (int i = 0; i < 3; ++i) {
                for (int j = i + 1; j < 3; ++j) {
                    int dataNodeId1 = ((TDataNodeLocation)replicaSet.getDataNodeLocations().get(i)).getDataNodeId();
                    int dataNodeId2 = ((TDataNodeLocation)replicaSet.getDataNodeLocations().get(j)).getDataNodeId();
                    scatterWidthMap.computeIfAbsent(dataNodeId1, empty -> new BitSet()).set(dataNodeId2);
                    scatterWidthMap.computeIfAbsent(dataNodeId2, empty -> new BitSet()).set(dataNodeId1);
                }
            }
        }
        int scatterWidthSum = 0;
        int minScatterWidth = Integer.MAX_VALUE;
        int maxScatterWidth = Integer.MIN_VALUE;
        for (int i = 1; i <= 50; ++i) {
            Assert.assertTrue(((Integer)regionCounter.get(i) <= 5 ? 1 : 0) != 0);
            int scatterWidth = ((BitSet)scatterWidthMap.get(i)).cardinality();
            scatterWidthSum += scatterWidth;
            minScatterWidth = Math.min(minScatterWidth, scatterWidth);
            maxScatterWidth = Math.max(maxScatterWidth, scatterWidth);
        }
        LOGGER.info("Test {}:", (Object)ALLOCATOR.getClass().getSimpleName());
        LOGGER.info("Allocate {} DataRegionGroups for {} DataNodes in {}ms", new Object[]{83, 50, endTime - startTime});
        LOGGER.info("Scatter width avg: {}, min: {}, max: {}", new Object[]{(double)scatterWidthSum / 50.0, minScatterWidth, maxScatterWidth});
    }
}

