/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer.partition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.manager.load.balancer.partition.DataPartitionPolicyTable;
import org.junit.Assert;
import org.junit.Test;

public class DataPartitionPolicyTableTest {
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final int SERIES_SLOT_NUM = CONF.getSeriesSlotNum();

    @Test
    public void testUpdateDataAllotTable() {
        DataPartitionPolicyTable dataPartitionPolicyTable = new DataPartitionPolicyTable();
        ArrayList<TConsensusGroupId> dataRegionGroups = new ArrayList<TConsensusGroupId>();
        TConsensusGroupId group1 = new TConsensusGroupId(TConsensusGroupType.DataRegion, 1);
        dataRegionGroups.add(group1);
        dataPartitionPolicyTable.reBalanceDataPartitionPolicy(dataRegionGroups);
        for (int i = 0; i < SERIES_SLOT_NUM; ++i) {
            TSeriesPartitionSlot seriesPartitionSlot = new TSeriesPartitionSlot(i);
            Assert.assertEquals((Object)group1, (Object)dataPartitionPolicyTable.getRegionGroupIdOrActivateIfNecessary(seriesPartitionSlot));
        }
        HashMap<TSeriesPartitionSlot, TConsensusGroupId> lastDataAllotTable = new HashMap<TSeriesPartitionSlot, TConsensusGroupId>();
        dataRegionGroups.add(new TConsensusGroupId(TConsensusGroupType.DataRegion, 2));
        dataRegionGroups.add(new TConsensusGroupId(TConsensusGroupType.DataRegion, 3));
        dataPartitionPolicyTable.reBalanceDataPartitionPolicy(dataRegionGroups);
        int mu = SERIES_SLOT_NUM / 3;
        HashMap<TConsensusGroupId, AtomicInteger> counter = new HashMap<TConsensusGroupId, AtomicInteger>();
        for (int i = 0; i < SERIES_SLOT_NUM; ++i) {
            TSeriesPartitionSlot seriesPartitionSlot = new TSeriesPartitionSlot(i);
            TConsensusGroupId groupId = dataPartitionPolicyTable.getRegionGroupIdOrActivateIfNecessary(seriesPartitionSlot);
            lastDataAllotTable.put(seriesPartitionSlot, groupId);
            counter.computeIfAbsent(groupId, empty -> new AtomicInteger(0)).incrementAndGet();
        }
        for (Map.Entry counterEntry : counter.entrySet()) {
            Assert.assertTrue((Math.abs(((AtomicInteger)counterEntry.getValue()).get() - mu) <= 1 ? 1 : 0) != 0);
        }
        dataRegionGroups.add(new TConsensusGroupId(TConsensusGroupType.DataRegion, 4));
        dataRegionGroups.add(new TConsensusGroupId(TConsensusGroupType.DataRegion, 5));
        dataPartitionPolicyTable.reBalanceDataPartitionPolicy(dataRegionGroups);
        HashMap<TConsensusGroupId, AtomicInteger> unchangedSlots = new HashMap<TConsensusGroupId, AtomicInteger>();
        mu = SERIES_SLOT_NUM / 5;
        counter.clear();
        for (int i = 0; i < SERIES_SLOT_NUM; ++i) {
            TSeriesPartitionSlot seriesPartitionSlot = new TSeriesPartitionSlot(i);
            TConsensusGroupId groupId = dataPartitionPolicyTable.getRegionGroupIdOrActivateIfNecessary(seriesPartitionSlot);
            counter.computeIfAbsent(groupId, empty -> new AtomicInteger(0)).incrementAndGet();
            if (groupId.getId() >= 4) continue;
            Assert.assertEquals(lastDataAllotTable.get(seriesPartitionSlot), (Object)groupId);
            unchangedSlots.computeIfAbsent(groupId, empty -> new AtomicInteger(0)).incrementAndGet();
        }
        for (Map.Entry counterEntry : counter.entrySet()) {
            Assert.assertTrue((Math.abs(((AtomicInteger)counterEntry.getValue()).get() - mu) <= 1 ? 1 : 0) != 0);
        }
        for (Map.Entry counterEntry : unchangedSlots.entrySet()) {
            Assert.assertEquals((long)mu, (long)((AtomicInteger)counterEntry.getValue()).get());
        }
    }
}

